/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.multitabs.impl;

import java.awt.Color;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.TableUI;
import javax.swing.plaf.basic.BasicTableUI;
import org.netbeans.core.multitabs.impl.TabTable;

final class TabTableUI
extends BasicTableUI {
    static final boolean IS_AQUA = "Aqua".equals(UIManager.getLookAndFeel().getID());
    private boolean hoverSupport;
    private int hoverRow = -1;
    private int hoverColumn = -1;

    TabTableUI() {
    }

    static Border createTabBorder(JTable table, int tabsLocation) {
        if (IS_AQUA) {
            return BorderFactory.createMatteBorder(1, 0, 0, 0, table.getGridColor());
        }
        if (tabsLocation != 1 && !UIManager.getBoolean("nb.multitabs.noTabBorder")) {
            return BorderFactory.createMatteBorder(1, 0, 0, 0, table.getGridColor());
        }
        return BorderFactory.createEmptyBorder();
    }

    static boolean isHover(JTable table, int row, int column) {
        TableUI ui = table.getUI();
        if (!(ui instanceof TabTableUI)) {
            return false;
        }
        TabTableUI tabUI = (TabTableUI)ui;
        return tabUI.hoverRow == row && tabUI.hoverColumn == column;
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        String lafId = UIManager.getLookAndFeel().getID();
        if ("Windows".equals(lafId)) {
            Color background = UIManager.getColor("TabbedPane.background");
            Color highglightBackground = UIManager.getColor("TabbedPane.highlight");
            if (null != background && null != highglightBackground) {
                int factor = 16;
                this.table.setBackground(new Color(Math.max(background.getRed() - 16, 0), Math.max(background.getGreen() - 16, 0), Math.max(background.getBlue() - 16, 0)));
                this.table.setSelectionBackground(highglightBackground);
                this.table.setSelectionForeground(this.table.getForeground());
            }
        } else if ("Metal".equals(lafId)) {
            Color background = UIManager.getColor("inactiveCaption");
            Color highglightBackground = UIManager.getColor("activeCaption");
            if (null != background && null != highglightBackground) {
                this.table.setBackground(background);
                this.table.setSelectionBackground(highglightBackground);
                this.table.setSelectionForeground(this.table.getForeground());
            }
        } else if ("Nimbus".equals(lafId) || "GTK".equals(lafId)) {
            Color highglightBackground = UIManager.getColor("TabbedPane.highlight");
            Color background = UIManager.getColor("TabbedPane.background");
            if (null != background && null != highglightBackground) {
                this.table.setBackground(new Color(background.getRGB()));
                this.table.setSelectionBackground(new Color(highglightBackground.getRGB()));
                this.table.setSelectionForeground(new Color(this.table.getForeground().getRGB()));
                Color grid = UIManager.getColor("InternalFrame.borderShadow");
                if (null == grid) {
                    grid = UIManager.getColor("controlDkShadow");
                }
                if (null != grid) {
                    this.table.setGridColor(new Color(grid.getRGB()));
                }
            }
            this.table.setShowGrid(true);
        } else if ("Aqua".equals(lafId)) {
            this.table.setShowGrid(true);
            this.table.setBackground(new Color(178, 178, 178));
            this.table.setSelectionBackground(new Color(226, 226, 226));
            this.table.setSelectionForeground(this.table.getForeground());
            this.table.setGridColor(new Color(49, 49, 49));
            Font txtFont = (Font)UIManager.get("windowTitleFont");
            if (txtFont == null) {
                txtFont = new Font("Dialog", 0, 11);
            } else if (txtFont.isBold()) {
                txtFont = new Font(txtFont.getName(), 0, txtFont.getSize());
            }
            this.table.setFont(txtFont);
        } else {
            Color background = UIManager.getColor("nb.multitabs.background");
            Color foreground = UIManager.getColor("nb.multitabs.foreground");
            Color selectedBackground = UIManager.getColor("nb.multitabs.selectedBackground");
            Color selectedForeground = UIManager.getColor("nb.multitabs.selectedForeground");
            Color gridColor = UIManager.getColor("nb.multitabs.gridColor");
            if (background != null) {
                this.table.setBackground(background);
            }
            if (foreground != null) {
                this.table.setForeground(foreground);
            }
            if (selectedBackground != null) {
                this.table.setSelectionBackground(selectedBackground);
            }
            if (selectedForeground != null) {
                this.table.setSelectionForeground(selectedForeground);
            }
            if (gridColor != null) {
                this.table.setGridColor(gridColor);
            }
            this.hoverSupport = UIManager.getColor("nb.multitabs.hoverBackground") != null;
        }
    }

    @Override
    protected void installKeyboardActions() {
    }

    @Override
    protected MouseInputListener createMouseInputListener() {
        final MouseInputListener orig = super.createMouseInputListener();
        return new MouseInputListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                orig.mouseClicked(e);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                TabTable tabTable = (TabTable)TabTableUI.this.table;
                Point p = e.getPoint();
                int row = TabTableUI.this.table.rowAtPoint(p);
                int col = TabTableUI.this.table.columnAtPoint(p);
                if (row >= 0 && col >= 0 && tabTable.isCloseButtonHighlighted(row, col)) {
                    return;
                }
                orig.mousePressed(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                orig.mouseReleased(e);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                orig.mouseEntered(e);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                orig.mouseExited(e);
                if (TabTableUI.this.hoverSupport) {
                    this.setHover(-1, -1);
                }
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                orig.mouseDragged(e);
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                orig.mouseMoved(e);
                if (TabTableUI.this.hoverSupport) {
                    Point p = e.getPoint();
                    int row = TabTableUI.this.table.rowAtPoint(p);
                    int column = TabTableUI.this.table.columnAtPoint(p);
                    this.setHover(row, column);
                }
            }

            private void setHover(int row, int column) {
                if (row == TabTableUI.this.hoverRow && column == TabTableUI.this.hoverColumn) {
                    return;
                }
                int oldRow = TabTableUI.this.hoverRow;
                int oldColumn = TabTableUI.this.hoverColumn;
                TabTableUI.this.hoverRow = row;
                TabTableUI.this.hoverColumn = column;
                if (oldRow != -1 && oldColumn != -1) {
                    TabTableUI.this.table.repaint(TabTableUI.this.table.getCellRect(oldRow, oldColumn, true));
                }
                if (row != -1 && column != -1) {
                    TabTableUI.this.table.repaint(TabTableUI.this.table.getCellRect(row, column, true));
                }
            }
        };
    }
}

