/*
 * Decompiled with CFR 0.152.
 */
package firrtl.util;

import firrtl.FileUtils$;
import firrtl.transforms.BlackBoxSourceHelper$;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import logger.LazyLogging;
import logger.Logger;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.package$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.sys.process.Process$;
import scala.sys.process.ProcessBuilder;
import scala.sys.process.ProcessLogger;
import scala.sys.process.ProcessLogger$;

public final class BackendCompilationUtilities$
implements LazyLogging {
    public static final BackendCompilationUtilities$ MODULE$ = new BackendCompilationUtilities$();
    private static File TestDirectory;
    private static Logger logger;
    private static volatile boolean bitmap$0;

    static {
        LazyLogging.$init$(MODULE$);
    }

    @Override
    public Logger getLogger() {
        return LazyLogging.getLogger$(this);
    }

    @Override
    public Logger logger() {
        return logger;
    }

    @Override
    public void logger$LazyLogging$_setter_$logger_$eq(Logger x$1) {
        logger = x$1;
    }

    private File TestDirectory$lzycompute() {
        BackendCompilationUtilities$ backendCompilationUtilities$ = this;
        synchronized (backendCompilationUtilities$) {
            if (!bitmap$0) {
                TestDirectory = new File("test_run_dir");
                bitmap$0 = true;
            }
        }
        return TestDirectory;
    }

    public File TestDirectory() {
        return !bitmap$0 ? this.TestDirectory$lzycompute() : TestDirectory;
    }

    public String timeStamp() {
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmss");
        Date now = Calendar.getInstance().getTime();
        return format.format(now);
    }

    public ProcessLogger loggingProcessLogger() {
        return ProcessLogger$.MODULE$.apply((Function1<String, BoxedUnit>)(Function1<String, Object> & Serializable)x$1 -> {
            BackendCompilationUtilities$.$anonfun$loggingProcessLogger$1(x$1);
            return BoxedUnit.UNIT;
        }, (Function1<String, BoxedUnit>)(Function1<String, Object> & Serializable)x$2 -> {
            BackendCompilationUtilities$.$anonfun$loggingProcessLogger$3(x$2);
            return BoxedUnit.UNIT;
        });
    }

    public void copyResourceToFile(String name, File file) {
        InputStream in = this.getClass().getResourceAsStream(name);
        if (in == null) {
            throw new FileNotFoundException(new StringBuilder(11).append("Resource '").append(name).append("'").toString());
        }
        FileOutputStream out = new FileOutputStream(file);
        package$.MODULE$.Iterator().continually(() -> in.read()).takeWhile(x$3 -> -1 != x$3).foreach(x$1 -> out.write(x$1));
        out.close();
    }

    public File createTestDirectory(String testName) {
        File outer = new File(this.TestDirectory(), testName);
        outer.mkdirs();
        return Files.createTempDirectory(outer.toPath(), this.timeStamp(), new FileAttribute[0]).toFile();
    }

    public File makeHarness(Function1<String, String> template, String post, File f) {
        String prefix = (String)ArrayOps$.MODULE$.last$extension(Predef$.MODULE$.refArrayOps(f.toString().split("/")));
        File vf = new File(new StringBuilder(0).append(f.toString()).append(post).toString());
        FileWriter w = new FileWriter(vf);
        w.write(template.apply(prefix));
        w.close();
        return vf;
    }

    public ProcessBuilder firrtlToVerilog(String prefix, File dir) {
        return Process$.MODULE$.apply((Seq<String>)((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"firrtl", "-i", new StringBuilder(4).append(prefix).append(".fir").toString(), "-o", new StringBuilder(2).append(prefix).append(".v").toString(), "-X", "verilog"}))), dir, (scala.collection.immutable.Seq<Tuple2<String, String>>)Nil$.MODULE$);
    }

    public ProcessBuilder verilogToCpp(String dutFile, File dir, scala.collection.immutable.Seq<File> vSources, File cppHarness, boolean suppressVcd, String resourceFileName, scala.collection.immutable.Seq<String> extraCmdLineArgs) {
        String topModule = dutFile;
        File list_file = new File(dir, resourceFileName);
        scala.collection.immutable.Seq blackBoxVerilogList = list_file.exists() ? (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"-f", list_file.getAbsolutePath()})) : (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty();
        Set blackBoxHelperFiles = list_file.exists() ? FileUtils$.MODULE$.getLines(list_file).toSet() : Predef$.MODULE$.Set().empty();
        scala.collection.immutable.Seq vSourcesFiltered = (scala.collection.immutable.Seq)vSources.filterNot((Function1<File, Object> & Serializable)f -> BoxesRunTime.boxToBoolean(blackBoxHelperFiles.contains(f.getCanonicalPath())));
        scala.collection.immutable.Seq command = (scala.collection.immutable.Seq)((IterableOps)((IterableOps)((IterableOps)((IterableOps)((IterableOps)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"verilator", "--cc", new StringBuilder(3).append(dir.getAbsolutePath()).append("/").append(dutFile).append(".v").toString()})).$plus$plus(extraCmdLineArgs)).$plus$plus(blackBoxVerilogList)).$plus$plus((IterableOnce)vSourcesFiltered.flatMap((Function1<File, scala.collection.immutable.Seq> & Serializable)file -> (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"-v", file.getCanonicalPath()}))))).$plus$plus(package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"--assert", "-Wno-fatal", "-Wno-WIDTH", "-Wno-STMTDLY"})))).$plus$plus(suppressVcd ? package$.MODULE$.Seq().empty() : package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"--trace"})))).$plus$plus(package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"-O1", "--top-module", topModule, new StringBuilder(18).append("+define+TOP_TYPE=V").append(dutFile).toString(), new StringBuilder(27).append("+define+PRINTF_COND=!").append(topModule).append(".reset").toString(), new StringBuilder(25).append("+define+STOP_COND=!").append(topModule).append(".reset").toString(), "-CFLAGS", new StringBuilder(77).append("-Wno-undefined-bool-conversion -O1 -DTOP_TYPE=V").append(dutFile).append(" -DVL_USER_FINISH -include V").append(dutFile).append(".h").toString(), "-Mdir", dir.getAbsolutePath(), "--exe", cppHarness.getAbsolutePath()})));
        this.logger().info((Function0<String> & Serializable)() -> String.valueOf(command.mkString(" ")));
        return scala.sys.process.package$.MODULE$.stringSeqToProcess(command);
    }

    public boolean verilogToCpp$default$5() {
        return false;
    }

    public String verilogToCpp$default$6() {
        return BlackBoxSourceHelper$.MODULE$.defaultFileListName();
    }

    public scala.collection.immutable.Seq<String> verilogToCpp$default$7() {
        return (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty();
    }

    public ProcessBuilder cppToExe(String prefix, File dir) {
        return scala.sys.process.package$.MODULE$.stringSeqToProcess((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"make", "-C", dir.toString(), "-j", "-f", new StringBuilder(4).append("V").append(prefix).append(".mk").toString(), new StringBuilder(1).append("V").append(prefix).toString()})));
    }

    public boolean executeExpectingFailure(String prefix, File dir, String assertionMsg) {
        BooleanRef triggered = BooleanRef.create(false);
        String string = assertionMsg;
        String string2 = "";
        boolean assertionMessageSupplied = string == null ? string2 != null : !string.equals(string2);
        int e = Process$.MODULE$.apply(new StringBuilder(3).append("./V").append(prefix).toString(), dir, (scala.collection.immutable.Seq<Tuple2<String, String>>)Nil$.MODULE$).$bang(ProcessLogger$.MODULE$.apply((Function1<String, BoxedUnit>)(Function1<String, Object> & Serializable)line -> {
            BackendCompilationUtilities$.$anonfun$executeExpectingFailure$1(triggered, assertionMessageSupplied, assertionMsg, line);
            return BoxedUnit.UNIT;
        }, (Function1<String, BoxedUnit>)(Function1<String, Object> & Serializable)x$4 -> {
            BackendCompilationUtilities$.$anonfun$executeExpectingFailure$3(x$4);
            return BoxedUnit.UNIT;
        }));
        return triggered.elem || e != 0 && (e != 134 || !assertionMessageSupplied);
    }

    public String executeExpectingFailure$default$3() {
        return "";
    }

    public boolean executeExpectingSuccess(String prefix, File dir) {
        return !this.executeExpectingFailure(prefix, dir, this.executeExpectingFailure$default$3());
    }

    public boolean yosysExpectSuccess(String customTop, String referenceTop, File testDir, int timesteps) {
        return !this.yosysExpectFailure(customTop, referenceTop, testDir, timesteps);
    }

    public int yosysExpectSuccess$default$4() {
        return 1;
    }

    public boolean yosysExpectFailure(String customTop, String referenceTop, File testDir, int timesteps) {
        String scriptFileName = new StringBuilder(13).append(testDir.getAbsolutePath()).append("/yosys_script").toString();
        PrintWriter yosysScriptWriter = new PrintWriter(scriptFileName);
        yosysScriptWriter.write(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(846).append("read_verilog ").append(testDir.getAbsolutePath()).append("/").append(customTop).append(".v\n                               |prep -flatten -top ").append(customTop).append("; proc; opt; memory\n                               |design -stash custom\n                               |read_verilog ").append(testDir.getAbsolutePath()).append("/").append(referenceTop).append(".v\n                               |prep -flatten -top ").append(referenceTop).append("; proc; opt; memory\n                               |design -stash reference\n                               |design -copy-from custom -as custom ").append(customTop).append("\n                               |design -copy-from reference -as reference ").append(referenceTop).append("\n                               |equiv_make custom reference equiv\n                               |hierarchy -top equiv\n                               |prep -flatten -top equiv\n                               |clean -purge\n                               |equiv_simple -seq ").append(timesteps).append("\n                               |equiv_induct -seq ").append(timesteps).append("\n                               |equiv_status -assert\n         ").toString())));
        yosysScriptWriter.close();
        String resultFileName = new StringBuilder(14).append(testDir.getAbsolutePath()).append("/yosys_results").toString();
        ProcessBuilder command = scala.sys.process.package$.MODULE$.stringToProcess(new StringBuilder(9).append("yosys -s ").append(scriptFileName).toString()).$hash$greater(new File(resultFileName));
        return command.$bang() != 0;
    }

    public int yosysExpectFailure$default$4() {
        return 1;
    }

    public static final /* synthetic */ void $anonfun$loggingProcessLogger$1(String x$1) {
        MODULE$.logger().info((Function0<String> & Serializable)() -> x$1);
    }

    public static final /* synthetic */ void $anonfun$loggingProcessLogger$3(String x$2) {
        MODULE$.logger().warn((Function0<String> & Serializable)() -> x$2);
    }

    public static final /* synthetic */ void $anonfun$executeExpectingFailure$1(BooleanRef triggered$1, boolean assertionMessageSupplied$1, String assertionMsg$1, String line) {
        triggered$1.elem = triggered$1.elem || assertionMessageSupplied$1 && line.contains(assertionMsg$1);
        MODULE$.logger().info((Function0<String> & Serializable)() -> line);
    }

    public static final /* synthetic */ void $anonfun$executeExpectingFailure$3(String x$4) {
        MODULE$.logger().warn((Function0<String> & Serializable)() -> x$4);
    }

    private BackendCompilationUtilities$() {
    }
}

