/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.trans.UncheckedXPathException;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.SingletonIterator;
import net.sf.saxon.value.Closure;

public class SingletonClosure
extends Closure
implements Sequence {
    private boolean built = false;
    private Item value = null;

    public SingletonClosure(Expression exp, XPathContext context) throws XPathException {
        this.expression = exp;
        this.savedXPathContext = context.newContext();
        this.saveContext(exp, context);
    }

    @Override
    public SequenceIterator iterate() {
        try {
            return SingletonIterator.makeIterator(this.asItem());
        }
        catch (XPathException e) {
            throw new UncheckedXPathException(e);
        }
    }

    public Item asItem() throws XPathException {
        if (!this.built) {
            this.value = this.expression.evaluateItem(this.savedXPathContext);
            this.built = true;
            this.savedXPathContext = null;
        }
        return this.value;
    }

    public Item itemAt(int n) throws XPathException {
        if (n != 0) {
            return null;
        }
        return this.asItem();
    }

    public int getLength() throws XPathException {
        return this.asItem() == null ? 0 : 1;
    }

    @Override
    public GroundedValue materialize() {
        try {
            return SequenceTool.itemOrEmpty(this.asItem());
        }
        catch (XPathException e) {
            throw new UncheckedXPathException(e);
        }
    }

    @Override
    public SingletonClosure makeRepeatable() {
        return this;
    }
}

