/*=========================================================================
*
*  Copyright NumFOCUS
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/
#ifndef sitkUnsharpMaskImageFilter_h
#define sitkUnsharpMaskImageFilter_h

/*
 * WARNING: DO NOT EDIT THIS FILE!
 * THIS FILE IS AUTOMATICALLY GENERATED BY THE SIMPLEITK BUILD PROCESS.
 * Please look at sitkImageFilterTemplate.h.in to make changes.
 */

#include <memory>

#include "sitkBasicFilters.h"
#include "sitkImageFilter.h"

namespace itk::simple {

    /**\class UnsharpMaskImageFilter
\brief Edge enhancement filter.

This filter subtracts a smoothed version of the image from the image to achieve the edge enhancing effect. https://en.wikipedia.org/w/index.php?title=Unsharp_masking&oldid=750486803#Photographic_unsharp_masking 

It has configurable amount, radius (sigma) and threshold, and whether to clamp the resulting values to the range of output type.

Formula: sharpened=original+[itk::Math::abs (original-blurred)-threshold]*amount

If clamping is turned off (it is on by default), casting to output pixel format is done using C++ defaults, meaning that values are not clamped but rather wrap around e.g. 260 -> 4 (unsigned char).

\see ImageToImageFilter 


\see SmoothingRecursiveGaussianImageFilter 


\see RescaleIntensityImageFilter
\sa itk::simple::UnsharpMask for the procedural interface
\sa itk::UnsharpMaskImageFilter for the Doxygen on the original ITK class.
     */
    class SITKBasicFilters_EXPORT UnsharpMaskImageFilter : public ImageFilter {
    public:
      using Self = UnsharpMaskImageFilter;

      /** Destructor */
      virtual ~UnsharpMaskImageFilter();

      /** Default Constructor that takes no arguments and initializes
       * default parameters */
      UnsharpMaskImageFilter();

      /** Define the pixels types supported by this filter */
      using PixelIDTypeList = RealPixelIDTypeList;
      /** Custom public declarations */
      SITK_RETURN_SELF_TYPE_HEADER SetSigmas(double s) { this->m_Sigmas = std::vector<double>(3, s ); return *this; }

\

      /**
       * Set/Get Sigma values measured in the units of image spacing. Default: 1.0.
       */
      SITK_RETURN_SELF_TYPE_HEADER SetSigmas ( std::vector<double> Sigmas ) { this->m_Sigmas = std::move(Sigmas); return *this; }

      /**
       * Set/Get Sigma values measured in the units of image spacing. Default: 1.0.
       */
      std::vector<double> GetSigmas() const { return this->m_Sigmas; }\

      /**
       * Set/Get amount of enhancement. Usual range: 0.1 to 2.0. Default: 0.5.
       */
      SITK_RETURN_SELF_TYPE_HEADER SetAmount ( double Amount ) { this->m_Amount = Amount; return *this; }

      /**
       * Set/Get amount of enhancement. Usual range: 0.1 to 2.0. Default: 0.5.
       */
      double GetAmount() const { return this->m_Amount; }\

      /**
       * Set/Get threshold for enhancement. Default: 0.
       */
      SITK_RETURN_SELF_TYPE_HEADER SetThreshold ( double Threshold ) { this->m_Threshold = Threshold; return *this; }

      /**
       * Set/Get threshold for enhancement. Default: 0.
       */
      double GetThreshold() const { return this->m_Threshold; }\

      /**
       * Set/Get whether to clamp values to supported range of output type. Default: On.
       */
      SITK_RETURN_SELF_TYPE_HEADER SetClamp ( bool Clamp ) { this->m_Clamp = Clamp; return *this; }

      /** Set the value of Clamp to true or false respectfully. */
      SITK_RETURN_SELF_TYPE_HEADER ClampOn() { return this->SetClamp(true); }
      SITK_RETURN_SELF_TYPE_HEADER ClampOff() { return this->SetClamp(false); }

      /**
       * Set/Get whether to clamp values to supported range of output type. Default: On.
       */
      bool GetClamp() const { return this->m_Clamp; }

      /** Name of this class */
      std::string GetName() const { return std::string ("UnsharpMaskImageFilter"); }

      /** Print ourselves out */
      std::string ToString() const;


      /** Execute the filter on the input image */

      Image Execute ( const Image& image1 );

    private:

      /** Setup for member function dispatching */

      using MemberFunctionType = Image (Self::*)( const Image& image1 );
      template <class TImageType> Image ExecuteInternal ( const Image& image1 );


      friend struct detail::MemberFunctionAddressor<MemberFunctionType>;

      std::unique_ptr<detail::MemberFunctionFactory<MemberFunctionType> > m_MemberFactory;


      std::vector<double>  m_Sigmas{std::vector<double>(3, 1.0)};

      double  m_Amount{0.5};

      double  m_Threshold{0.0};

      bool  m_Clamp{true};


    };

    /**\
     * \brief Edge enhancement filter.
     *
     * This function directly calls the execute method of UnsharpMaskImageFilter
     * in order to support a procedural API
     *
     * \sa itk::simple::UnsharpMaskImageFilter for the object oriented interface
     * @{
     */

     SITKBasicFilters_EXPORT Image UnsharpMask ( const Image& image1, std::vector<double> sigmas = std::vector<double>(3, 1.0), double amount = 0.5, double threshold = 0.0, bool clamp = true );

     /** @} */
}
#endif
