/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.ontology.imports;

import java.awt.Component;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;
import org.protege.editor.core.ui.list.MList;
import org.protege.editor.core.ui.list.MListSectionHeader;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.ui.ontology.imports.AddImportsStrategy;
import org.protege.editor.owl.ui.ontology.imports.OntologyImportItem;
import org.protege.editor.owl.ui.ontology.imports.OntologyImportsItemRenderer;
import org.protege.editor.owl.ui.ontology.imports.wizard.OntologyImportWizard;
import org.semanticweb.owlapi.model.AddImport;
import org.semanticweb.owlapi.model.OWLImportsDeclaration;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyChangeListener;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.model.RemoveImport;
import org.semanticweb.owlapi.model.UnknownOWLOntologyException;

public class OntologyImportsList
extends MList {
    private final OWLEditorKit editorKit;
    private OWLOntology ont;
    private final MListSectionHeader directImportsHeader;
    private final MListSectionHeader indirectImportsHeader;
    private OWLOntologyChangeListener ontChangeListener = this::handleOntologyChanges;

    public OntologyImportsList(OWLEditorKit editorKit) {
        this.editorKit = editorKit;
        this.setFixedCellHeight(-1);
        this.setCellRenderer(new OntologyImportsItemRenderer(editorKit));
        this.directImportsHeader = new MListSectionHeader(){

            public String getName() {
                return "Direct Imports";
            }

            public boolean canAdd() {
                return true;
            }
        };
        this.indirectImportsHeader = new MListSectionHeader(){

            public String getName() {
                return "Indirect Imports";
            }

            public boolean canAdd() {
                return false;
            }
        };
        editorKit.getOWLModelManager().addOntologyChangeListener(this.ontChangeListener);
    }

    protected void handleAdd() {
        OntologyImportWizard wizard = new OntologyImportWizard((Frame)SwingUtilities.getAncestorOfClass(Frame.class, (Component)((Object)this.editorKit.getWorkspace())), this.editorKit);
        int ret = wizard.showModalDialog();
        if (ret == 0) {
            AddImportsStrategy strategy = new AddImportsStrategy(this.editorKit, this.ont, wizard.getImports());
            strategy.addImports();
        }
    }

    public void setOntology(OWLOntology ont) {
        this.ont = ont;
        ArrayList<Object> data = new ArrayList<Object>();
        data.add(this.directImportsHeader);
        for (OWLImportsDeclaration decl : ont.getImportsDeclarations()) {
            data.add(new OntologyImportItem(ont, decl, this.editorKit));
        }
        data.add(this.indirectImportsHeader);
        try {
            for (OWLOntology ontRef : this.editorKit.getOWLModelManager().getOWLOntologyManager().getImportsClosure(ont)) {
                if (ontRef.equals((Object)ont)) continue;
                for (OWLImportsDeclaration dec : ontRef.getImportsDeclarations()) {
                    if (data.contains(dec)) continue;
                    data.add(new OntologyImportItem(ontRef, dec, this.editorKit));
                }
            }
        }
        catch (UnknownOWLOntologyException e) {
            throw new OWLRuntimeException((Throwable)e);
        }
        this.setListData(data.toArray());
    }

    private void handleOntologyChanges(List<? extends OWLOntologyChange> changes) {
        for (OWLOntologyChange oWLOntologyChange : changes) {
            if (!(oWLOntologyChange instanceof AddImport) && !(oWLOntologyChange instanceof RemoveImport) || !oWLOntologyChange.getOntology().equals((Object)this.ont)) continue;
            this.refresh();
            return;
        }
    }

    private void refresh() {
        this.setOntology(this.ont);
    }

    public void dispose() {
        this.editorKit.getOWLModelManager().removeOntologyChangeListener(this.ontChangeListener);
    }

    public boolean getScrollableTracksViewportWidth() {
        return true;
    }
}

