/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo;

import java.io.Serializable;
import java.util.Comparator;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Feature
implements Serializable,
Cloneable,
Comparable<Feature> {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(Feature.class.getName());
    protected final String name;
    protected final double value;

    public Feature(String name, double value) {
        this.name = name;
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public double getValue() {
        return this.value;
    }

    public String toString() {
        return String.format("(%s, %f)", this.name, this.value);
    }

    public String toHTML() {
        String cleanName = this.getName().replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;");
        return String.format("<td style=\"text-align:left\">%s</td>", cleanName);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Feature feature = (Feature)o;
        if (Double.compare(feature.value, this.value) != 0) {
            return false;
        }
        return this.name != null ? this.name.equals(feature.name) : feature.name == null;
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        long temp = Double.doubleToLongBits(this.value);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public Feature clone() {
        try {
            return (Feature)super.clone();
        }
        catch (CloneNotSupportedException e) {
            logger.log(Level.SEVERE, "Clone failed, returning copy");
            return new Feature(this.name, this.value);
        }
    }

    public static Comparator<Feature> featureNameComparator() {
        return Comparator.comparing(a -> a.name);
    }

    @Override
    public int compareTo(Feature o) {
        return this.name.compareTo(o.name);
    }
}

