/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.modality.cv.transform;

import ai.djl.modality.cv.util.NDImageUtils;
import ai.djl.ndarray.NDArray;
import ai.djl.ndarray.types.Shape;
import ai.djl.translate.Transform;

public class CenterFit
implements Transform {
    private int width;
    private int height;

    public CenterFit(int width, int height) {
        this.width = width;
        this.height = height;
    }

    @Override
    public NDArray transform(NDArray array) {
        Shape shape = array.getShape();
        int w = (int)shape.get(1);
        int h = (int)shape.get(0);
        if (w > this.width || h > this.height) {
            array = NDImageUtils.centerCrop(array, Math.min(w, this.width), Math.min(h, this.height));
        }
        int padW = this.width - w;
        int padH = this.height - h;
        if (padW > 0 || padH > 0) {
            padW = Math.max(0, padW);
            padH = Math.max(0, padH);
            int padW1 = padW / 2;
            int padH1 = padH / 2;
            Shape padding = new Shape(0L, 0L, padW1, padW - padW1, padH1, padH - padH1);
            array = array.pad(padding, 0.0);
        }
        return array;
    }
}

