/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.data.text.impl;

import com.oracle.labs.mlrg.olcut.config.Config;
import com.oracle.labs.mlrg.olcut.config.Configurable;
import com.oracle.labs.mlrg.olcut.provenance.ConfiguredObjectProvenance;
import com.oracle.labs.mlrg.olcut.provenance.impl.ConfiguredObjectProvenanceImpl;
import java.util.List;
import org.tribuo.Example;
import org.tribuo.Feature;
import org.tribuo.Output;
import org.tribuo.data.text.TextFeatureExtractor;
import org.tribuo.data.text.TextPipeline;
import org.tribuo.impl.ArrayExample;

public class TextFeatureExtractorImpl<T extends Output<T>>
implements TextFeatureExtractor<T> {
    @Config(mandatory=true, description="The text processing pipeline.")
    private TextPipeline pipeline;

    private TextFeatureExtractorImpl() {
    }

    public TextFeatureExtractorImpl(TextPipeline pipeline) {
        this.pipeline = pipeline;
    }

    public String toString() {
        return "TextFeatureExtractorImpl(pipeline=" + this.pipeline.toString() + ")";
    }

    @Override
    public Example<T> extract(T label, String data) {
        ArrayExample example = new ArrayExample(label);
        List<Feature> features = this.pipeline.process("", data);
        example.addAll(features);
        return example;
    }

    public ConfiguredObjectProvenance getProvenance() {
        return new ConfiguredObjectProvenanceImpl((Configurable)this, "TextFeatureExtractor");
    }
}

