/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.alerting.modelv2;

import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.alerting.core.util.XContentExtensionsKt;
import org.opensearch.alerting.modelv2.MonitorV2;
import org.opensearch.alerting.modelv2.PPLSQLTrigger;
import org.opensearch.commons.alerting.model.CronSchedule;
import org.opensearch.commons.alerting.model.Schedule;
import org.opensearch.commons.alerting.util.AlertingException;
import org.opensearch.commons.alerting.util.IndexUtilsKt;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u001f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u001a\b\u0086\b\u0018\u0000 d2\u00020\u0001:\u0002cdB\u0097\u0001\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\f\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\b\u0010\u000f\u001a\u0004\u0018\u00010\u000e\u0012\b\u0010\u0010\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012\u0012\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014\u0012\b\b\u0002\u0010\u0016\u001a\u00020\u0017\u0012\b\b\u0002\u0010\u0018\u001a\u00020\u0019\u0012\u0006\u0010\u001a\u001a\u00020\u0003\u00a2\u0006\u0004\b\u001b\u0010\u001cB\u0011\b\u0016\u0012\u0006\u0010\u001d\u001a\u00020\u001e\u00a2\u0006\u0004\b\u001b\u0010\u001fJ\u0018\u0010<\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0018\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020>2\u0006\u0010@\u001a\u00020AH\u0016J\u0018\u0010B\u001a\u00020>2\u0006\u0010?\u001a\u00020>2\u0006\u0010@\u001a\u00020AH\u0016J \u0010C\u001a\u00020>2\u0006\u0010?\u001a\u00020>2\u0006\u0010@\u001a\u00020A2\u0006\u0010D\u001a\u00020\bH\u0002J\u0010\u0010E\u001a\u00020F2\u0006\u0010G\u001a\u00020HH\u0016J\u0016\u0010I\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010K0JH\u0016Jw\u0010L\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00032\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u000b\u001a\u0004\u0018\u00010\u00052\b\u0010\f\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u0010MJ\t\u0010N\u001a\u00020\u0003H\u00c6\u0003J\t\u0010O\u001a\u00020\u0005H\u00c6\u0003J\t\u0010P\u001a\u00020\u0003H\u00c6\u0003J\t\u0010Q\u001a\u00020\bH\u00c6\u0003J\t\u0010R\u001a\u00020\nH\u00c6\u0003J\u0010\u0010S\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003\u00a2\u0006\u0002\u0010*J\u000b\u0010T\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010U\u001a\u00020\u000eH\u00c6\u0003J\u000b\u0010V\u001a\u0004\u0018\u00010\u000eH\u00c6\u0003J\u000b\u0010W\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010X\u001a\u0004\u0018\u00010\u0012H\u00c6\u0003J\u000f\u0010Y\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u00c6\u0003J\t\u0010Z\u001a\u00020\u0017H\u00c6\u0003J\t\u0010[\u001a\u00020\u0019H\u00c6\u0003J\t\u0010\\\u001a\u00020\u0003H\u00c6\u0003J\u00b4\u0001\u0010]\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\r\u001a\u00020\u000e2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u000e\b\u0002\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\b\b\u0002\u0010\u0016\u001a\u00020\u00172\b\b\u0002\u0010\u0018\u001a\u00020\u00192\b\b\u0002\u0010\u001a\u001a\u00020\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010^J\u0013\u0010_\u001a\u00020\b2\b\u0010`\u001a\u0004\u0018\u00010KH\u00d6\u0003J\t\u0010a\u001a\u00020\u0017H\u00d6\u0001J\t\u0010b\u001a\u00020\u0003H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0014\u0010\u0006\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010!R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u0018\u0010\u000b\u001a\u0004\u0018\u00010\u0005X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010+\u001a\u0004\b)\u0010*R\u0016\u0010\f\u001a\u0004\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010!R\u0014\u0010\r\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.R\u0016\u0010\u000f\u001a\u0004\u0018\u00010\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u0010.R\u0016\u0010\u0010\u001a\u0004\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u0010!R\u0016\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u00102R\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u00104R\u0014\u0010\u0016\u001a\u00020\u0017X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u00106R\u0011\u0010\u0018\u001a\u00020\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b7\u00108R\u0011\u0010\u001a\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b9\u0010!R\u0014\u0010:\u001a\u00020\u0003X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b;\u0010!\u00a8\u0006e"}, d2={"Lorg/opensearch/alerting/modelv2/PPLSQLMonitor;", "Lorg/opensearch/alerting/modelv2/MonitorV2;", "id", "", "version", "", "name", "enabled", "", "schedule", "Lorg/opensearch/commons/alerting/model/Schedule;", "lookBackWindow", "timestampField", "lastUpdateTime", "Ljava/time/Instant;", "enabledTime", "description", "user", "Lorg/opensearch/commons/authuser/User;", "triggers", "", "Lorg/opensearch/alerting/modelv2/PPLSQLTrigger;", "schemaVersion", "", "queryLanguage", "Lorg/opensearch/alerting/modelv2/PPLSQLMonitor$QueryLanguage;", "query", "<init>", "(Ljava/lang/String;JLjava/lang/String;ZLorg/opensearch/commons/alerting/model/Schedule;Ljava/lang/Long;Ljava/lang/String;Ljava/time/Instant;Ljava/time/Instant;Ljava/lang/String;Lorg/opensearch/commons/authuser/User;Ljava/util/List;ILorg/opensearch/alerting/modelv2/PPLSQLMonitor$QueryLanguage;Ljava/lang/String;)V", "sin", "Lorg/opensearch/core/common/io/stream/StreamInput;", "(Lorg/opensearch/core/common/io/stream/StreamInput;)V", "getId", "()Ljava/lang/String;", "getVersion", "()J", "getName", "getEnabled", "()Z", "getSchedule", "()Lorg/opensearch/commons/alerting/model/Schedule;", "getLookBackWindow", "()Ljava/lang/Long;", "Ljava/lang/Long;", "getTimestampField", "getLastUpdateTime", "()Ljava/time/Instant;", "getEnabledTime", "getDescription", "getUser", "()Lorg/opensearch/commons/authuser/User;", "getTriggers", "()Ljava/util/List;", "getSchemaVersion", "()I", "getQueryLanguage", "()Lorg/opensearch/alerting/modelv2/PPLSQLMonitor$QueryLanguage;", "getQuery", "type", "getType", "fromDocument", "toXContentWithUser", "Lorg/opensearch/core/xcontent/XContentBuilder;", "builder", "params", "Lorg/opensearch/core/xcontent/ToXContent$Params;", "toXContent", "createXContentBuilder", "withUser", "writeTo", "", "out", "Lorg/opensearch/core/common/io/stream/StreamOutput;", "asTemplateArg", "", "", "makeCopy", "(Ljava/lang/String;JLjava/lang/String;ZLorg/opensearch/commons/alerting/model/Schedule;Ljava/time/Instant;Ljava/time/Instant;Ljava/lang/String;Lorg/opensearch/commons/authuser/User;ILjava/lang/Long;Ljava/lang/String;)Lorg/opensearch/alerting/modelv2/PPLSQLMonitor;", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "component10", "component11", "component12", "component13", "component14", "component15", "copy", "(Ljava/lang/String;JLjava/lang/String;ZLorg/opensearch/commons/alerting/model/Schedule;Ljava/lang/Long;Ljava/lang/String;Ljava/time/Instant;Ljava/time/Instant;Ljava/lang/String;Lorg/opensearch/commons/authuser/User;Ljava/util/List;ILorg/opensearch/alerting/modelv2/PPLSQLMonitor$QueryLanguage;Ljava/lang/String;)Lorg/opensearch/alerting/modelv2/PPLSQLMonitor;", "equals", "other", "hashCode", "toString", "QueryLanguage", "Companion", "opensearch-alerting"})
@SourceDebugExtension(value={"SMAP\nPPLSQLMonitor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PPLSQLMonitor.kt\norg/opensearch/alerting/modelv2/PPLSQLMonitor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,411:1\n1#2:412\n1869#3,2:413\n1869#3,2:419\n37#4:415\n36#4,3:416\n*S KotlinDebug\n*F\n+ 1 PPLSQLMonitor.kt\norg/opensearch/alerting/modelv2/PPLSQLMonitor\n*L\n116#1:413,2\n225#1:419,2\n180#1:415\n180#1:416,3\n*E\n"})
public final class PPLSQLMonitor
implements MonitorV2 {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String id;
    private final long version;
    @NotNull
    private final String name;
    private final boolean enabled;
    @NotNull
    private final Schedule schedule;
    @Nullable
    private final Long lookBackWindow;
    @Nullable
    private final String timestampField;
    @NotNull
    private final Instant lastUpdateTime;
    @Nullable
    private final Instant enabledTime;
    @Nullable
    private final String description;
    @Nullable
    private final User user;
    @NotNull
    private final List<PPLSQLTrigger> triggers;
    private final int schemaVersion;
    @NotNull
    private final QueryLanguage queryLanguage;
    @NotNull
    private final String query;
    @NotNull
    private final String type;
    @NotNull
    public static final String PPL_SQL_MONITOR_TYPE = "ppl_monitor";
    @NotNull
    public static final String PPL_QUERY_LANGUAGE = "ppl";
    @NotNull
    public static final String SQL_QUERY_LANGUAGE = "sql";
    @NotNull
    public static final String QUERY_LANGUAGE_FIELD = "query_language";
    @NotNull
    public static final String QUERY_FIELD = "query";

    public PPLSQLMonitor(@NotNull String id, long version, @NotNull String name, boolean enabled, @NotNull Schedule schedule, @Nullable Long lookBackWindow, @Nullable String timestampField, @NotNull Instant lastUpdateTime, @Nullable Instant enabledTime, @Nullable String description, @Nullable User user, @NotNull List<PPLSQLTrigger> triggers, int schemaVersion, @NotNull QueryLanguage queryLanguage, @NotNull String query) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)schedule, (String)"schedule");
        Intrinsics.checkNotNullParameter((Object)lastUpdateTime, (String)"lastUpdateTime");
        Intrinsics.checkNotNullParameter(triggers, (String)"triggers");
        Intrinsics.checkNotNullParameter((Object)((Object)queryLanguage), (String)"queryLanguage");
        Intrinsics.checkNotNullParameter((Object)query, (String)QUERY_FIELD);
        this.id = id;
        this.version = version;
        this.name = name;
        this.enabled = enabled;
        this.schedule = schedule;
        this.lookBackWindow = lookBackWindow;
        this.timestampField = timestampField;
        this.lastUpdateTime = lastUpdateTime;
        this.enabledTime = enabledTime;
        this.description = description;
        this.user = user;
        this.triggers = triggers;
        this.schemaVersion = schemaVersion;
        this.queryLanguage = queryLanguage;
        this.query = query;
        this.type = "monitor_v2";
        if (this.queryLanguage == QueryLanguage.SQL) {
            throw new IllegalArgumentException("SQL queries are not supported. Please use a PPL query.");
        }
        if (!(this.getName().length() <= 30)) {
            boolean $i$a$-require-PPLSQLMonitor$22 = false;
            String $i$a$-require-PPLSQLMonitor$22 = "Monitor name too long, length must be less than 30.";
            throw new IllegalArgumentException($i$a$-require-PPLSQLMonitor$22.toString());
        }
        if (this.getLookBackWindow() != null) {
            v0 = this.getTimestampField();
            if (v0 == null) {
                boolean $i$a$-requireNotNull-PPLSQLMonitor$32 = false;
                String $i$a$-requireNotNull-PPLSQLMonitor$32 = "If look back window is specified, timestamp field must not be null.";
                throw new IllegalArgumentException($i$a$-requireNotNull-PPLSQLMonitor$32.toString());
            }
        } else {
            if (!(this.getTimestampField() == null)) {
                boolean $i$a$-require-PPLSQLMonitor$62 = false;
                String $i$a$-require-PPLSQLMonitor$62 = "If look back window is not specified, timestamp field must not be specified.";
                throw new IllegalArgumentException($i$a$-require-PPLSQLMonitor$62.toString());
            }
            v0 = Unit.INSTANCE;
        }
        if (!(!((Collection)this.getTriggers()).isEmpty())) {
            boolean $i$a$-require-PPLSQLMonitor$72 = false;
            String $i$a$-require-PPLSQLMonitor$72 = "Monitor must include at least 1 trigger.";
            throw new IllegalArgumentException($i$a$-require-PPLSQLMonitor$72.toString());
        }
        if (!(this.getTriggers().size() <= 10)) {
            boolean $i$a$-require-PPLSQLMonitor$82 = false;
            String $i$a$-require-PPLSQLMonitor$82 = "Monitors can only have 10 triggers.";
            throw new IllegalArgumentException($i$a$-require-PPLSQLMonitor$82.toString());
        }
        Long l = this.getLookBackWindow();
        if (l != null) {
            long it = ((Number)l).longValue();
            boolean bl = false;
            if (!(this.getLookBackWindow() >= 1L)) {
                boolean $i$a$-require-PPLSQLMonitor$6$22 = false;
                String $i$a$-require-PPLSQLMonitor$6$22 = "Monitors look back windows must be at least 1 minute.";
                throw new IllegalArgumentException($i$a$-require-PPLSQLMonitor$6$22.toString());
            }
        }
        String string = this.getDescription();
        if (string != null) {
            String it = string;
            boolean bl = false;
            if (!(this.getDescription().length() <= 2000)) {
                boolean $i$a$-require-PPLSQLMonitor$7$22 = false;
                String $i$a$-require-PPLSQLMonitor$7$22 = "Description must be under 2000 characters.";
                throw new IllegalArgumentException($i$a$-require-PPLSQLMonitor$7$22.toString());
            }
        }
        Set triggerIds = new LinkedHashSet();
        Iterable $this$forEach$iv = this.getTriggers();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PPLSQLTrigger trigger = (PPLSQLTrigger)element$iv;
            boolean bl = false;
            if (triggerIds.add(trigger.getId())) continue;
            boolean bl2 = false;
            String string2 = "Duplicate trigger id: " + trigger.getId() + ". Trigger ids must be unique.";
            throw new IllegalArgumentException(string2.toString());
        }
        if (this.getEnabled()) {
            v3 = this.getEnabledTime();
            if (v3 == null) {
                String string3 = "Required value was null.";
                throw new IllegalArgumentException(string3.toString());
            }
        } else {
            if (!(this.getEnabledTime() == null)) {
                String string4 = "Failed requirement.";
                throw new IllegalArgumentException(string4.toString());
            }
            v3 = Unit.INSTANCE;
        }
    }

    public /* synthetic */ PPLSQLMonitor(String string, long l, String string2, boolean bl, Schedule schedule, Long l2, String string3, Instant instant, Instant instant2, String string4, User user, List list, int n, QueryLanguage queryLanguage, String string5, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            string = "";
        }
        if ((n2 & 2) != 0) {
            l = 1L;
        }
        if ((n2 & 0x1000) != 0) {
            n = 0;
        }
        if ((n2 & 0x2000) != 0) {
            queryLanguage = QueryLanguage.PPL;
        }
        this(string, l, string2, bl, schedule, l2, string3, instant, instant2, string4, user, list, n, queryLanguage, string5);
    }

    @Override
    @NotNull
    public String getId() {
        return this.id;
    }

    @Override
    public long getVersion() {
        return this.version;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    public boolean getEnabled() {
        return this.enabled;
    }

    @Override
    @NotNull
    public Schedule getSchedule() {
        return this.schedule;
    }

    @Override
    @Nullable
    public Long getLookBackWindow() {
        return this.lookBackWindow;
    }

    @Override
    @Nullable
    public String getTimestampField() {
        return this.timestampField;
    }

    @Override
    @NotNull
    public Instant getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    @Override
    @Nullable
    public Instant getEnabledTime() {
        return this.enabledTime;
    }

    @Override
    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Override
    @Nullable
    public User getUser() {
        return this.user;
    }

    @NotNull
    public List<PPLSQLTrigger> getTriggers() {
        return this.triggers;
    }

    @Override
    public int getSchemaVersion() {
        return this.schemaVersion;
    }

    @NotNull
    public final QueryLanguage getQueryLanguage() {
        return this.queryLanguage;
    }

    @NotNull
    public final String getQuery() {
        return this.query;
    }

    @NotNull
    public String getType() {
        return this.type;
    }

    @NotNull
    public PPLSQLMonitor fromDocument(@NotNull String id, long version) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return PPLSQLMonitor.copy$default(this, id, version, null, false, null, null, null, null, null, null, null, null, 0, null, null, 32764, null);
    }

    public PPLSQLMonitor(@NotNull StreamInput sin) throws IOException {
        Intrinsics.checkNotNullParameter((Object)sin, (String)"sin");
        String string = sin.readString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"readString(...)");
        long l = sin.readLong();
        String string2 = sin.readString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"readString(...)");
        boolean bl = sin.readBoolean();
        Schedule schedule = Schedule.Companion.readFrom(sin);
        Long l2 = sin.readOptionalLong();
        String string3 = sin.readOptionalString();
        Instant instant = sin.readInstant();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"readInstant(...)");
        Instant instant2 = sin.readOptionalInstant();
        String string4 = sin.readOptionalString();
        User user = sin.readBoolean() ? new User(sin) : null;
        List list = sin.readList(PPLSQLTrigger.Companion::readFrom);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"readList(...)");
        int n = sin.readInt();
        Enum enum_ = sin.readEnum(QueryLanguage.class);
        Intrinsics.checkNotNullExpressionValue((Object)enum_, (String)"readEnum(...)");
        QueryLanguage queryLanguage = (QueryLanguage)enum_;
        String string5 = sin.readString();
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"readString(...)");
        this(string, l, string2, bl, schedule, l2, string3, instant, instant2, string4, user, list, n, queryLanguage, string5);
    }

    @Override
    @NotNull
    public XContentBuilder toXContentWithUser(@NotNull XContentBuilder builder, @NotNull ToXContent.Params params) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        return this.createXContentBuilder(builder, params, true);
    }

    @NotNull
    public XContentBuilder toXContent(@NotNull XContentBuilder builder, @NotNull ToXContent.Params params) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        return this.createXContentBuilder(builder, params, false);
    }

    private final XContentBuilder createXContentBuilder(XContentBuilder builder, ToXContent.Params params, boolean withUser) {
        builder.startObject();
        if (params.paramAsBoolean("with_type", false)) {
            builder.startObject("monitor_v2");
        }
        builder.startObject(PPL_SQL_MONITOR_TYPE);
        builder.field("name", this.getName());
        builder.field("schedule", (ToXContent)this.getSchedule());
        builder.field("look_back_window_minutes", this.getLookBackWindow());
        builder.field("timestamp_field", this.getTimestampField());
        builder.field("enabled", this.getEnabled());
        XContentExtensionsKt.nonOptionalTimeField((XContentBuilder)builder, (String)"last_update_time", (Instant)this.getLastUpdateTime());
        IndexUtilsKt.optionalTimeField((XContentBuilder)builder, (String)"enabled_time", (Instant)this.getEnabledTime());
        builder.field("description", this.getDescription());
        Collection $this$toTypedArray$iv = this.getTriggers();
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        builder.field("triggers", (Object)thisCollection$iv.toArray(new PPLSQLTrigger[0]));
        builder.field("schema_version", this.getSchemaVersion());
        builder.field(QUERY_LANGUAGE_FIELD, this.queryLanguage.getValue());
        builder.field(QUERY_FIELD, this.query);
        if (withUser) {
            IndexUtilsKt.optionalUserField((XContentBuilder)builder, (String)"user", (User)this.getUser());
        }
        builder.endObject();
        if (params.paramAsBoolean("with_type", false)) {
            builder.endObject();
        }
        builder.endObject();
        return builder;
    }

    public void writeTo(@NotNull StreamOutput out) throws IOException {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        out.writeString(this.getId());
        out.writeLong(this.getVersion());
        out.writeString(this.getName());
        out.writeBoolean(this.getEnabled());
        if (this.getSchedule() instanceof CronSchedule) {
            out.writeEnum((Enum)Schedule.TYPE.CRON);
        } else {
            out.writeEnum((Enum)Schedule.TYPE.INTERVAL);
        }
        this.getSchedule().writeTo(out);
        out.writeOptionalLong(this.getLookBackWindow());
        out.writeOptionalString(this.getTimestampField());
        out.writeInstant(this.getLastUpdateTime());
        out.writeOptionalInstant(this.getEnabledTime());
        out.writeOptionalString(this.getDescription());
        out.writeBoolean(this.getUser() != null);
        User user = this.getUser();
        if (user != null) {
            user.writeTo(out);
        }
        out.writeVInt(this.getTriggers().size());
        Iterable $this$forEach$iv = this.getTriggers();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PPLSQLTrigger it = (PPLSQLTrigger)element$iv;
            boolean bl = false;
            it.writeTo(out);
        }
        out.writeInt(this.getSchemaVersion());
        out.writeEnum((Enum)this.queryLanguage);
        out.writeString(this.query);
    }

    @Override
    @NotNull
    public Map<String, Object> asTemplateArg() {
        Pair[] pairArray = new Pair[9];
        pairArray[0] = TuplesKt.to((Object)"_id", (Object)this.getId());
        pairArray[1] = TuplesKt.to((Object)"_version", (Object)this.getVersion());
        pairArray[2] = TuplesKt.to((Object)"name", (Object)this.getName());
        pairArray[3] = TuplesKt.to((Object)"enabled", (Object)this.getEnabled());
        pairArray[4] = TuplesKt.to((Object)"schedule", (Object)this.getSchedule());
        pairArray[5] = TuplesKt.to((Object)"look_back_window_minutes", (Object)this.getLookBackWindow());
        pairArray[6] = TuplesKt.to((Object)"last_update_time", (Object)this.getLastUpdateTime().toEpochMilli());
        Instant instant = this.getEnabledTime();
        pairArray[7] = TuplesKt.to((Object)"enabled_time", (Object)(instant != null ? Long.valueOf(instant.toEpochMilli()) : null));
        pairArray[8] = TuplesKt.to((Object)QUERY_FIELD, (Object)this.query);
        return MapsKt.mapOf((Pair[])pairArray);
    }

    @Override
    @NotNull
    public PPLSQLMonitor makeCopy(@NotNull String id, long version, @NotNull String name, boolean enabled, @NotNull Schedule schedule, @NotNull Instant lastUpdateTime, @Nullable Instant enabledTime, @Nullable String description, @Nullable User user, int schemaVersion, @Nullable Long lookBackWindow, @Nullable String timestampField) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)schedule, (String)"schedule");
        Intrinsics.checkNotNullParameter((Object)lastUpdateTime, (String)"lastUpdateTime");
        return PPLSQLMonitor.copy$default(this, id, version, name, enabled, schedule, lookBackWindow, timestampField, lastUpdateTime, enabledTime, description, user, null, schemaVersion, null, null, 26624, null);
    }

    @NotNull
    public final String component1() {
        return this.id;
    }

    public final long component2() {
        return this.version;
    }

    @NotNull
    public final String component3() {
        return this.name;
    }

    public final boolean component4() {
        return this.enabled;
    }

    @NotNull
    public final Schedule component5() {
        return this.schedule;
    }

    @Nullable
    public final Long component6() {
        return this.lookBackWindow;
    }

    @Nullable
    public final String component7() {
        return this.timestampField;
    }

    @NotNull
    public final Instant component8() {
        return this.lastUpdateTime;
    }

    @Nullable
    public final Instant component9() {
        return this.enabledTime;
    }

    @Nullable
    public final String component10() {
        return this.description;
    }

    @Nullable
    public final User component11() {
        return this.user;
    }

    @NotNull
    public final List<PPLSQLTrigger> component12() {
        return this.triggers;
    }

    public final int component13() {
        return this.schemaVersion;
    }

    @NotNull
    public final QueryLanguage component14() {
        return this.queryLanguage;
    }

    @NotNull
    public final String component15() {
        return this.query;
    }

    @NotNull
    public final PPLSQLMonitor copy(@NotNull String id, long version, @NotNull String name, boolean enabled, @NotNull Schedule schedule, @Nullable Long lookBackWindow, @Nullable String timestampField, @NotNull Instant lastUpdateTime, @Nullable Instant enabledTime, @Nullable String description, @Nullable User user, @NotNull List<PPLSQLTrigger> triggers, int schemaVersion, @NotNull QueryLanguage queryLanguage, @NotNull String query) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)schedule, (String)"schedule");
        Intrinsics.checkNotNullParameter((Object)lastUpdateTime, (String)"lastUpdateTime");
        Intrinsics.checkNotNullParameter(triggers, (String)"triggers");
        Intrinsics.checkNotNullParameter((Object)((Object)queryLanguage), (String)"queryLanguage");
        Intrinsics.checkNotNullParameter((Object)query, (String)QUERY_FIELD);
        return new PPLSQLMonitor(id, version, name, enabled, schedule, lookBackWindow, timestampField, lastUpdateTime, enabledTime, description, user, triggers, schemaVersion, queryLanguage, query);
    }

    public static /* synthetic */ PPLSQLMonitor copy$default(PPLSQLMonitor pPLSQLMonitor, String string, long l, String string2, boolean bl, Schedule schedule, Long l2, String string3, Instant instant, Instant instant2, String string4, User user, List list, int n, QueryLanguage queryLanguage, String string5, int n2, Object object) {
        if ((n2 & 1) != 0) {
            string = pPLSQLMonitor.id;
        }
        if ((n2 & 2) != 0) {
            l = pPLSQLMonitor.version;
        }
        if ((n2 & 4) != 0) {
            string2 = pPLSQLMonitor.name;
        }
        if ((n2 & 8) != 0) {
            bl = pPLSQLMonitor.enabled;
        }
        if ((n2 & 0x10) != 0) {
            schedule = pPLSQLMonitor.schedule;
        }
        if ((n2 & 0x20) != 0) {
            l2 = pPLSQLMonitor.lookBackWindow;
        }
        if ((n2 & 0x40) != 0) {
            string3 = pPLSQLMonitor.timestampField;
        }
        if ((n2 & 0x80) != 0) {
            instant = pPLSQLMonitor.lastUpdateTime;
        }
        if ((n2 & 0x100) != 0) {
            instant2 = pPLSQLMonitor.enabledTime;
        }
        if ((n2 & 0x200) != 0) {
            string4 = pPLSQLMonitor.description;
        }
        if ((n2 & 0x400) != 0) {
            user = pPLSQLMonitor.user;
        }
        if ((n2 & 0x800) != 0) {
            list = pPLSQLMonitor.triggers;
        }
        if ((n2 & 0x1000) != 0) {
            n = pPLSQLMonitor.schemaVersion;
        }
        if ((n2 & 0x2000) != 0) {
            queryLanguage = pPLSQLMonitor.queryLanguage;
        }
        if ((n2 & 0x4000) != 0) {
            string5 = pPLSQLMonitor.query;
        }
        return pPLSQLMonitor.copy(string, l, string2, bl, schedule, l2, string3, instant, instant2, string4, user, list, n, queryLanguage, string5);
    }

    @NotNull
    public String toString() {
        return "PPLSQLMonitor(id=" + this.id + ", version=" + this.version + ", name=" + this.name + ", enabled=" + this.enabled + ", schedule=" + this.schedule + ", lookBackWindow=" + this.lookBackWindow + ", timestampField=" + this.timestampField + ", lastUpdateTime=" + this.lastUpdateTime + ", enabledTime=" + this.enabledTime + ", description=" + this.description + ", user=" + this.user + ", triggers=" + this.triggers + ", schemaVersion=" + this.schemaVersion + ", queryLanguage=" + this.queryLanguage + ", query=" + this.query + ")";
    }

    public int hashCode() {
        int result = this.id.hashCode();
        result = result * 31 + Long.hashCode(this.version);
        result = result * 31 + this.name.hashCode();
        result = result * 31 + Boolean.hashCode(this.enabled);
        result = result * 31 + this.schedule.hashCode();
        result = result * 31 + (this.lookBackWindow == null ? 0 : ((Object)this.lookBackWindow).hashCode());
        result = result * 31 + (this.timestampField == null ? 0 : this.timestampField.hashCode());
        result = result * 31 + this.lastUpdateTime.hashCode();
        result = result * 31 + (this.enabledTime == null ? 0 : this.enabledTime.hashCode());
        result = result * 31 + (this.description == null ? 0 : this.description.hashCode());
        result = result * 31 + (this.user == null ? 0 : this.user.hashCode());
        result = result * 31 + ((Object)this.triggers).hashCode();
        result = result * 31 + Integer.hashCode(this.schemaVersion);
        result = result * 31 + this.queryLanguage.hashCode();
        result = result * 31 + this.query.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PPLSQLMonitor)) {
            return false;
        }
        PPLSQLMonitor pPLSQLMonitor = (PPLSQLMonitor)other;
        if (!Intrinsics.areEqual((Object)this.id, (Object)pPLSQLMonitor.id)) {
            return false;
        }
        if (this.version != pPLSQLMonitor.version) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.name, (Object)pPLSQLMonitor.name)) {
            return false;
        }
        if (this.enabled != pPLSQLMonitor.enabled) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.schedule, (Object)pPLSQLMonitor.schedule)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.lookBackWindow, (Object)pPLSQLMonitor.lookBackWindow)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.timestampField, (Object)pPLSQLMonitor.timestampField)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.lastUpdateTime, (Object)pPLSQLMonitor.lastUpdateTime)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.enabledTime, (Object)pPLSQLMonitor.enabledTime)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.description, (Object)pPLSQLMonitor.description)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.user, (Object)pPLSQLMonitor.user)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.triggers, pPLSQLMonitor.triggers)) {
            return false;
        }
        if (this.schemaVersion != pPLSQLMonitor.schemaVersion) {
            return false;
        }
        if (this.queryLanguage != pPLSQLMonitor.queryLanguage) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.query, (Object)pPLSQLMonitor.query);
    }

    @NotNull
    public XContentBuilder toXContentWithType(@NotNull XContentBuilder builder) {
        return MonitorV2.super.toXContentWithType(builder);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final PPLSQLMonitor parse(@NotNull XContentParser xcp, @NotNull String id, long version) throws IOException {
        return Companion.parse(xcp, id, version);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final PPLSQLMonitor parse(@NotNull XContentParser xcp, @NotNull String id) throws IOException {
        return Companion.parse(xcp, id);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final PPLSQLMonitor parse(@NotNull XContentParser xcp) throws IOException {
        return Companion.parse(xcp);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u00052\b\b\u0002\u0010\u000f\u001a\u00020\u0010H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/opensearch/alerting/modelv2/PPLSQLMonitor$Companion;", "", "<init>", "()V", "PPL_SQL_MONITOR_TYPE", "", "PPL_QUERY_LANGUAGE", "SQL_QUERY_LANGUAGE", "QUERY_LANGUAGE_FIELD", "QUERY_FIELD", "parse", "Lorg/opensearch/alerting/modelv2/PPLSQLMonitor;", "xcp", "Lorg/opensearch/core/xcontent/XContentParser;", "id", "version", "", "opensearch-alerting"})
    @SourceDebugExtension(value={"SMAP\nPPLSQLMonitor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PPLSQLMonitor.kt\norg/opensearch/alerting/modelv2/PPLSQLMonitor$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,411:1\n1563#2:412\n1634#2,3:413\n1#3:416\n*S KotlinDebug\n*F\n+ 1 PPLSQLMonitor.kt\norg/opensearch/alerting/modelv2/PPLSQLMonitor$Companion\n*L\n363#1:412\n363#1:413,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @JvmOverloads
        @NotNull
        public final PPLSQLMonitor parse(@NotNull XContentParser xcp, @NotNull String id, long version) throws IOException {
            Instant instant;
            Intrinsics.checkNotNullParameter((Object)xcp, (String)"xcp");
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            String name = null;
            boolean enabled = true;
            Schedule schedule = null;
            Long lookBackWindow = null;
            String timestampField = null;
            Instant lastUpdateTime = null;
            Instant enabledTime = null;
            String description = null;
            User user = null;
            List triggers = new ArrayList();
            int schemaVersion = 0;
            QueryLanguage queryLanguage = QueryLanguage.PPL;
            String query = null;
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
            block30: while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
                String fieldName;
                block55: {
                    fieldName = xcp.currentName();
                    xcp.nextToken();
                    String string = fieldName;
                    if (string == null) break block55;
                    int n = -1;
                    switch (string.hashCode()) {
                        case -1219796725: {
                            if (string.equals("enabled_time")) {
                                n = 1;
                            }
                            break;
                        }
                        case -18244536: {
                            if (string.equals("look_back_window_minutes")) {
                                n = 2;
                            }
                            break;
                        }
                        case 107944136: {
                            if (string.equals(PPLSQLMonitor.QUERY_FIELD)) {
                                n = 3;
                            }
                            break;
                        }
                        case -1724546052: {
                            if (string.equals("description")) {
                                n = 4;
                            }
                            break;
                        }
                        case -1145404271: {
                            if (string.equals("timestamp_field")) {
                                n = 5;
                            }
                            break;
                        }
                        case 665062639: {
                            if (string.equals(PPLSQLMonitor.QUERY_LANGUAGE_FIELD)) {
                                n = 6;
                            }
                            break;
                        }
                        case 1503093179: {
                            if (string.equals("triggers")) {
                                n = 7;
                            }
                            break;
                        }
                        case -1609594047: {
                            if (string.equals("enabled")) {
                                n = 8;
                            }
                            break;
                        }
                        case 1684719674: {
                            if (string.equals("schema_version")) {
                                n = 9;
                            }
                            break;
                        }
                        case -697920873: {
                            if (string.equals("schedule")) {
                                n = 10;
                            }
                            break;
                        }
                        case 2020321370: {
                            if (string.equals("last_update_time")) {
                                n = 11;
                            }
                            break;
                        }
                        case 3373707: {
                            if (string.equals("name")) {
                                n = 12;
                            }
                            break;
                        }
                        case 3599307: {
                            if (string.equals("user")) {
                                n = 13;
                            }
                            break;
                        }
                    }
                    switch (n) {
                        case 12: {
                            name = xcp.text();
                            continue block30;
                        }
                        case 8: {
                            enabled = xcp.booleanValue();
                            continue block30;
                        }
                        case 10: {
                            schedule = Schedule.Companion.parse(xcp);
                            continue block30;
                        }
                        case 2: {
                            if (xcp.currentToken() == XContentParser.Token.VALUE_NULL) continue block30;
                            lookBackWindow = xcp.longValue();
                            continue block30;
                        }
                        case 5: {
                            if (xcp.currentToken() == XContentParser.Token.VALUE_NULL) continue block30;
                            timestampField = xcp.text();
                            continue block30;
                        }
                        case 11: {
                            lastUpdateTime = IndexUtilsKt.instant((XContentParser)xcp);
                            continue block30;
                        }
                        case 1: {
                            enabledTime = IndexUtilsKt.instant((XContentParser)xcp);
                            continue block30;
                        }
                        case 4: {
                            if (xcp.currentToken() == XContentParser.Token.VALUE_NULL) continue block30;
                            description = xcp.text();
                            continue block30;
                        }
                        case 13: {
                            if (xcp.currentToken() == XContentParser.Token.VALUE_NULL) continue block30;
                            user = User.parse((XContentParser)xcp);
                            continue block30;
                        }
                        case 7: {
                            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
                            while (xcp.nextToken() != XContentParser.Token.END_ARRAY) {
                                triggers.add(PPLSQLTrigger.Companion.parseInner(xcp));
                            }
                            continue block30;
                        }
                        case 9: {
                            schemaVersion = xcp.intValue();
                            continue block30;
                        }
                        case 6: {
                            QueryLanguage enumMatchResult;
                            String input = xcp.text();
                            Intrinsics.checkNotNull((Object)input);
                            if (QueryLanguage.Companion.enumFromString(input) == null) {
                                Collection<String> collection;
                                void $this$mapTo$iv$iv;
                                void $this$map$iv;
                                Iterable iterable = (Iterable)QueryLanguage.getEntries();
                                String string2 = input;
                                AlertingException.Companion companion = AlertingException.Companion;
                                boolean $i$f$map = false;
                                void var24_33 = $this$map$iv;
                                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                                boolean $i$f$mapTo = false;
                                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                                    void it;
                                    QueryLanguage queryLanguage2 = (QueryLanguage)((Object)item$iv$iv);
                                    collection = destination$iv$iv;
                                    boolean bl = false;
                                    collection.add(it.getValue());
                                }
                                collection = (List)destination$iv$iv;
                                String string3 = "Invalid value for query_language: " + string2 + ". Supported values are " + (List)collection;
                                throw companion.wrap((Exception)new IllegalArgumentException(string3));
                            }
                            queryLanguage = enumMatchResult;
                            continue block30;
                        }
                        case 3: {
                            query = xcp.text();
                            continue block30;
                        }
                    }
                }
                throw new IllegalArgumentException("Unexpected field when parsing PPL/SQL Monitor: " + fieldName);
            }
            if (enabled && enabledTime == null) {
                enabledTime = Instant.now();
            } else if (!enabled) {
                enabledTime = null;
            }
            if ((instant = lastUpdateTime) == null) {
                instant = lastUpdateTime = Instant.now();
            }
            if (name == null) {
                boolean $i$a$-requireNotNull-PPLSQLMonitor$Companion$parse$52 = false;
                String $i$a$-requireNotNull-PPLSQLMonitor$Companion$parse$52 = "Monitor name is null";
                throw new IllegalArgumentException($i$a$-requireNotNull-PPLSQLMonitor$Companion$parse$52.toString());
            }
            if (schedule == null) {
                boolean $i$a$-requireNotNull-PPLSQLMonitor$Companion$parse$62 = false;
                String $i$a$-requireNotNull-PPLSQLMonitor$Companion$parse$62 = "Schedule is null";
                throw new IllegalArgumentException($i$a$-requireNotNull-PPLSQLMonitor$Companion$parse$62.toString());
            }
            if (query == null) {
                boolean $i$a$-requireNotNull-PPLSQLMonitor$Companion$parse$72 = false;
                String $i$a$-requireNotNull-PPLSQLMonitor$Companion$parse$72 = "Query is null";
                throw new IllegalArgumentException($i$a$-requireNotNull-PPLSQLMonitor$Companion$parse$72.toString());
            }
            if (lastUpdateTime == null) {
                boolean bl = false;
                String string = "Last update time is null";
                throw new IllegalArgumentException(string.toString());
            }
            return new PPLSQLMonitor(id, version, name, enabled, schedule, lookBackWindow, timestampField, lastUpdateTime, enabledTime, description, user, triggers, schemaVersion, queryLanguage, query);
        }

        public static /* synthetic */ PPLSQLMonitor parse$default(Companion companion, XContentParser xContentParser, String string, long l, int n, Object object) throws IOException {
            if ((n & 2) != 0) {
                string = "";
            }
            if ((n & 4) != 0) {
                l = 1L;
            }
            return companion.parse(xContentParser, string, l);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final PPLSQLMonitor parse(@NotNull XContentParser xcp, @NotNull String id) throws IOException {
            Intrinsics.checkNotNullParameter((Object)xcp, (String)"xcp");
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            return org.opensearch.alerting.modelv2.PPLSQLMonitor$Companion.parse$default(this, xcp, id, 0L, 4, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final PPLSQLMonitor parse(@NotNull XContentParser xcp) throws IOException {
            Intrinsics.checkNotNullParameter((Object)xcp, (String)"xcp");
            return org.opensearch.alerting.modelv2.PPLSQLMonitor$Companion.parse$default(this, xcp, null, 0L, 6, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\b\u0086\u0081\u0002\u0018\u0000 \n2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\nB\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007j\u0002\b\bj\u0002\b\t\u00a8\u0006\u000b"}, d2={"Lorg/opensearch/alerting/modelv2/PPLSQLMonitor$QueryLanguage;", "", "value", "", "<init>", "(Ljava/lang/String;ILjava/lang/String;)V", "getValue", "()Ljava/lang/String;", "PPL", "SQL", "Companion", "opensearch-alerting"})
    public static final class QueryLanguage
    extends Enum<QueryLanguage> {
        @NotNull
        public static final Companion Companion;
        @NotNull
        private final String value;
        public static final /* enum */ QueryLanguage PPL;
        public static final /* enum */ QueryLanguage SQL;
        private static final /* synthetic */ QueryLanguage[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private QueryLanguage(String value) {
            this.value = value;
        }

        @NotNull
        public final String getValue() {
            return this.value;
        }

        public static QueryLanguage[] values() {
            return (QueryLanguage[])$VALUES.clone();
        }

        public static QueryLanguage valueOf(String value) {
            return Enum.valueOf(QueryLanguage.class, value);
        }

        @NotNull
        public static EnumEntries<QueryLanguage> getEntries() {
            return $ENTRIES;
        }

        static {
            PPL = new QueryLanguage(PPLSQLMonitor.PPL_QUERY_LANGUAGE);
            SQL = new QueryLanguage(PPLSQLMonitor.SQL_QUERY_LANGUAGE);
            $VALUES = queryLanguageArray = new QueryLanguage[]{QueryLanguage.PPL, QueryLanguage.SQL};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            Companion = new Companion(null);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lorg/opensearch/alerting/modelv2/PPLSQLMonitor$QueryLanguage$Companion;", "", "<init>", "()V", "enumFromString", "Lorg/opensearch/alerting/modelv2/PPLSQLMonitor$QueryLanguage;", "value", "", "opensearch-alerting"})
        @SourceDebugExtension(value={"SMAP\nPPLSQLMonitor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PPLSQLMonitor.kt\norg/opensearch/alerting/modelv2/PPLSQLMonitor$QueryLanguage$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,411:1\n295#2,2:412\n*S KotlinDebug\n*F\n+ 1 PPLSQLMonitor.kt\norg/opensearch/alerting/modelv2/PPLSQLMonitor$QueryLanguage$Companion\n*L\n280#1:412,2\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            @Nullable
            public final QueryLanguage enumFromString(@NotNull String value) {
                Object v0;
                block1: {
                    Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                    Iterable $this$firstOrNull$iv = (Iterable)QueryLanguage.getEntries();
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        QueryLanguage it = (QueryLanguage)((Object)element$iv);
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getValue(), (Object)value)) continue;
                        v0 = element$iv;
                        break block1;
                    }
                    v0 = null;
                }
                return v0;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

