/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.beans.impl.model;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.AnnotationModelHelper;
import org.netbeans.modules.web.beans.impl.model.AnnotationObjectProvider;
import org.netbeans.modules.web.beans.impl.model.Filter;
import org.netbeans.modules.web.beans.impl.model.WebBeansModelImplementation;

class MemberCheckerFilter<T extends Element>
extends Filter<T> {
    private WebBeansModelImplementation myImpl;
    private Map<? extends ExecutableElement, ? extends AnnotationValue> myValues;
    private Set<ExecutableElement> myMembers;
    private Class<T> myClass;

    private MemberCheckerFilter(Class<T> clazz) {
        this.myClass = clazz;
    }

    public static <T extends Element> MemberCheckerFilter<T> get(Class<T> clazz) {
        MemberCheckerFilter.assertElement(clazz);
        if (clazz.equals(Element.class)) {
            return new MemberCheckerFilter<Element>(Element.class);
        }
        if (clazz.equals(TypeElement.class)) {
            return new MemberCheckerFilter<TypeElement>(TypeElement.class);
        }
        return null;
    }

    void init(Map<? extends ExecutableElement, ? extends AnnotationValue> elementValues, Set<ExecutableElement> members, WebBeansModelImplementation impl) {
        this.myImpl = impl;
        this.myValues = elementValues;
        this.myMembers = members;
    }

    @Override
    void filter(Set<T> set) {
        super.filter(set);
        for (Map.Entry<ExecutableElement, AnnotationValue> entry : this.getValues().entrySet()) {
            ExecutableElement execElement = entry.getKey();
            AnnotationValue value = entry.getValue();
            if (!this.getMembers().contains(execElement)) continue;
            this.checkMember(execElement, value, set);
        }
    }

    Class<T> getElementClass() {
        return this.myClass;
    }

    static Element getSpecialized(ExecutableElement productionElement, WebBeansModelImplementation model, String annotationName) {
        return MemberCheckerFilter.getSpecialized(productionElement, model.getHelper(), annotationName);
    }

    static void visitSpecializes(ExecutableElement method, AnnotationModelHelper helper, AnnotationObjectProvider.SpecializeVisitor visitor) {
        ExecutableElement overridenElement;
        ExecutableElement current = method;
        while ((overridenElement = helper.getCompilationController().getElementUtilities().getOverriddenMethod(current)) != null && AnnotationObjectProvider.hasSpecializes(current, helper)) {
            if (visitor.visit(overridenElement)) {
                return;
            }
            current = overridenElement;
        }
    }

    static Element getSpecialized(ExecutableElement productionElement, final AnnotationModelHelper helper, final String annotationName) {
        final Element[] result = new Element[1];
        AnnotationObjectProvider.SpecializeVisitor visitor = new AnnotationObjectProvider.SpecializeVisitor(){

            @Override
            public boolean visit(ExecutableElement overridenElement) {
                if ("javax.enterprise.inject.Default".equals(annotationName) || "jakarta.enterprise.inject.Default".equals(annotationName)) {
                    if (AnnotationObjectProvider.checkSpecializedDefault(overridenElement, helper)) {
                        result[0] = overridenElement;
                        return true;
                    }
                } else if (AnnotationObjectProvider.hasAnnotation(overridenElement, annotationName, helper)) {
                    result[0] = overridenElement;
                    return true;
                }
                return false;
            }

            @Override
            public boolean visit(TypeElement superElement) {
                return false;
            }
        };
        MemberCheckerFilter.visitSpecializes(productionElement, helper, visitor);
        return result[0];
    }

    private void checkMember(ExecutableElement exec, AnnotationValue value, Set<T> elementsWithBindings) {
        Element annotationElement = exec.getEnclosingElement();
        if (!(annotationElement instanceof TypeElement)) {
            return;
        }
        String annotationName = ((TypeElement)annotationElement).getQualifiedName().toString();
        Iterator<T> iterator = elementsWithBindings.iterator();
        while (iterator.hasNext()) {
            Element specialized;
            Element element = (Element)iterator.next();
            if (this.checkMember(exec, value, element, iterator, annotationName)) continue;
            if (element instanceof TypeElement) {
                TypeElement specializedSuper = AnnotationObjectProvider.checkSuper((TypeElement)element, annotationName, this.getImplementation().getHelper());
                if (specializedSuper == null) continue;
                this.checkMember(exec, value, specializedSuper, iterator, annotationName);
                continue;
            }
            if (!(element instanceof ExecutableElement) || (specialized = MemberCheckerFilter.getSpecialized((ExecutableElement)element, this.getImplementation(), annotationName)) == null) continue;
            this.checkMember(exec, value, specialized, iterator, annotationName);
        }
    }

    private boolean checkMember(ExecutableElement exec, AnnotationValue value, Element elementWithBinding, Iterator<? extends Element> iterator, String annotationName) {
        List<? extends AnnotationMirror> allAnnotationMirrors = this.getImplementation().getHelper().getCompilationController().getElements().getAllAnnotationMirrors(elementWithBinding);
        AnnotationMirror annotationMirror = (AnnotationMirror)this.getImplementation().getHelper().getAnnotationsByType(allAnnotationMirrors).get(annotationName);
        if (annotationMirror == null) {
            return false;
        }
        Map<? extends ExecutableElement, ? extends AnnotationValue> elementValues = annotationMirror.getElementValues();
        AnnotationValue valueForType = elementValues.get(exec);
        if (!MemberCheckerFilter.equals(value, valueForType)) {
            iterator.remove();
        }
        return true;
    }

    static boolean equals(AnnotationValue value1, AnnotationValue value2) {
        if (value1 == null) {
            return value2 == null;
        }
        if (value1.getValue() == null) {
            return value2 != null && value2.getValue() == null;
        }
        return value1.getValue().equals(value2 == null ? null : value2.getValue());
    }

    private WebBeansModelImplementation getImplementation() {
        return this.myImpl;
    }

    private Map<? extends ExecutableElement, ? extends AnnotationValue> getValues() {
        return this.myValues;
    }

    private Set<ExecutableElement> getMembers() {
        return this.myMembers;
    }
}

