/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.weblogic.common;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.netbeans.api.extexecution.base.input.InputProcessor;
import org.netbeans.api.extexecution.base.input.InputReader;
import org.netbeans.modules.weblogic.common.api.WebLogicConfiguration;
import org.openide.util.RequestProcessor;

public class RemoteLogInputReader
implements InputReader {
    private static final Logger LOGGER = Logger.getLogger(RemoteLogInputReader.class.getName());
    private static final int INITIAL_LOG_COUNT = 300;
    private static final int POLL_INTERVAL = 2000;
    private final WebLogicConfiguration config;
    private final Callable<String> nonProxy;
    private final StringBuilder builder = new StringBuilder();
    private RequestProcessor worker;
    private volatile boolean closed;

    public RemoteLogInputReader(WebLogicConfiguration config, Callable<String> nonProxy) {
        this.config = config;
        this.nonProxy = nonProxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int readInput(InputProcessor processor) throws IOException {
        if (this.closed) {
            throw new IllegalStateException("Already closed reader");
        }
        RemoteLogInputReader remoteLogInputReader = this;
        synchronized (remoteLogInputReader) {
            if (this.worker == null) {
                this.worker = new RequestProcessor(RemoteLogInputReader.class);
                this.worker.post((Runnable)new Worker());
            } else {
                int length = this.builder.length();
                if (length > 0) {
                    if (processor != null) {
                        processor.processInput(this.builder.toString().toCharArray());
                    }
                    this.builder.setLength(0);
                    return length;
                }
            }
        }
        return 0;
    }

    public void close() throws IOException {
        this.closed = true;
    }

    static /* synthetic */ boolean access$100(RemoteLogInputReader x0) {
        return x0.closed;
    }

    static /* synthetic */ StringBuilder access$200(RemoteLogInputReader x0) {
        return x0.builder;
    }

    private class Worker
    implements Runnable {
        private JMXConnector connector;
        private boolean configured;
        private int recordIdIndex;
        private int timestampIndex;
        private int severityIndex;
        private int subsystemIndex;
        private int messageIdIndex;
        private int messageIndex;
        private Long recordId;

        private Worker() {
        }

        /*
         * Exception decompiling
         */
        @Override
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private JMXConnector getConnector() {
            if (this.connector != null) {
                return this.connector;
            }
            try {
                this.connector = RemoteLogInputReader.this.config.getRemote().executeAction(new Callable<JMXConnector>(){

                    @Override
                    public JMXConnector call() throws Exception {
                        JMXServiceURL url = new JMXServiceURL(RemoteLogInputReader.this.config.isSecured() ? "t3s" : "t3", RemoteLogInputReader.this.config.getHost(), RemoteLogInputReader.this.config.getPort(), "/jndi/weblogic.management.mbeanservers.domainruntime");
                        String username = RemoteLogInputReader.this.config.getUsername();
                        String password = RemoteLogInputReader.this.config.getPassword();
                        HashMap<String, Object> env = new HashMap<String, Object>();
                        env.put("jmx.remote.protocol.provider.pkgs", "weblogic.management.remote");
                        env.put("java.naming.security.principal", username);
                        env.put("java.naming.security.credentials", password);
                        env.put("jmx.remote.credentials", new String[]{username, password});
                        env.put("jmx.remote.protocol.provider.class.loader", RemoteLogInputReader.this.config.getLayout().getClassLoader());
                        JMXConnector jmxConnector = JMXConnectorFactory.newJMXConnector(url, env);
                        jmxConnector.connect();
                        return jmxConnector;
                    }
                }, (Callable<String>)RemoteLogInputReader.this.nonProxy);
            }
            catch (Exception ex) {
                this.connector = null;
                LOGGER.log(Level.INFO, null, ex);
            }
            return this.connector;
        }

        private void closeConnector() {
            if (this.connector != null) {
                try {
                    this.connector.close();
                    this.connector = null;
                    this.configured = false;
                }
                catch (IOException ex1) {
                    LOGGER.log(Level.FINE, null, ex1);
                }
            }
        }

        private void setColumns(MBeanServerConnection connection, ObjectName wldf) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException, IOException {
            if (this.configured) {
                return;
            }
            Map columnIndexMap = (Map)connection.getAttribute(wldf, "ColumnIndexMap");
            this.recordIdIndex = (Integer)columnIndexMap.get("RECORDID");
            this.timestampIndex = (Integer)columnIndexMap.get("DATE");
            this.severityIndex = (Integer)columnIndexMap.get("SEVERITY");
            this.subsystemIndex = (Integer)columnIndexMap.get("SUBSYSTEM");
            this.messageIdIndex = (Integer)columnIndexMap.get("MSGID");
            this.messageIndex = (Integer)columnIndexMap.get("MESSAGE");
            this.configured = true;
        }

        private void append(StringBuilder builder, Object value) {
            builder.append("<");
            builder.append(value.toString());
            builder.append("> ");
        }
    }
}

