/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.notifications;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JTextPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.netbeans.modules.subversion.FileInformation;
import org.netbeans.modules.subversion.FileStatusCache;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.client.SvnClient;
import org.netbeans.modules.subversion.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.ui.diff.DiffAction;
import org.netbeans.modules.subversion.ui.history.SearchHistoryAction;
import org.netbeans.modules.subversion.util.Context;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.netbeans.modules.versioning.util.VCSNotificationDisplayer;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakSet;
import org.tigris.subversion.svnclientadapter.ISVNInfo;
import org.tigris.subversion.svnclientadapter.ISVNStatus;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNStatusKind;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class NotificationsManager {
    private static NotificationsManager instance;
    private static final Logger LOG;
    private static final Set<File> alreadySeen;
    private static final String CMD_DIFF = "cmd.diff";
    private final HashSet<File> files;
    private final RequestProcessor rp;
    private final RequestProcessor.Task notificationTask;
    private final FileStatusCache cache;
    private Boolean enabled;
    private Map<File, Long> notifiedFiles = Collections.synchronizedMap(new HashMap());

    private NotificationsManager() {
        this.files = new HashSet();
        this.rp = new RequestProcessor("SubversionNotifications", 1, true);
        this.notificationTask = this.rp.create((Runnable)new NotificationTask());
        this.cache = Subversion.getInstance().getStatusCache();
    }

    public static synchronized NotificationsManager getInstance() {
        if (instance == null) {
            instance = new NotificationsManager();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleFor(File file) {
        boolean refresh;
        if (this.isSeen(file) || !this.isUpToDate(file) || !this.isEnabled(file)) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.log(Level.FINER, "File {0} is {1} up to date, notifications enabled: {2}", new Object[]{file.getAbsolutePath(), this.isUpToDate(file) ? "" : "not ", this.isEnabled(file)});
            }
            return;
        }
        HashSet<File> hashSet = this.files;
        synchronized (hashSet) {
            int size = this.files.size();
            this.files.add(file);
            refresh = this.files.size() != size;
        }
        if (refresh) {
            this.notificationTask.schedule(1000);
        }
    }

    public void notfied(File[] files, Long revision) {
        for (File file : files) {
            this.notifiedFiles.put(file, revision);
        }
    }

    public void setupPane(JTextPane pane, final File[] files, String fileNames, final File projectDir, final String url, final String revision) {
        String msg = revision == null ? NbBundle.getMessage(NotificationsManager.class, (String)"MSG_NotificationBubble_DeleteDescription", (Object)fileNames, (Object)CMD_DIFF) : NbBundle.getMessage(NotificationsManager.class, (String)"MSG_NotificationBubble_Description", (Object)fileNames, (Object)url, (Object)CMD_DIFF);
        pane.setText(msg);
        pane.addHyperlinkListener(new HyperlinkListener(){
            final /* synthetic */ NotificationsManager this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType().equals(HyperlinkEvent.EventType.ACTIVATED)) {
                    if (NotificationsManager.CMD_DIFF.equals(e.getDescription())) {
                        Context ctx = new Context(files);
                        DiffAction.diff(ctx, 1, NbBundle.getMessage(NotificationsManager.class, (String)"LBL_Remote_Changes", (Object)projectDir.getName()), false);
                    } else if (revision != null) {
                        try {
                            SearchHistoryAction.openSearch(new SVNUrl(url), projectDir, Long.parseLong(revision));
                        }
                        catch (MalformedURLException ex) {
                            LOG.log(Level.WARNING, null, ex);
                        }
                    }
                }
            }
        });
    }

    private boolean isEnabled(File file) {
        if (this.enabled == null) {
            this.enabled = !"false".equals(System.getProperty("subversion.notificationsEnabled", "true"));
        }
        return this.enabled;
    }

    private boolean isUpToDate(File file) {
        boolean upToDate = false;
        FileInformation info = this.cache.getCachedStatus(file);
        if (info == null || (info.getStatus() & 8) != 0 && !info.isDirectory()) {
            upToDate = true;
        }
        return upToDate;
    }

    private boolean isSeen(File file) {
        return alreadySeen.contains(file) || this.notifiedFiles.containsKey(file);
    }

    static {
        LOG = Logger.getLogger(NotificationsManager.class.getName());
        alreadySeen = Collections.synchronizedSet(new WeakSet());
    }

    private class NotificationTask
    extends VCSNotificationDisplayer
    implements Runnable {
        private NotificationTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            HashSet<File> filesToScan;
            HashSet hashSet = NotificationsManager.this.files;
            synchronized (hashSet) {
                filesToScan = new HashSet<File>(NotificationsManager.this.files);
                NotificationsManager.this.files.clear();
            }
            this.removeDirectories(filesToScan);
            this.removeSeenFiles(filesToScan);
            this.removeNotEnabled(filesToScan);
            if (!filesToScan.isEmpty()) {
                this.scanFiles(filesToScan);
            }
        }

        protected void setupPane(JTextPane pane, File[] files, File projectDir, String url, String revision) {
            NotificationsManager.this.setupPane(pane, files, this.getFileNames(files), projectDir, url, revision);
        }

        private void removeDirectories(Collection<File> filesToScan) {
            Iterator<File> it = filesToScan.iterator();
            while (it.hasNext()) {
                File file = it.next();
                if (file.isFile()) continue;
                it.remove();
            }
        }

        private void removeNotEnabled(Collection<File> filesToScan) {
            Iterator<File> it = filesToScan.iterator();
            while (it.hasNext()) {
                File file = it.next();
                if (NotificationsManager.this.isEnabled(file)) continue;
                if (LOG.isLoggable(Level.FINER)) {
                    LOG.log(Level.FINER, "File {0} is probably not from kenai, notifications disabled", new Object[]{file.getAbsolutePath()});
                }
                it.remove();
            }
        }

        private void removeSeenFiles(Collection<File> filesToScan) {
            Iterator<File> it = filesToScan.iterator();
            while (it.hasNext()) {
                File file = it.next();
                if (!NotificationsManager.this.isSeen(file)) continue;
                it.remove();
            }
        }

        private void scanFiles(Collection<File> filesToScan) {
            HashMap<SVNUrl, HashSet<File>> filesPerRepository = this.sortByRepository(filesToScan);
            for (Map.Entry<SVNUrl, HashSet<File>> entry : filesPerRepository.entrySet()) {
                HashMap<Long, Notification> notifications;
                SVNUrl repositoryUrl;
                block9: {
                    repositoryUrl = entry.getKey();
                    notifications = new HashMap<Long, Notification>();
                    try {
                        ISVNStatus[] statuses;
                        SvnClient client = Subversion.getInstance().getClient(repositoryUrl);
                        if (client == null) break block9;
                        HashSet<File> files = entry.getValue();
                        for (ISVNStatus status : statuses = client.getStatus(files.toArray(new File[0]))) {
                            Long repositoryRev;
                            boolean removed;
                            ISVNInfo info;
                            SVNRevision.Number rev;
                            File file;
                            block10: {
                                if (SVNStatusKind.UNVERSIONED.equals((Object)status.getTextStatus()) || SVNStatusKind.IGNORED.equals((Object)status.getTextStatus())) continue;
                                file = status.getFile();
                                rev = status.getRevision();
                                info = null;
                                removed = false;
                                try {
                                    SVNUrl url = status.getUrl();
                                    if (url == null) {
                                        String canonicalPath;
                                        try {
                                            canonicalPath = status.getFile().getCanonicalPath();
                                        }
                                        catch (IOException ex) {
                                            canonicalPath = null;
                                        }
                                        LOG.log(Level.WARNING, "scanFiles: though versioned it has no svn url: {0}, {1}, {2}, {3}, {4}", new Object[]{file, status.getFile(), status.getTextStatus(), status.getUrlString(), canonicalPath});
                                        break block10;
                                    }
                                    info = client.getInfo(url, SVNRevision.HEAD, (SVNRevision)rev);
                                }
                                catch (SVNClientException ex) {
                                    LOG.log(Level.FINE, null, ex);
                                    removed = SvnClientExceptionHandler.isFileNotFoundInRevision(ex.getMessage());
                                }
                            }
                            if (info == null && !removed) continue;
                            Long l = repositoryRev = removed ? null : Long.valueOf(info.getLastChangedRevision().getNumber());
                            if (!this.isModifiedInRepository(rev.getNumber(), repositoryRev)) continue;
                            this.addToMap(notifications, file, repositoryRev);
                            NotificationsManager.this.cache.refresh(file, new FileStatusCache.RepositoryStatus(status, null));
                        }
                        alreadySeen.addAll(files);
                    }
                    catch (SVNClientException ex) {
                        LOG.log(Level.FINE, null, ex);
                    }
                }
                this.notifyChanges(notifications, repositoryUrl);
            }
        }

        private boolean isModifiedInRepository(long revision, Long repositoryRevision) {
            return repositoryRevision == null || revision < repositoryRevision;
        }

        private void addToMap(HashMap<Long, Notification> notifications, File file, Long revision) {
            Notification revisionNotification = notifications.get(revision);
            if (revisionNotification == null) {
                revisionNotification = new Notification(revision);
                notifications.put(revision, revisionNotification);
            }
            revisionNotification.addFile(file);
        }

        private HashMap<SVNUrl, HashSet<File>> sortByRepository(Collection<File> files) {
            HashMap<SVNUrl, HashSet<File>> filesByRepository = new HashMap<SVNUrl, HashSet<File>>();
            for (File file : files) {
                SVNUrl repositoryUrl = this.getRepositoryRoot(file);
                if (repositoryUrl == null) continue;
                HashSet<File> filesPerRepository = filesByRepository.get(repositoryUrl);
                if (filesPerRepository == null) {
                    filesPerRepository = new HashSet();
                    filesByRepository.put(repositoryUrl, filesPerRepository);
                }
                filesPerRepository.add(file);
            }
            return filesByRepository;
        }

        private void notifyChanges(HashMap<Long, Notification> notifications, SVNUrl repositoryUrl) {
            for (Map.Entry<Long, Notification> e : notifications.entrySet()) {
                Notification notification = e.getValue();
                File[] files = notification.getFiles();
                Long revision = notification.getRevision();
                this.notifyFileChange(files, files[0].getParentFile(), repositoryUrl.toString(), revision == null ? null : revision.toString());
            }
        }

        private SVNUrl getRepositoryRoot(File file) {
            SVNUrl repositoryUrl = null;
            SVNUrl url = this.getRepositoryUrl(file);
            return repositoryUrl;
        }

        private SVNUrl getRepositoryUrl(File file) {
            SVNUrl url = null;
            try {
                url = SvnUtils.getRepositoryRootUrl(file);
            }
            catch (SVNClientException ex) {
                LOG.log(Level.FINE, "getRepositoryUrl: No repository root url found for managed file : [" + file + "]", ex);
                try {
                    url = SvnUtils.getRepositoryUrl(file);
                }
                catch (SVNClientException ex1) {
                    LOG.log(Level.FINE, "getRepositoryUrl: No repository url found for managed file : [" + file + "]", ex1);
                }
            }
            return url;
        }

        private class Notification {
            private final Set<File> files = new HashSet<File>();
            private final Long revision;

            Notification(Long revision) {
                this.revision = revision;
            }

            void addFile(File file) {
                this.files.add(file);
            }

            File[] getFiles() {
                return this.files.toArray(new File[0]);
            }

            Long getRevision() {
                return this.revision;
            }
        }
    }
}

