/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hudson.ant;

import java.util.ArrayList;
import java.util.List;
import org.netbeans.api.java.queries.UnitTestForSourceQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.hudson.ant.AntBasedJobCreator;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public abstract class ProjectTypes
implements AntBasedJobCreator {
    private final String type;
    private final TargetTemplate[] templates;

    private ProjectTypes(String type, TargetTemplate[] templates) {
        this.type = type;
        this.templates = templates;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public AntBasedJobCreator.Configuration forProject(Project project) {
        return new ConfigurationImpl(project);
    }

    private static class TargetTemplate {
        private final String antName;
        private final String bundleKey;
        private final boolean mandatory;
        private final String artifactIncludes;
        private final String artifactExcludes;
        private final String javadocDir;
        private final boolean checkForTests;
        private final String testResults;
        private final String properties;

        TargetTemplate(String antName, String bundleKey, boolean mandatory, String artifactIncludes, String artifactExcludes, String javadocDir, boolean checkForTests, String testResults, String properties) {
            this.antName = antName;
            this.bundleKey = bundleKey;
            assert (!mandatory || !checkForTests);
            this.mandatory = mandatory;
            this.artifactIncludes = artifactIncludes;
            this.artifactExcludes = artifactExcludes;
            this.javadocDir = javadocDir;
            this.checkForTests = checkForTests;
            this.testResults = testResults;
            this.properties = properties;
        }
    }

    private class ConfigurationImpl
    implements AntBasedJobCreator.Configuration {
        private final Project project;

        ConfigurationImpl(Project project) {
            this.project = project;
        }

        @Override
        public List<AntBasedJobCreator.Target> targets() {
            ArrayList<AntBasedJobCreator.Target> targets = new ArrayList<AntBasedJobCreator.Target>();
            for (final TargetTemplate template : ProjectTypes.this.templates) {
                targets.add(new AntBasedJobCreator.Target(){
                    final boolean selected;
                    final /* synthetic */ ConfigurationImpl this$1;
                    {
                        this.this$1 = this$1;
                        this.selected = !template.checkForTests || this.hasTests(this.this$1.project);
                    }

                    @Override
                    public String antName() {
                        return template.antName;
                    }

                    @Override
                    public String labelWithMnemonic() {
                        return NbBundle.getMessage(ProjectTypes.class, (String)template.bundleKey);
                    }

                    @Override
                    public boolean selected() {
                        return this.selected;
                    }

                    @Override
                    public boolean enabled() {
                        return this.selected && !template.mandatory;
                    }

                    @Override
                    public AntBasedJobCreator.ArchivePattern artifactArchival() {
                        if (template.artifactIncludes != null) {
                            return new AntBasedJobCreator.ArchivePattern(){
                                final /* synthetic */ 1 this$2;
                                {
                                    this.this$2 = this$2;
                                }

                                @Override
                                public String includes() {
                                    return template.artifactIncludes;
                                }

                                @Override
                                public String excludes() {
                                    return template.artifactExcludes;
                                }
                            };
                        }
                        return null;
                    }

                    @Override
                    public String javadocDir() {
                        return template.javadocDir;
                    }

                    @Override
                    public String testResults() {
                        return template.testResults;
                    }

                    @Override
                    public String properties() {
                        return template.properties;
                    }

                    boolean hasTests(Project project) {
                        for (SourceGroup g : ProjectUtils.getSources((Project)project).getSourceGroups("java")) {
                            FileObject root = g.getRootFolder();
                            if (UnitTestForSourceQuery.findSources((FileObject)root).length <= 0 || !this.containsSources(root)) continue;
                            return true;
                        }
                        return false;
                    }

                    boolean containsSources(FileObject f) {
                        if (f.isFolder()) {
                            for (FileObject k : f.getChildren()) {
                                if (!this.containsSources(k)) continue;
                                return true;
                            }
                            return false;
                        }
                        return f.hasExt("java");
                    }
                });
            }
            return targets;
        }
    }

    public static class EAR
    extends ProjectTypes {
        public EAR() {
            super("org.netbeans.modules.j2ee.earproject", new TargetTemplate[]{new TargetTemplate("dist", "ProjectTypes.buildDist.text", true, "dist/", "dist/javadoc/", null, false, null, null)});
        }
    }

    public static class CAR
    extends ProjectTypes {
        public CAR() {
            super("org.netbeans.modules.j2ee.clientproject", new TargetTemplate[]{new TargetTemplate("dist", "ProjectTypes.buildDist.text", true, "dist/", "dist/javadoc/", null, false, null, null), new TargetTemplate("javadoc", "ProjectTypes.buildJavadoc.text", false, null, null, "dist/javadoc", false, null, null), new TargetTemplate("test", "ProjectTypes.runTests.text", false, null, null, null, true, "build/test/results/TEST-*.xml", "ignore.failing.tests=true")});
        }
    }

    public static class EJB
    extends ProjectTypes {
        public EJB() {
            super("org.netbeans.modules.j2ee.ejbjarproject", new TargetTemplate[]{new TargetTemplate("dist", "ProjectTypes.buildDist.text", true, "dist/", "dist/javadoc/", null, false, null, null), new TargetTemplate("javadoc", "ProjectTypes.buildJavadoc.text", false, null, null, "dist/javadoc", false, null, null), new TargetTemplate("test", "ProjectTypes.runTests.text", false, null, null, null, true, "build/test/results/TEST-*.xml", "ignore.failing.tests=true")});
        }
    }

    public static class Web
    extends ProjectTypes {
        public Web() {
            super("org.netbeans.modules.web.project", new TargetTemplate[]{new TargetTemplate("dist", "ProjectTypes.buildDist.text", true, "dist/", "dist/javadoc/", null, false, null, null), new TargetTemplate("javadoc", "ProjectTypes.buildJavadoc.text", false, null, null, "dist/javadoc", false, null, null), new TargetTemplate("test", "ProjectTypes.runTests.text", false, null, null, null, true, "build/test/results/TEST-*.xml", "ignore.failing.tests=true")});
        }
    }

    public static class J2SE
    extends ProjectTypes {
        public J2SE() {
            super("org.netbeans.modules.java.j2seproject", new TargetTemplate[]{new TargetTemplate("jar", "ProjectTypes.buildJar.text", true, "dist/", "dist/javadoc/", null, false, null, null), new TargetTemplate("javadoc", "ProjectTypes.buildJavadoc.text", false, null, null, "dist/javadoc", false, null, null), new TargetTemplate("test", "ProjectTypes.runTests.text", false, null, null, null, true, "build/test/results/TEST-*.xml", "ignore.failing.tests=true")});
        }
    }
}

