/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.js.breakpoints.io;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.Properties;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.javascript2.debug.EditorLineHandler;
import org.netbeans.modules.javascript2.debug.EditorLineHandlerFactory;
import org.netbeans.modules.javascript2.debug.breakpoints.JSLineBreakpoint;
import org.netbeans.modules.javascript2.debug.breakpoints.io.BreakpointsFromGroup;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;

public class JSBreakpointReader
implements Properties.Reader {
    private static final Logger LOG = Logger.getLogger(JSBreakpointReader.class.getName());
    private static final String BREAKPOINTS_TO_ENABLE = "breakpointsToEnable";
    private static final String BREAKPOINTS_TO_DISABLE = "breakpointsToDisable";
    private static final String BP_CUSTOM_GROUP = "CustomGroup";
    private static final String BP_FILE_GROUP = "FileGroup";
    private static final String BP_PROJECT_GROUP = "ProjectGroup";
    private static final String BP_TYPE_GROUP = "TypeGroup";
    private static final String OLD_JS_LINE_BP = "org.netbeans.modules.debugger.jpda.js.breakpoints.JSLineBreakpoint";

    public String[] getSupportedClassNames() {
        return new String[]{OLD_JS_LINE_BP};
    }

    public Object read(String className, Properties properties) {
        JSLineBreakpoint b = null;
        if (className.equals(OLD_JS_LINE_BP)) {
            String urlStr = properties.getString("url", null);
            int lineNumber = properties.getInt("lineNumber", 1);
            try {
                URL url = new URL(urlStr);
                FileObject fo = URLMapper.findFileObject((URL)url);
                if (fo == null) {
                    if ("js-scripts".equals(url.getProtocol())) {
                        EditorLineHandler lineHandler = EditorLineHandlerFactory.getHandler((URL)url, (int)lineNumber);
                        return new JSLineBreakpoint(lineHandler);
                    }
                    return null;
                }
                EditorLineHandler lineHandler = EditorLineHandlerFactory.getHandler((FileObject)fo, (int)lineNumber);
                if (lineHandler == null) {
                    return null;
                }
                b = new JSLineBreakpoint(lineHandler);
            }
            catch (MalformedURLException ex) {
                LOG.log(Level.CONFIG, "urlStr = " + urlStr, ex);
                return null;
            }
        }
        if (b == null) {
            throw new IllegalStateException("Unknown breakpoint type: \"" + className + "\"");
        }
        b.setCondition(properties.getString("condition", null));
        b.setGroupName(properties.getString("groupName", ""));
        int hitCountFilter = properties.getInt("hitCountFilter", 0);
        Breakpoint.HIT_COUNT_FILTERING_STYLE hitCountFilteringStyle = hitCountFilter > 0 ? Breakpoint.HIT_COUNT_FILTERING_STYLE.values()[properties.getInt("hitCountFilter_style", 0)] : null;
        b.setHitCountFilter(hitCountFilter, hitCountFilteringStyle);
        if (properties.getBoolean("enabled", true)) {
            b.enable();
        } else {
            b.disable();
        }
        if (b.canHaveDependentBreakpoints()) {
            b.setBreakpointsToEnable(JSBreakpointReader.getBreakpointsFromGroup(properties, BREAKPOINTS_TO_ENABLE));
            b.setBreakpointsToDisable(JSBreakpointReader.getBreakpointsFromGroup(properties, BREAKPOINTS_TO_DISABLE));
        }
        return b;
    }

    public void write(Object object, Properties properties) {
    }

    private static Set<Breakpoint> getBreakpointsFromGroup(Properties properties, String base) {
        FileObject fo;
        URL url2;
        String bpGroup = properties.getString(base + BP_CUSTOM_GROUP, null);
        if (bpGroup != null) {
            return new BreakpointsFromGroup(bpGroup);
        }
        bpGroup = properties.getString(base + BP_FILE_GROUP, null);
        if (bpGroup != null) {
            try {
                url2 = new URL(bpGroup);
                fo = URLMapper.findFileObject((URL)url2);
                if (fo != null) {
                    return new BreakpointsFromGroup(new BreakpointsFromGroup.TestGroupProperties(fo));
                }
            }
            catch (MalformedURLException url2) {
                // empty catch block
            }
        }
        if ((bpGroup = properties.getString(base + BP_PROJECT_GROUP, null)) != null) {
            try {
                Project project;
                url2 = new URL(bpGroup);
                fo = URLMapper.findFileObject((URL)url2);
                if (fo != null && (project = ProjectManager.getDefault().findProject(fo)) != null) {
                    return new BreakpointsFromGroup(new BreakpointsFromGroup.TestGroupProperties(project));
                }
            }
            catch (IOException | IllegalArgumentException exception) {
                // empty catch block
            }
        }
        if ((bpGroup = properties.getString(base + BP_TYPE_GROUP, null)) != null) {
            return new BreakpointsFromGroup(new BreakpointsFromGroup.TestGroupProperties(bpGroup));
        }
        return Collections.emptySet();
    }
}

