/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javaee.wildfly.nodes;

import java.awt.Image;
import javax.swing.Action;
import org.netbeans.modules.j2ee.deployment.common.api.MessageDestination;
import org.netbeans.modules.javaee.wildfly.config.WildflyMessageDestination;
import org.netbeans.modules.javaee.wildfly.nodes.SimplePropertySupport;
import org.netbeans.modules.javaee.wildfly.nodes.WildflyDatasourceNode;
import org.netbeans.modules.javaee.wildfly.nodes.actions.ResourceType;
import org.netbeans.modules.javaee.wildfly.nodes.actions.UndeployModuleAction;
import org.netbeans.modules.javaee.wildfly.nodes.actions.UndeployModuleCookieImpl;
import org.openide.actions.PropertiesAction;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

public class WildflyDestinationNode
extends AbstractNode {
    public WildflyDestinationNode(String name, WildflyMessageDestination destination, Lookup lookup) {
        super(Children.LEAF);
        this.getCookieSet().add((Node.Cookie)new UndeployModuleCookieImpl(destination.getName(), destination.getType() == MessageDestination.Type.QUEUE ? ResourceType.QUEUE : ResourceType.TOPIC, lookup));
        this.setDisplayName(destination.getName());
        this.setName(name);
        this.setShortDescription(destination.getName());
        this.initProperties(destination);
    }

    protected void initProperties(WildflyMessageDestination destination) {
        int i = 0;
        for (String jndiEntry : destination.getJndiNames()) {
            this.addProperty("JndiName_" + i, jndiEntry);
            ++i;
        }
    }

    private void addProperty(String name, String value) {
        String displayName = NbBundle.getMessage(WildflyDatasourceNode.class, (String)"LBL_Resources_JMS_Destination_JNDI_Name");
        String description = NbBundle.getMessage(WildflyDatasourceNode.class, (String)"DESC_Resources_JMS_Destination_JNDI_Name");
        SimplePropertySupport ps = new SimplePropertySupport(name, value, displayName, description);
        this.getSheet().get("properties").put((Node.Property)ps);
    }

    protected Sheet createSheet() {
        Sheet sheet = Sheet.createDefault();
        this.setSheet(sheet);
        return sheet;
    }

    public Action[] getActions(boolean context) {
        return new SystemAction[]{SystemAction.get(PropertiesAction.class), SystemAction.get(UndeployModuleAction.class)};
    }

    public Image getIcon(int type) {
        return ImageUtilities.loadImage((String)"org/netbeans/modules/javaee/wildfly/resources/jms.gif");
    }

    public Image getOpenedIcon(int type) {
        return ImageUtilities.loadImage((String)"org/netbeans/modules/javaee/wildfly/resources/jms.gif");
    }
}

