/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.v2;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Objects;
import javax.swing.SwingUtilities;
import org.netbeans.modules.profiler.LoadedSnapshot;
import org.netbeans.modules.profiler.ResultsManager;
import org.netbeans.modules.profiler.SnapshotsListener;
import org.netbeans.modules.profiler.api.ProfilerIDESettings;
import org.netbeans.modules.profiler.v2.ProfilerSession;
import org.netbeans.modules.profiler.v2.impl.SnapshotsWindowHelper;
import org.netbeans.modules.profiler.v2.impl.SnapshotsWindowUI;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public final class SnapshotsWindow {
    private static SnapshotsWindow INSTANCE;
    private final SnapshotsListener snapshotsListener = (SnapshotsListener)Lookup.getDefault().lookup(SnapshotsWindowHelper.class);
    private SnapshotsWindowUI ui;

    public static synchronized SnapshotsWindow instance() {
        if (INSTANCE == null) {
            INSTANCE = new SnapshotsWindow();
        }
        return INSTANCE;
    }

    private SnapshotsWindow() {
        TopComponent.getRegistry().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("tcClosed".equals(evt.getPropertyName()) && SnapshotsWindow.this.ui != null && evt.getNewValue() == SnapshotsWindow.this.ui) {
                    SnapshotsWindow.this.ui = null;
                }
            }
        });
    }

    public void showStandalone() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SnapshotsWindowUI ui = SnapshotsWindow.this.getUI(true);
                ui.open();
                ui.requestActive();
            }
        });
    }

    public void sessionOpened(final ProfilerSession session) {
        SwingUtilities.invokeLater(new Runnable(){
            final /* synthetic */ SnapshotsWindow this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                SnapshotsWindowUI ui = this.this$0.getUI(false);
                if (ui == null && ProfilerIDESettings.getInstance().getSnapshotWindowOpenPolicy() == 1) {
                    ui = this.this$0.getUI(true);
                    ui.setProject(session.getProject());
                    ui.open();
                } else if (ui != null) {
                    ui.setProject(session.getProject());
                }
            }
        });
    }

    public void sessionActivated(final ProfilerSession session) {
        SwingUtilities.invokeLater(new Runnable(){
            final /* synthetic */ SnapshotsWindow this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                SnapshotsWindowUI ui = this.this$0.getUI(false);
                if (ui == null && ProfilerIDESettings.getInstance().getSnapshotWindowOpenPolicy() == 2) {
                    ui = this.this$0.getUI(true);
                    ui.setProject(session.getProject());
                    ui.open();
                } else if (ui != null) {
                    ui.setProject(session.getProject());
                }
            }
        });
    }

    public void sessionDeactivated(final ProfilerSession session) {
        SwingUtilities.invokeLater(new Runnable(){
            final /* synthetic */ SnapshotsWindow this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                SnapshotsWindowUI ui = this.this$0.getUI(false);
                if (ui != null) {
                    if (ProfilerIDESettings.getInstance().getSnapshotWindowClosePolicy() == 2) {
                        ui.close();
                    }
                    ui.resetProject(session.getProject());
                }
            }
        });
    }

    public void sessionClosed(final ProfilerSession session) {
        SwingUtilities.invokeLater(new Runnable(){
            final /* synthetic */ SnapshotsWindow this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                SnapshotsWindowUI ui = this.this$0.getUI(false);
                if (ui != null) {
                    if (ProfilerIDESettings.getInstance().getSnapshotWindowClosePolicy() == 1) {
                        ui.close();
                    }
                    ui.resetProject(session.getProject());
                }
            }
        });
    }

    public void snapshotSaved(LoadedSnapshot snapshot) {
        assert (!SwingUtilities.isEventDispatchThread());
        int policy = ProfilerIDESettings.getInstance().getSnapshotWindowOpenPolicy();
        if (policy == 3 && ResultsManager.getDefault().getSnapshotsCountFor(snapshot.getProject()) == 1 || policy == 4) {
            final Lookup.Provider project = snapshot.getProject();
            ProfilerSession session = ProfilerSession.currentSession();
            if (session != null && Objects.equals(session.getProject(), project)) {
                SwingUtilities.invokeLater(new Runnable(){
                    final /* synthetic */ SnapshotsWindow this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public void run() {
                        SnapshotsWindowUI ui = this.this$0.getUI(false);
                        if (ui == null) {
                            ui = this.this$0.getUI(true);
                            ui.setProject(project);
                            ui.open();
                        }
                    }
                });
            }
        }
    }

    public void refreshFolder(final FileObject folder, final boolean fullRefresh) {
        SwingUtilities.invokeLater(new Runnable(){
            final /* synthetic */ SnapshotsWindow this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                SnapshotsWindowUI ui = this.this$0.getUI(false);
                if (ui != null) {
                    ui.refreshFolder(folder, fullRefresh);
                }
            }
        });
    }

    private SnapshotsWindowUI getUI(boolean create) {
        if (this.ui == null) {
            WindowManager wm = WindowManager.getDefault();
            for (TopComponent tc : TopComponent.getRegistry().getOpened()) {
                if (tc.getClientProperty((Object)"SnapshotsWindowUI") == null) continue;
                this.ui = (SnapshotsWindowUI)tc;
            }
            if (this.ui == null && create) {
                this.ui = (SnapshotsWindowUI)wm.findTopComponent("SnapshotsWindowUI");
            }
            if (this.ui == null && create) {
                this.ui = new SnapshotsWindowUI();
            }
        }
        return this.ui;
    }
}

