/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.selenium2.webclient.protractor;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.netbeans.api.project.Project;
import org.netbeans.modules.selenium2.webclient.protractor.Bundle;
import org.netbeans.modules.selenium2.webclient.protractor.preferences.ProtractorPreferences;
import org.netbeans.modules.selenium2.webclient.protractor.preferences.ProtractorPreferencesValidator;
import org.netbeans.modules.web.common.api.ValidationResult;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileChooserBuilder;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class CustomizerProtractor
extends JPanel {
    private final Project project;
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private boolean autoDiscovered = false;
    private volatile String protractor;
    private volatile String userConfigurationFile;
    private ValidationResult validationResult;
    private JButton protractorDirBrowseButton;
    private JLabel protractorDirInfoLabel;
    private JLabel protractorDirLabel;
    private JTextField protractorDirTextField;
    private JButton userConfigurationFileBrowseButton;
    private JLabel userConfigurationFileInfoLabel;
    private JLabel userConfigurationFileLabel;
    private JTextField userConfigurationFileTextField;

    public CustomizerProtractor(Project project) {
        assert (EventQueue.isDispatchThread());
        assert (project != null);
        this.project = project;
        this.initComponents();
        this.init();
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }

    public String getProtractor() {
        return this.protractor;
    }

    public String getUserConfigurationFile() {
        return this.userConfigurationFile;
    }

    public String getWarningMessage() {
        assert (EventQueue.isDispatchThread());
        Iterator iterator = this.validationResult.getWarnings().iterator();
        if (iterator.hasNext()) {
            ValidationResult.Message message = (ValidationResult.Message)iterator.next();
            return message.getMessage();
        }
        return null;
    }

    public String getErrorMessage() {
        assert (EventQueue.isDispatchThread());
        Iterator iterator = this.validationResult.getErrors().iterator();
        if (iterator.hasNext()) {
            ValidationResult.Message message = (ValidationResult.Message)iterator.next();
            return message.getMessage();
        }
        return null;
    }

    private void init() {
        String exec;
        String userPath;
        assert (EventQueue.isDispatchThread());
        String protractorExec = ProtractorPreferences.getProtractor(this.project);
        if (protractorExec == null && (userPath = System.getenv("PATH")) != null) {
            List<String> paths = Arrays.asList(userPath.split(File.pathSeparator));
            String execName = "protractor";
            for (String path : paths) {
                File file = new File(path);
                if (file.isFile()) {
                    if (!path.endsWith("protractor") || !this.isProtractorExecValid(path)) continue;
                    try {
                        protractorExec = file.getCanonicalPath();
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    break;
                }
                String[] list = file.list(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return name.endsWith("protractor");
                    }
                });
                if (list == null || list.length != 1) continue;
                this.autoDiscovered = true;
                if (Utilities.isWindows()) {
                    protractorExec = new File(path, "node_modules/protractor/bin/protractor").getAbsolutePath();
                    break;
                }
                protractorExec = path.endsWith(File.separator) ? path + "protractor" : path + File.separator + "protractor";
                File f = new File(protractorExec);
                try {
                    protractorExec = f.getCanonicalPath();
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                break;
            }
        }
        if (protractorExec == null && this.isProtractorExecValid(exec = new File(FileUtil.toFile((FileObject)this.project.getProjectDirectory()), "node_modules/protractor/bin/protractor").getAbsolutePath())) {
            protractorExec = exec;
        }
        this.protractorDirTextField.setText(protractorExec);
        this.protractorDirInfoLabel.setText(Bundle.CustomizerProtractor_protractor_dir_info());
        String configFile = ProtractorPreferences.getUserConfigurationFile(this.project);
        this.userConfigurationFileTextField.setText(configFile);
        this.userConfigurationFileInfoLabel.setText(Bundle.CustomizerProtractor_user_configuration_file_info());
        this.addListeners();
        this.validateData();
    }

    private boolean isProtractorExecValid(String path) {
        ValidationResult result = new ProtractorPreferencesValidator().validateProtractor(path).getResult();
        if (result.isFaultless()) {
            this.autoDiscovered = true;
            return true;
        }
        return false;
    }

    private void addListeners() {
        DefaultDocumentListener defaultDocumentListener = new DefaultDocumentListener();
        this.protractorDirTextField.getDocument().addDocumentListener(defaultDocumentListener);
        this.userConfigurationFileTextField.getDocument().addDocumentListener(defaultDocumentListener);
    }

    void validateData() {
        assert (EventQueue.isDispatchThread());
        this.protractor = this.protractorDirTextField.getText();
        this.userConfigurationFile = this.userConfigurationFileTextField.getText();
        this.validationResult = new ProtractorPreferencesValidator().validateProtractor(this.protractor).validateUserConfigurationFile(this.project, this.userConfigurationFile).getResult();
        if (this.autoDiscovered) {
            this.validationResult.addWarning(new ValidationResult.Message((Object)"path", Bundle.CustomizerProtractor_confirm_autodiscovered_info()));
        }
        this.changeSupport.fireChange();
    }

    private void initComponents() {
        this.protractorDirLabel = new JLabel();
        this.protractorDirTextField = new JTextField();
        this.protractorDirBrowseButton = new JButton();
        this.protractorDirInfoLabel = new JLabel();
        this.userConfigurationFileLabel = new JLabel();
        this.userConfigurationFileTextField = new JTextField();
        this.userConfigurationFileBrowseButton = new JButton();
        this.userConfigurationFileInfoLabel = new JLabel();
        this.protractorDirLabel.setLabelFor(this.protractorDirTextField);
        Mnemonics.setLocalizedText((JLabel)this.protractorDirLabel, (String)NbBundle.getMessage(CustomizerProtractor.class, (String)"CustomizerProtractor.protractorDirLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.protractorDirBrowseButton, (String)NbBundle.getMessage(CustomizerProtractor.class, (String)"CustomizerProtractor.protractorDirBrowseButton.text"));
        this.protractorDirBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomizerProtractor.this.protractorDirBrowseButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.protractorDirInfoLabel, (String)NbBundle.getMessage(CustomizerProtractor.class, (String)"CustomizerProtractor.protractorDirInfoLabel.text"));
        this.userConfigurationFileLabel.setLabelFor(this.protractorDirTextField);
        Mnemonics.setLocalizedText((JLabel)this.userConfigurationFileLabel, (String)NbBundle.getMessage(CustomizerProtractor.class, (String)"CustomizerProtractor.userConfigurationFileLabel.text"));
        this.userConfigurationFileTextField.setColumns(15);
        Mnemonics.setLocalizedText((AbstractButton)this.userConfigurationFileBrowseButton, (String)NbBundle.getMessage(CustomizerProtractor.class, (String)"CustomizerProtractor.userConfigurationFileBrowseButton.text"));
        this.userConfigurationFileBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomizerProtractor.this.userConfigurationFileBrowseButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.userConfigurationFileInfoLabel, (String)NbBundle.getMessage(CustomizerProtractor.class, (String)"CustomizerProtractor.userConfigurationFileInfoLabel.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.userConfigurationFileLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.userConfigurationFileInfoLabel).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.userConfigurationFileTextField, -1, 181, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.userConfigurationFileBrowseButton)).addGroup(layout.createSequentialGroup().addComponent(this.protractorDirLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.protractorDirInfoLabel).addGap(0, 0, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.protractorDirTextField).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.protractorDirBrowseButton))))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.protractorDirLabel).addComponent(this.protractorDirTextField, -2, -1, -2).addComponent(this.protractorDirBrowseButton)).addGap(6, 6, 6).addComponent(this.protractorDirInfoLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.userConfigurationFileLabel).addComponent(this.userConfigurationFileBrowseButton).addComponent(this.userConfigurationFileTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.userConfigurationFileInfoLabel)));
    }

    private void protractorDirBrowseButtonActionPerformed(ActionEvent evt) {
        assert (EventQueue.isDispatchThread());
        File file = new FileChooserBuilder(CustomizerProtractor.class).setTitle(Bundle.CustomizerProtractor_chooser_protractor()).setFilesOnly(true).setDefaultWorkingDirectory(FileUtil.toFile((FileObject)this.project.getProjectDirectory())).forceUseOfDefaultWorkingDirectory(true).showOpenDialog();
        if (file != null) {
            this.protractorDirTextField.setText(file.getAbsolutePath());
        }
    }

    private void userConfigurationFileBrowseButtonActionPerformed(ActionEvent evt) {
        assert (EventQueue.isDispatchThread());
        File file = new FileChooserBuilder(CustomizerProtractor.class).setTitle(Bundle.CustomizerProtractor_chooser_userConfigurationFile()).setFilesOnly(true).setDefaultWorkingDirectory(FileUtil.toFile((FileObject)this.project.getProjectDirectory())).forceUseOfDefaultWorkingDirectory(true).addFileFilter((FileFilter)new FileNameExtensionFilter("JS File", "js")).setAcceptAllFileFilterUsed(false).showOpenDialog();
        if (file != null) {
            this.userConfigurationFileTextField.setText(file.getAbsolutePath());
        }
    }

    private final class DefaultDocumentListener
    implements DocumentListener {
        private DefaultDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.processChange();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.processChange();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.processChange();
        }

        private void processChange() {
            CustomizerProtractor.this.validateData();
        }
    }
}

