/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.features;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import org.netbeans.api.languages.Highlighting;
import org.netbeans.api.languages.LanguageDefinitionNotFoundException;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.languages.Language;
import org.netbeans.modules.languages.LanguagesManager;
import org.netbeans.spi.editor.highlighting.HighlightsSequence;
import org.netbeans.spi.editor.highlighting.support.AbstractHighlightsContainer;
import org.openide.util.WeakListeners;

class TokenHighlightsLayer
extends AbstractHighlightsContainer {
    private Highlighting highlighting;
    private TokenHierarchy hierarchy;
    private Document document;
    private final PropertyChangeListener listener = new PropertyChangeListener(){
        private boolean parserInited;

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (!this.parserInited) {
                String mimeType = (String)TokenHighlightsLayer.this.document.getProperty("mimeType");
                try {
                    Language language = LanguagesManager.getDefault().getLanguage(mimeType);
                    if (language.getParser() != null) {
                        this.parserInited = true;
                    }
                }
                catch (LanguageDefinitionNotFoundException languageDefinitionNotFoundException) {
                    // empty catch block
                }
            }
            if (this.parserInited) {
                TokenHighlightsLayer.this.fireHighlightsChange((Integer)evt.getOldValue(), (Integer)evt.getNewValue());
            }
        }
    };

    TokenHighlightsLayer(Document document) {
        this.highlighting = Highlighting.getHighlighting(document);
        this.hierarchy = TokenHierarchy.get((Document)document);
        this.document = document;
        this.highlighting.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.listener, (Object)this.highlighting));
    }

    public HighlightsSequence getHighlights(int startOffset, int endOffset) {
        return new Highlights(this.document, this.highlighting, this.hierarchy, startOffset, endOffset);
    }

    private static class Highlights
    implements HighlightsSequence {
        private int endOffset;
        private int startOffset1;
        private int endOffset1;
        private SimpleAttributeSet attributeSet;
        private Highlighting highlighting;
        private TokenHierarchy hierarchy;
        private Document document;

        private Highlights(Document document, Highlighting highlighting, TokenHierarchy hierarchy, int startOffset, int endOffset) {
            this.document = document;
            this.endOffset = endOffset;
            this.highlighting = highlighting;
            this.hierarchy = hierarchy;
            this.endOffset1 = startOffset;
        }

        public boolean moveNext() {
            this.attributeSet = new SimpleAttributeSet();
            this.startOffset1 = this.endOffset1;
            if (this.hierarchy == null) {
                return false;
            }
            TokenSequence ts = this.hierarchy.tokenSequence();
            if (ts == null) {
                return false;
            }
            this.moveNext(ts);
            return this.endOffset1 > this.startOffset1 && this.startOffset1 < this.endOffset;
        }

        private void moveNext(TokenSequence ts) {
            AttributeSet as = null;
            do {
                ts.move(this.startOffset1);
                if (!ts.moveNext()) {
                    return;
                }
                Token t = ts.token();
                if (ts.language() == null) {
                    throw new NullPointerException("ts.language()==null: TS " + ts + " : " + this.document.getProperty("mimeType"));
                }
                as = this.highlighting.get(ts.offset(), ts.offset() + t.length());
                if (as != null) {
                    this.attributeSet.addAttributes(as);
                    this.endOffset1 = ts.offset() + t.length();
                    return;
                }
                TokenSequence ts1 = ts.embedded();
                if (ts1 != null) {
                    this.moveNext(ts1);
                }
                if (this.endOffset1 > this.startOffset1) {
                    return;
                }
                if (ts.token() == null) {
                    return;
                }
                this.endOffset1 = this.startOffset1 = ts.offset() + ts.token().length();
            } while (this.startOffset1 < this.endOffset);
        }

        public int getStartOffset() {
            return this.startOffset1;
        }

        public int getEndOffset() {
            return this.endOffset1;
        }

        public AttributeSet getAttributes() {
            return this.attributeSet;
        }
    }
}

