/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.features;

import java.lang.ref.WeakReference;
import java.util.EmptyStackException;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.WeakHashMap;
import javax.swing.text.Document;
import org.netbeans.api.languages.ASTEvaluator;
import org.netbeans.api.languages.ASTItem;
import org.netbeans.api.languages.ASTNode;
import org.netbeans.api.languages.ASTPath;
import org.netbeans.api.languages.ParserManager;
import org.netbeans.api.languages.SyntaxContext;
import org.netbeans.api.languages.database.DatabaseContext;
import org.netbeans.modules.languages.Feature;
import org.netbeans.modules.languages.features.DatabaseManager;

public class ContextASTEvaluator
extends ASTEvaluator {
    private static Map<Document, WeakReference<ContextASTEvaluator>> cache = new WeakHashMap<Document, WeakReference<ContextASTEvaluator>>();
    private Document document;
    private DatabaseContext rootContext;
    private Stack<DatabaseContext> currentContext;
    private boolean evaluated;

    static void register(Document document) {
        if (ContextASTEvaluator.get(document) != null) {
            return;
        }
        cache.put(document, new WeakReference<ContextASTEvaluator>(new ContextASTEvaluator(document)));
    }

    static void unregister(Document document) {
        ContextASTEvaluator evaluator = ContextASTEvaluator.get(document);
        if (evaluator != null) {
            ParserManager.get(document).removeASTEvaluator(evaluator);
        }
        cache.remove(document);
    }

    static ContextASTEvaluator get(Document document) {
        WeakReference<ContextASTEvaluator> weakReference = cache.get(document);
        if (weakReference == null) {
            return null;
        }
        return (ContextASTEvaluator)weakReference.get();
    }

    static DatabaseContext getRootContext(Document document) {
        ContextASTEvaluator evaluator = ContextASTEvaluator.get(document);
        if (evaluator == null) {
            return null;
        }
        return evaluator.rootContext;
    }

    static DatabaseContext getCurrentContext(Document document, int offset) {
        ContextASTEvaluator evaluator = ContextASTEvaluator.get(document);
        try {
            if (evaluator == null) {
                return null;
            }
            DatabaseContext context = evaluator.currentContext.peek();
            while (offset < context.getOffset() || context.getEndOffset() <= offset) {
                evaluator.currentContext.pop();
                context = evaluator.currentContext.peek();
            }
            return context;
        }
        catch (EmptyStackException ex) {
            return evaluator.rootContext;
        }
    }

    static void setEvaluated(Document document, boolean evaluated) {
        ContextASTEvaluator evaluator = ContextASTEvaluator.get(document);
        if (evaluator == null) {
            return;
        }
        evaluator.evaluated = evaluated;
    }

    ContextASTEvaluator(Document document) {
        this.document = document;
        ParserManager.get(document).addASTEvaluator(this);
    }

    @Override
    public void beforeEvaluation(ParserManager.State state, ASTNode root) {
        this.rootContext = new DatabaseContext(null, null, root.getOffset(), root.getEndOffset());
        this.currentContext = new Stack();
        this.currentContext.push(this.rootContext);
        this.evaluated = false;
    }

    @Override
    public void afterEvaluation(ParserManager.State state, ASTNode root) {
        if (this.evaluated) {
            DatabaseManager.setRoot(root, this.rootContext);
        }
    }

    @Override
    public void evaluate(ParserManager.State state, List<ASTItem> path, Feature feature) {
        SyntaxContext sc = SyntaxContext.create(this.document, ASTPath.create(path));
        if (!feature.getBoolean("condition", sc, true)) {
            return;
        }
        String type = (String)feature.getValue("type");
        ASTItem leaf = path.get(path.size() - 1);
        DatabaseContext context = ContextASTEvaluator.getCurrentContext(this.document, leaf.getOffset());
        DatabaseContext newContext = new DatabaseContext(context, type, leaf.getOffset(), leaf.getEndOffset());
        context.addContext(leaf, newContext);
        this.currentContext.push(newContext);
        this.evaluated = true;
    }

    @Override
    public String getFeatureName() {
        return "SEMANTIC_CONTEXT";
    }
}

