/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jshell.parsing;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jdk.jshell.JShell;
import jdk.jshell.SourceCodeAnalysis;
import org.netbeans.modules.jshell.model.ConsoleSection;
import org.netbeans.modules.jshell.model.Rng;
import org.netbeans.modules.jshell.parsing.ModelAccessor;

public class JShellParser2 {
    private static final String CONTENTS_GROUP_NAME = "contents";
    private final CharSequence contents;
    private final int len;
    private final JShell state;
    private Pattern promptPattern = Pattern.compile("(^->|^>>) {0,2}(?<contents>.*)", 32);
    private Pattern commandPattern = Pattern.compile("(^->|^>>) {0,2}/(?<contents>.*)", 32);
    private Pattern messagePattern = Pattern.compile("^\\| (?<contents>.*)", 32);
    private int pos;
    private int startOffset;
    private int lineStart;
    private String currentLine;
    private String lineContents;
    private int lineContentsOffset;
    private boolean foundNewline = false;
    State s = State.INITIAL;
    private StringBuilder snippetText;
    private int snippetPrefixLen;
    private ConsoleSection section;
    private List<Rng> ranges;
    private List<Rng> snippets;
    private List<ConsoleSection> sectionList = new ArrayList<ConsoleSection>();
    private boolean parsed;

    public JShellParser2(JShell state, CharSequence contents, int initialPos) {
        this.state = state;
        this.contents = contents;
        this.len = contents.length();
        this.startOffset = initialPos;
    }

    private void consumed() {
        this.currentLine = null;
        this.lineContents = null;
    }

    private int addNewline(int a) {
        return a;
    }

    private String readLine() {
        if (this.currentLine != null) {
            return this.currentLine;
        }
        this.lineStart = this.pos;
        this.foundNewline = false;
        block4: while (this.pos < this.len) {
            char c = this.contents.charAt(this.pos++);
            switch (c) {
                case '\r': {
                    this.foundNewline = true;
                    if (this.pos >= this.len || this.contents.charAt(this.pos) != '\n') break block4;
                    ++this.pos;
                    break block4;
                }
                case '\n': {
                    this.foundNewline = true;
                    if (this.pos >= this.len || this.contents.charAt(this.pos) != '\r') break block4;
                    ++this.pos;
                    break block4;
                }
                default: {
                    continue block4;
                }
            }
        }
        this.currentLine = this.pos > this.lineStart ? this.contents.subSequence(this.lineStart, this.pos).toString() : null;
        return this.currentLine;
    }

    private int p(int pos) {
        return this.startOffset + pos;
    }

    private void finishSection() {
        if (this.section == null) {
            return;
        }
        ModelAccessor.INSTANCE.extendSection(this.section, this.section.getStart() + this.lineContentsOffset, this.p(this.lineStart), this.ranges, this.snippets);
        this.sectionList.add(this.section);
    }

    private void createSection(ConsoleSection.Type type) {
        if (this.section != null) {
            if (this.section != null && this.section.getType() == type) {
                return;
            }
            this.finishSection();
        }
        this.section = new ConsoleSection(this.p(this.lineStart), type);
        this.ranges = new ArrayList<Rng>();
        this.snippets = new ArrayList<Rng>();
    }

    private void onMessage() {
        this.createSection(ConsoleSection.Type.MESSAGE);
        this.extendWithPart(this.lineContentsOffset, this.len());
        this.consumed();
        this.s = State.MESSAGE_NEXT;
    }

    private void onCommand() {
        this.createSection(ConsoleSection.Type.COMMAND);
        this.extendWithPart(this.lineContentsOffset, this.len());
        this.consumed();
        this.s = State.COMMAND;
    }

    private void onCommandLine() {
    }

    private void onMessageNext() {
        if (this.checkCommand() || this.checkInputJava()) {
            return;
        }
        if (this.checkMessage()) {
            this.onMessage();
        } else {
            this.s = State.OUTPUT;
        }
    }

    private void onCommandOutput() {
        if (this.checkCommand() || this.checkInputJava()) {
            return;
        }
        this.createSection(ConsoleSection.Type.OUTPUT);
        this.extendSection(this.section, this.p(this.endLine()));
        this.consumed();
    }

    private void addJavaSnippet(int start, int len) {
        int a = this.p(this.lineStart + start);
        if (this.section != null && this.section.isIncomplete()) {
            int i = this.snippets.size() - 1;
            Rng prev = this.snippets.get(i);
            Rng r = new Rng(prev.start, prev.start + len);
            this.snippets.set(i, r);
        } else {
            int b = a + len;
            this.snippets.add(new Rng(a, a + len));
        }
    }

    private void extendWithPart(int ls, int le) {
        if (!this.ranges.isEmpty()) {
            int l = this.ranges.size() - 1;
            Rng r = this.ranges.get(l);
            int a = this.p(this.lineStart + ls);
            if (r.end == a) {
                this.ranges.set(l, new Rng(r.start, this.p(this.lineStart + le)));
                return;
            }
        }
        this.ranges.add(new Rng(this.p(this.lineStart + ls), this.p(this.lineStart + le)));
    }

    private void extendSection(ConsoleSection s, int end) {
        ModelAccessor.INSTANCE.extendSection(this.section, this.section.getStart(), end, null, null);
    }

    private void onOutput() {
        if (this.checkCommand() || this.checkInputJava() || this.checkMessage()) {
            return;
        }
        this.createSection(ConsoleSection.Type.OUTPUT);
        this.extendSection(this.section, this.p(this.endLine()));
        this.consumed();
        this.s = State.OUTPUT_NEXT;
    }

    private void onOutputNext() {
        if (this.checkInputJava()) {
            return;
        }
        this.extendSection(this.section, this.p(this.endLine()));
        this.consumed();
    }

    private int len() {
        return this.currentLine.length();
    }

    private int endLine() {
        return this.lineStart + this.currentLine.length();
    }

    private void addSnippetText(int pos, String text) {
        if (this.snippetText == null || this.section != null && !this.section.isIncomplete()) {
            this.snippetPrefixLen = 0;
            this.snippetText = new StringBuilder(text);
        } else {
            this.snippetPrefixLen = this.snippetText.length();
            this.snippetText.append(text);
        }
    }

    private boolean checkInputJava() {
        return this.doCheckPattern(State.INPUT, this.promptPattern);
    }

    private boolean checkMessage() {
        return this.doCheckPattern(State.MESSAGE, this.messagePattern);
    }

    private boolean doCheckPattern(State nextState, Pattern pat) {
        Matcher m = pat.matcher(this.currentLine);
        boolean prompt = m.find();
        if (prompt) {
            this.s = nextState;
            this.lineContentsOffset = m.start(CONTENTS_GROUP_NAME);
            this.lineContents = m.group(CONTENTS_GROUP_NAME);
            return true;
        }
        return false;
    }

    private boolean checkCommand() {
        return this.doCheckPattern(State.COMMAND, this.commandPattern);
    }

    private void onInitial() {
        if (this.checkCommand() || this.checkInputJava() || this.checkMessage()) {
            return;
        }
        this.createSection(ConsoleSection.Type.OUTPUT);
        this.extendSection(this.section, this.p(this.endLine()));
        this.consumed();
        this.s = State.COMMAND_OUTPUT;
    }

    private void onInput() {
        this.snippetText = null;
        this.createSection(ConsoleSection.Type.JAVA);
        this.addSnippetText(this.lineContentsOffset, this.lineContents);
        this.processJavaInput();
        this.consumed();
    }

    private void onContinueInput() {
        this.createSection(ConsoleSection.Type.JAVA);
        this.lineContents = this.currentLine;
        this.lineContentsOffset = 0;
        this.addSnippetText(this.lineContentsOffset, this.lineContents);
        this.processJavaInput();
        this.consumed();
    }

    private void onMayInput() {
        if (this.checkCommand() || this.checkInputJava() || this.checkMessage()) {
            return;
        }
        this.onContinueInput();
    }

    private void onMustInput() {
        if (this.checkInputJava()) {
            this.s = State.INPUT;
            return;
        }
        this.onContinueInput();
    }

    private void processJavaInput() {
        String input = this.snippetText.toString();
        int lpos = this.lineContentsOffset;
        if (this.state == null) {
            boolean empty = input.trim().isEmpty();
            int e = input.length();
            e = this.addNewline(input.length());
            this.extendWithPart(lpos, lpos += e);
            ModelAccessor.INSTANCE.setSectionComplete(this.section, true);
            this.s = State.MAY_INPUT;
            return;
        }
        this.extendWithPart(lpos, lpos + this.lineContents.length());
        int snipOffset = lpos;
        block5: while (true) {
            SourceCodeAnalysis.CompletionInfo info;
            String rem;
            int endPos = (rem = (info = this.state.sourceCodeAnalysis().analyzeCompletion(input)).remaining()) == null ? input.length() - 1 : input.length() - rem.length();
            int e = endPos;
            boolean empty = info.remaining().trim().isEmpty();
            switch (info.completeness()) {
                case DEFINITELY_INCOMPLETE: 
                case CONSIDERED_INCOMPLETE: {
                    this.s = State.MUST_INPUT;
                    this.addJavaSnippet(snipOffset, input.length());
                    ModelAccessor.INSTANCE.setSectionComplete(this.section, false);
                    break block5;
                }
                case EMPTY: {
                    this.s = State.MAY_INPUT;
                    break block5;
                }
                case COMPLETE_WITH_SEMI: 
                case UNKNOWN: 
                case COMPLETE: {
                    if (empty) {
                        e = this.addNewline(input.length());
                    }
                    input = info.remaining();
                    this.addJavaSnippet(snipOffset, endPos);
                    snipOffset += (e -= this.snippetPrefixLen);
                    ModelAccessor.INSTANCE.setSectionComplete(this.section, true);
                    this.s = State.MAY_INPUT;
                    if (!empty) continue block5;
                    break block5;
                }
                default: {
                    throw new AssertionError((Object)info.completeness().name());
                }
            }
            break;
        }
    }

    public List<ConsoleSection> sections() {
        if (!this.parsed) {
            this.execute();
        }
        return this.sectionList;
    }

    public void setInitialState(State s) {
        this.s = s;
    }

    public void setAfterState(ConsoleSection s) {
        State init;
        switch (s.getType()) {
            case MESSAGE: {
                init = State.MESSAGE_NEXT;
                break;
            }
            case OUTPUT: {
                init = State.OUTPUT_NEXT;
                break;
            }
            default: {
                throw new AssertionError((Object)s.getType().name());
            }
        }
        this.setInitialState(init);
        this.createSection(s.getType());
    }

    private void appendNewline() {
        if (!this.ranges.isEmpty()) {
            this.extendWithPart(0, this.len());
        }
        this.consumed();
    }

    public void execute() {
        String l;
        block13: while ((l = this.readLine()) != null) {
            if (this.currentLine.trim().isEmpty() && this.section != null) {
                this.appendNewline();
                continue;
            }
            switch (this.s.ordinal()) {
                case 0: {
                    this.onInitial();
                    continue block13;
                }
                case 1: {
                    this.onOutput();
                    continue block13;
                }
                case 2: {
                    this.onOutputNext();
                    continue block13;
                }
                case 3: {
                    this.onInput();
                    continue block13;
                }
                case 4: {
                    this.onMayInput();
                    continue block13;
                }
                case 5: {
                    this.onMustInput();
                    continue block13;
                }
                case 6: {
                    this.onCommand();
                    continue block13;
                }
                case 7: {
                    this.onCommandLine();
                    continue block13;
                }
                case 8: {
                    this.onCommandOutput();
                    continue block13;
                }
                case 9: {
                    this.onMessage();
                    continue block13;
                }
                case 10: {
                    this.onMessageNext();
                    continue block13;
                }
            }
            throw new AssertionError((Object)this.s.name());
        }
        this.finishSection();
        this.parsed = true;
    }

    static enum State {
        INITIAL,
        OUTPUT,
        OUTPUT_NEXT,
        INPUT,
        MAY_INPUT,
        MUST_INPUT,
        COMMAND,
        COMMAND_LINE,
        COMMAND_OUTPUT,
        MESSAGE,
        MESSAGE_NEXT;

    }
}

