/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.sql.ui;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import org.netbeans.api.db.explorer.ConnectionManager;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.api.db.explorer.support.DatabaseExplorerUIs;
import org.netbeans.modules.php.editor.codegen.DatabaseURL;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public final class SelectConnectionPanel
extends JPanel {
    private final boolean mySQLOnly;
    private final boolean passwordRequired;
    private DialogDescriptor descriptor;
    private DatabaseConnection dbconn;
    private JComboBox dbconnComboBox;
    private JLabel dbconnLabel;

    public static DatabaseConnection selectConnection(DatabaseConnection selectedDBConn, boolean mySQLOnly, boolean passwordRequired) {
        SelectConnectionPanel panel = new SelectConnectionPanel(selectedDBConn, mySQLOnly, passwordRequired);
        DialogDescriptor desc = new DialogDescriptor((Object)panel, NbBundle.getMessage(SelectConnectionPanel.class, (String)"MSG_SelectConnection"));
        desc.createNotificationLineSupport();
        panel.initialize(desc);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(desc);
        dialog.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SelectConnectionPanel.class, (String)"ACSD_SelectConnection"));
        dialog.setVisible(true);
        dialog.dispose();
        if (desc.getValue() == DialogDescriptor.OK_OPTION) {
            return panel.dbconn;
        }
        return selectedDBConn;
    }

    private SelectConnectionPanel(DatabaseConnection dbconn, boolean mySQLOnly, boolean passwordRequired) {
        this.dbconn = dbconn;
        this.mySQLOnly = mySQLOnly;
        this.passwordRequired = passwordRequired;
        this.initComponents();
    }

    private void initialize(DialogDescriptor descriptor) {
        this.descriptor = descriptor;
        DatabaseExplorerUIs.connect((JComboBox)this.dbconnComboBox, (ConnectionManager)ConnectionManager.getDefault());
        this.dbconnComboBox.setSelectedItem(this.dbconn);
        if (this.dbconn == null) {
            descriptor.getNotificationLineSupport().setWarningMessage(NbBundle.getMessage(SelectConnectionPanel.class, (String)"ERR_SelectConnection"));
        }
    }

    private void databaseConnectionChanged() {
        this.dbconn = null;
        Object selected = this.dbconnComboBox.getSelectedItem();
        if (!(selected instanceof DatabaseConnection)) {
            return;
        }
        this.dbconn = (DatabaseConnection)selected;
        DatabaseURL url = DatabaseURL.detect(this.dbconn.getDatabaseURL());
        String errorMessage = null;
        if (this.mySQLOnly && (url == null || url.getServer() != DatabaseURL.Server.MYSQL)) {
            errorMessage = NbBundle.getMessage(SelectConnectionPanel.class, (String)"ERR_UnknownServer");
            this.dbconn = null;
        }
        if (this.dbconn != null && this.passwordRequired && this.dbconn.getPassword() == null) {
            errorMessage = NbBundle.getMessage(SelectConnectionPanel.class, (String)"ERR_NoPassword");
        }
        this.setErrorMessage(errorMessage);
    }

    private void setErrorMessage(String message) {
        if (message == null) {
            this.descriptor.getNotificationLineSupport().clearMessages();
        } else {
            this.descriptor.getNotificationLineSupport().setErrorMessage(message);
        }
    }

    private void initComponents() {
        this.dbconnLabel = new JLabel();
        this.dbconnComboBox = new JComboBox();
        Mnemonics.setLocalizedText((JLabel)this.dbconnLabel, (String)NbBundle.getMessage(SelectConnectionPanel.class, (String)"SelectConnectionPanel.dbconnLabel.text"));
        this.dbconnComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SelectConnectionPanel.this.dbconnComboBoxActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.dbconnLabel).addComponent(this.dbconnComboBox, 0, 518, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.dbconnLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.dbconnComboBox, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.dbconnComboBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SelectConnectionPanel.class, (String)"ChooseConnectionPanel.dbconnComboBox.AccessibleContext.accessibleName"));
        this.dbconnComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SelectConnectionPanel.class, (String)"ChooseConnectionPanel.dbconnComboBox.AccessibleContext.accessibleDescription"));
    }

    private void dbconnComboBoxActionPerformed(ActionEvent evt) {
        this.databaseConnectionChanged();
    }
}

