/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.browser.api;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.web.browser.Helper;
import org.netbeans.modules.web.browser.api.WebBrowser;
import org.netbeans.modules.web.browser.api.WebBrowserPane;
import org.netbeans.modules.web.browser.api.WebBrowsers;
import org.netbeans.modules.web.common.api.DependentFileQuery;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;

public final class BrowserSupport {
    private WebBrowserPane pane;
    private URL currentURL;
    private WebBrowser browser;
    private PropertyChangeListener listener;
    private FileObject file;
    private static BrowserSupport INSTANCE = BrowserSupport.create();
    private static BrowserSupport INSTANCE_EMBEDDED;

    public static synchronized BrowserSupport getGlobalSharedOne() {
        throw new UnsupportedOperationException("not implemented yet");
    }

    public static BrowserSupport getDefault() {
        return INSTANCE;
    }

    public static BrowserSupport create() {
        return new BrowserSupport();
    }

    public static BrowserSupport create(WebBrowser browser) {
        return new BrowserSupport(browser);
    }

    public static BrowserSupport getDefaultEmbedded() {
        WebBrowser browser;
        if (INSTANCE_EMBEDDED == null && (browser = WebBrowsers.getInstance().getEmbedded()) != null) {
            INSTANCE_EMBEDDED = BrowserSupport.create(browser);
        }
        return INSTANCE_EMBEDDED;
    }

    private BrowserSupport() {
        this(null);
    }

    private BrowserSupport(WebBrowser browser) {
        this.browser = browser;
    }

    private synchronized WebBrowserPane getWebBrowserPane() {
        if (this.pane == null) {
            if (this.browser == null) {
                this.browser = WebBrowsers.getInstance().getPreferred();
                this.listener = new PropertyChangeListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        BrowserSupport browserSupport = BrowserSupport.this;
                        synchronized (browserSupport) {
                            if ("browser".equals(evt.getPropertyName()) && !WebBrowsers.getInstance().getPreferred().getId().equals(BrowserSupport.this.browser.getId())) {
                                BrowserSupport.this.browser = WebBrowsers.getInstance().getPreferred();
                                if (BrowserSupport.this.pane != null) {
                                    BrowserSupport.this.pane = null;
                                }
                            }
                        }
                    }
                };
                WebBrowsers.getInstance().addPropertyChangeListener(this.listener);
            }
            this.pane = this.browser.createNewBrowserPane(true);
        }
        return this.pane;
    }

    public void load(URL url, FileObject context) {
        WebBrowserPane wbp = this.getWebBrowserPane();
        this.file = context;
        this.currentURL = url;
        Project project = FileOwnerQuery.getOwner((FileObject)context);
        Lookup lkp = Lookup.EMPTY;
        if (null != project) {
            DataObject dob = null;
            try {
                dob = DataObject.find((FileObject)this.file);
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                // empty catch block
            }
            lkp = null == dob ? Lookups.fixed((Object[])new Object[]{project, context, this.browser.getBrowserFamily()}) : Lookups.fixed((Object[])new Object[]{project, context, dob, this.browser.getBrowserFamily()});
        }
        wbp.setProjectContext(lkp);
        wbp.showURL(url);
    }

    public boolean reload(URL url) {
        if (!this.canReload(url)) {
            return false;
        }
        this.getWebBrowserPane().reload();
        return true;
    }

    public boolean reload() {
        if (this.currentURL == null) {
            return false;
        }
        this.getWebBrowserPane().reload();
        return true;
    }

    public boolean canReload() {
        return this.getWebBrowserPane().canReloadPage();
    }

    public boolean canReload(URL url) {
        return this.currentURL != null && this.currentURL.equals(url) && !url.toExternalForm().equals(Helper.urlBeingRefreshedFromBrowser.get()) && this.getWebBrowserPane().canReloadPage();
    }

    public boolean ignoreChange(FileObject fo) {
        return this.getWebBrowserPane().ignoreChange(fo);
    }

    public static boolean ignoreChangeDefaultImpl(FileObject fo) {
        return fo.hasExt("css");
    }

    public URL getBrowserURL(FileObject fo, boolean checkDependentFiles) {
        Project project = FileOwnerQuery.getOwner((FileObject)fo);
        if (this.file == null || this.currentURL == null) {
            return null;
        }
        if (checkDependentFiles && (this.file.equals(project.getProjectDirectory()) || DependentFileQuery.isDependent((FileObject)this.file, (FileObject)fo))) {
            return this.currentURL;
        }
        if (fo.equals(this.file)) {
            return this.currentURL;
        }
        return null;
    }

    public void close(boolean closeTab) {
        this.getWebBrowserPane().close(closeTab);
    }

    public synchronized boolean isWebBrowserPaneOpen() {
        WebBrowserPane p = this.pane;
        return p != null && p.isOpen();
    }
}

