/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.containerengine.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.containerengine.model.AddonConfiguration;
import com.oracle.bmc.containerengine.model.AddonError;
import com.oracle.bmc.containerengine.model.AddonLifecycleState;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class Addon
extends ExplicitlySetBmcModel {
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="version")
    private final String version;
    @JsonProperty(value="currentInstalledVersion")
    private final String currentInstalledVersion;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="lifecycleState")
    private final AddonLifecycleState lifecycleState;
    @JsonProperty(value="configurations")
    private final List<AddonConfiguration> configurations;
    @JsonProperty(value="addonError")
    private final AddonError addonError;

    @Deprecated
    @ConstructorProperties(value={"name", "version", "currentInstalledVersion", "timeCreated", "lifecycleState", "configurations", "addonError"})
    public Addon(String name, String version, String currentInstalledVersion, Date timeCreated, AddonLifecycleState lifecycleState, List<AddonConfiguration> configurations, AddonError addonError) {
        this.name = name;
        this.version = version;
        this.currentInstalledVersion = currentInstalledVersion;
        this.timeCreated = timeCreated;
        this.lifecycleState = lifecycleState;
        this.configurations = configurations;
        this.addonError = addonError;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public String getCurrentInstalledVersion() {
        return this.currentInstalledVersion;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public AddonLifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public List<AddonConfiguration> getConfigurations() {
        return this.configurations;
    }

    public AddonError getAddonError() {
        return this.addonError;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("Addon(");
        sb.append("super=").append(super.toString());
        sb.append("name=").append(String.valueOf(this.name));
        sb.append(", version=").append(String.valueOf(this.version));
        sb.append(", currentInstalledVersion=").append(String.valueOf(this.currentInstalledVersion));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", configurations=").append(String.valueOf(this.configurations));
        sb.append(", addonError=").append(String.valueOf((Object)this.addonError));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Addon)) {
            return false;
        }
        Addon other = (Addon)((Object)o);
        return Objects.equals(this.name, other.name) && Objects.equals(this.version, other.version) && Objects.equals(this.currentInstalledVersion, other.currentInstalledVersion) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.configurations, other.configurations) && Objects.equals((Object)this.addonError, (Object)other.addonError) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.version == null ? 43 : this.version.hashCode());
        result = result * 59 + (this.currentInstalledVersion == null ? 43 : this.currentInstalledVersion.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.configurations == null ? 43 : this.configurations.hashCode());
        result = result * 59 + (this.addonError == null ? 43 : this.addonError.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="version")
        private String version;
        @JsonProperty(value="currentInstalledVersion")
        private String currentInstalledVersion;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="lifecycleState")
        private AddonLifecycleState lifecycleState;
        @JsonProperty(value="configurations")
        private List<AddonConfiguration> configurations;
        @JsonProperty(value="addonError")
        private AddonError addonError;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            this.__explicitlySet__.add("version");
            return this;
        }

        public Builder currentInstalledVersion(String currentInstalledVersion) {
            this.currentInstalledVersion = currentInstalledVersion;
            this.__explicitlySet__.add("currentInstalledVersion");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder lifecycleState(AddonLifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder configurations(List<AddonConfiguration> configurations) {
            this.configurations = configurations;
            this.__explicitlySet__.add("configurations");
            return this;
        }

        public Builder addonError(AddonError addonError) {
            this.addonError = addonError;
            this.__explicitlySet__.add("addonError");
            return this;
        }

        public Addon build() {
            Addon model = new Addon(this.name, this.version, this.currentInstalledVersion, this.timeCreated, this.lifecycleState, this.configurations, this.addonError);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(Addon model) {
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("version")) {
                this.version(model.getVersion());
            }
            if (model.wasPropertyExplicitlySet("currentInstalledVersion")) {
                this.currentInstalledVersion(model.getCurrentInstalledVersion());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("configurations")) {
                this.configurations(model.getConfigurations());
            }
            if (model.wasPropertyExplicitlySet("addonError")) {
                this.addonError(model.getAddonError());
            }
            return this;
        }
    }
}

