/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websocket.wizard;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Modifier;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.queries.UnitTestForSourceQuery;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.j2ee.core.api.support.java.GenerationUtils;
import org.netbeans.modules.websocket.wizard.WebSocketPanel;
import org.netbeans.spi.java.project.support.ui.templates.JavaTemplates;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.util.NbBundle;

public class WebSocketEndpointIterator
implements WizardDescriptor.ProgressInstantiatingIterator<WizardDescriptor> {
    private WizardDescriptor myWizard;
    private WizardDescriptor.Panel[] myPanels;
    private WizardDescriptor.Panel myPanel;
    private int myIndex;

    public Set<?> instantiate() throws IOException {
        throw new UnsupportedOperationException();
    }

    public void initialize(WizardDescriptor wizard) {
        WizardDescriptor.Panel panel;
        this.myWizard = wizard;
        Project project = Templates.getProject((WizardDescriptor)wizard);
        SourceGroup[] sourceGroups = this.getJavaSourceGroups(project);
        this.myPanel = new WebSocketPanel(wizard);
        if (sourceGroups.length == 0) {
            SourceGroup[] genericSourceGroups = ProjectUtils.getSources((Project)project).getSourceGroups("generic");
            panel = Templates.buildSimpleTargetChooser((Project)project, (SourceGroup[])genericSourceGroups).bottomPanel(this.myPanel).create();
        } else {
            panel = JavaTemplates.createPackageChooser((Project)project, (SourceGroup[])sourceGroups, (WizardDescriptor.Panel)this.myPanel, (boolean)true);
        }
        this.myPanels = new WizardDescriptor.Panel[]{panel};
        this.setSteps();
    }

    public void uninitialize(WizardDescriptor wizard) {
        this.myPanels = null;
        this.myPanel = null;
        this.myWizard = null;
    }

    public WizardDescriptor.Panel<WizardDescriptor> current() {
        return this.myPanels[this.myIndex];
    }

    public boolean hasNext() {
        return this.myIndex < this.myPanels.length - 1;
    }

    public boolean hasPrevious() {
        return this.myIndex > 0;
    }

    public String name() {
        return null;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.myIndex;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.myIndex;
    }

    public void removeChangeListener(ChangeListener arg0) {
    }

    public void addChangeListener(ChangeListener arg0) {
    }

    public Set<?> instantiate(ProgressHandle handle) throws IOException {
        handle.start();
        handle.progress(NbBundle.getMessage(WebSocketEndpointIterator.class, (String)"TXT_GenerateEndpoint"));
        FileObject targetFolder = Templates.getTargetFolder((WizardDescriptor)this.getWizard());
        String name = Templates.getTargetName((WizardDescriptor)this.getWizard());
        FileObject endpoint = GenerationUtils.createClass((FileObject)targetFolder, (String)name, null);
        this.generateEndpoint(endpoint);
        handle.finish();
        return Collections.singleton(endpoint);
    }

    private void generateEndpoint(FileObject endpoint) throws IOException {
        JavaSource javaSource = JavaSource.forFileObject((FileObject)endpoint);
        if (javaSource == null) {
            return;
        }
        final String uri = this.getWizard().getProperty("websocket.uri").toString();
        javaSource.runModificationTask((Task)new Task<WorkingCopy>(){
            final /* synthetic */ WebSocketEndpointIterator this$0;
            {
                this.this$0 = this$0;
            }

            public void run(WorkingCopy copy) throws Exception {
                ClassTree tree;
                copy.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                CompilationUnitTree compilationUnit = copy.getCompilationUnit();
                List<? extends Tree> decls = compilationUnit.getTypeDecls();
                if (decls.isEmpty()) {
                    return;
                }
                ClassTree newTree = tree = (ClassTree)decls.get(0);
                TreeMaker treeMaker = copy.getTreeMaker();
                GenerationUtils genUtils = GenerationUtils.newInstance((WorkingCopy)copy);
                AnnotationTree annotation = genUtils.createAnnotation("javax.websocket.server.ServerEndpoint", Collections.singletonList(treeMaker.Literal((Object)uri)));
                newTree = genUtils.addAnnotation(newTree, annotation);
                ModifiersTree modifiers = treeMaker.Modifiers(EnumSet.of(Modifier.PUBLIC));
                ModifiersTree noModifier = treeMaker.Modifiers(Collections.emptySet());
                List<VariableTree> params = Collections.singletonList(treeMaker.Variable(noModifier, (CharSequence)"message", treeMaker.Type(String.class.getName()), null));
                Tree returnTree = treeMaker.Type(String.class.getName());
                MethodTree method = treeMaker.Method(treeMaker.addModifiersAnnotation(modifiers, genUtils.createAnnotation("javax.websocket.OnMessage")), (CharSequence)"onMessage", returnTree, Collections.emptyList(), params, Collections.emptyList(), "{ return null; }", null);
                newTree = treeMaker.addClassMember(newTree, (Tree)method);
                copy.rewrite((Tree)tree, (Tree)newTree);
            }
        }).commit();
    }

    private void setSteps() {
        Object contentData = this.myWizard.getProperty("WizardPanel_contentData");
        if (contentData instanceof String[]) {
            String[] steps = (String[])contentData;
            steps[steps.length - 1] = NbBundle.getMessage(WebSocketEndpointIterator.class, (String)"TXT_CreateEndpoint");
            for (int i = 0; i < this.myPanels.length; ++i) {
                WizardDescriptor.Panel panel = this.myPanels[i];
                JComponent component = (JComponent)panel.getComponent();
                component.putClientProperty("WizardPanel_contentData", steps);
                component.putClientProperty("WizardPanel_contentSelectedIndex", i);
            }
        }
    }

    private SourceGroup[] getJavaSourceGroups(Project project) {
        SourceGroup[] sourceGroups = ProjectUtils.getSources((Project)project).getSourceGroups("java");
        Set<FileObject> testRoots = this.getTestRoots(project);
        ArrayList<SourceGroup> list = new ArrayList<SourceGroup>(sourceGroups.length);
        for (SourceGroup sourceGroup : sourceGroups) {
            if (testRoots.contains(sourceGroup.getRootFolder())) continue;
            list.add(sourceGroup);
        }
        return list.toArray(new SourceGroup[0]);
    }

    private Set<FileObject> getTestRoots(Project project) {
        SourceGroup[] sourceGroups = ProjectUtils.getSources((Project)project).getSourceGroups("java");
        HashSet<FileObject> result = new HashSet<FileObject>();
        for (SourceGroup sourceGroup : sourceGroups) {
            result.addAll(this.getTestRoots(sourceGroup));
        }
        return result;
    }

    private Set<FileObject> getTestRoots(SourceGroup group) {
        URL[] rootURLs = UnitTestForSourceQuery.findUnitTests((FileObject)group.getRootFolder());
        if (rootURLs.length == 0) {
            return Collections.emptySet();
        }
        List<FileObject> sourceRoots = WebSocketEndpointIterator.getFileObjects(rootURLs);
        if (sourceRoots.isEmpty()) {
            return Collections.emptySet();
        }
        return new HashSet<FileObject>(sourceRoots);
    }

    private static List<FileObject> getFileObjects(URL[] urls) {
        ArrayList<FileObject> result = new ArrayList<FileObject>(urls.length);
        for (URL url : urls) {
            FileObject sourceRoot = URLMapper.findFileObject((URL)url);
            if (sourceRoot != null) {
                result.add(sourceRoot);
                continue;
            }
            Logger.getLogger(WebSocketEndpointIterator.class.getName()).log(Level.INFO, "No FileObject found for the following URL: " + url);
        }
        return result;
    }

    private WizardDescriptor getWizard() {
        return this.myWizard;
    }
}

