/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.java.customizer;

import java.io.File;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.modules.gradle.api.GradleBaseProject;
import org.netbeans.modules.gradle.java.api.GradleJavaProject;
import org.netbeans.modules.gradle.java.api.GradleJavaSourceSet;
import org.netbeans.modules.gradle.java.customizer.Bundle;
import org.netbeans.modules.gradle.java.customizer.SourceSetPanel;
import org.netbeans.modules.gradle.spi.Utils;
import org.netbeans.modules.gradle.spi.customizer.support.FilterPanelProvider;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.openide.util.Lookup;

public class SourcesPanel
extends JPanel {
    SourceSetPanel.Details activeDetail = SourceSetPanel.Details.SOURCES;
    private JTabbedPane tbSourceSets;

    public SourcesPanel(Project project) {
        this.initComponents();
        GradleJavaProject gjp = GradleJavaProject.get(project);
        ChangeListener chl = evt -> {
            JTabbedPane details = (JTabbedPane)evt.getSource();
            int selected = details.getSelectedIndex() != -1 ? details.getSelectedIndex() : 0;
            this.activeDetail = SourceSetPanel.Details.values()[selected];
        };
        if (gjp != null) {
            for (GradleJavaSourceSet sourceSet : gjp.getSourceSets().values()) {
                File rootDir = GradleBaseProject.get((Project)project).getRootDir();
                SourceSetPanel panel = new SourceSetPanel(sourceSet, rootDir);
                this.tbSourceSets.addTab(Utils.camelCaseToTitle((String)sourceSet.getName()), null, panel, sourceSet.getName());
                panel.addDetailsChangeListener(chl);
            }
            this.tbSourceSets.addChangeListener(evt -> {
                SourceSetPanel selected = (SourceSetPanel)this.tbSourceSets.getSelectedComponent();
                if (selected != null) {
                    selected.setActiveDetails(this.activeDetail);
                }
            });
        }
    }

    public static ProjectCustomizer.CompositeCategoryProvider buildCompileCustomizerProvider() {
        ProjectCustomizer.CompositeCategoryProvider provider = new ProjectCustomizer.CompositeCategoryProvider(){

            public ProjectCustomizer.Category createCategory(Lookup context) {
                return ProjectCustomizer.Category.create((String)"sources", (String)Bundle.category_Sources(), null, (ProjectCustomizer.Category[])new ProjectCustomizer.Category[0]);
            }

            public JComponent createComponent(ProjectCustomizer.Category category, Lookup context) {
                Project project = (Project)context.lookup(Project.class);
                SourcesPanel customizer = new SourcesPanel(project);
                return customizer;
            }
        };
        return new FilterPanelProvider(provider, "java-base");
    }

    private void initComponents() {
        this.tbSourceSets = new JTabbedPane();
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.tbSourceSets, GroupLayout.Alignment.TRAILING, -1, 400, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.tbSourceSets, GroupLayout.Alignment.TRAILING, -1, 300, Short.MAX_VALUE));
    }
}

