/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.navigation;

import java.awt.EventQueue;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.netbeans.modules.web.jsf.api.facesmodel.NavigationCase;
import org.netbeans.modules.web.jsf.api.facesmodel.NavigationRule;
import org.netbeans.modules.web.jsf.navigation.FacesModelUtility;
import org.netbeans.modules.web.jsf.navigation.NavigationCaseEdge;
import org.netbeans.modules.web.jsf.navigation.Page;
import org.netbeans.modules.web.jsf.navigation.PageFlowController;
import org.netbeans.modules.web.jsf.navigation.PageFlowToolbarUtilities;
import org.netbeans.modules.web.jsf.navigation.PageFlowView;
import org.netbeans.modules.xml.xam.Model;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;

public class FacesModelPropertyChangeListener
implements PropertyChangeListener {
    private final PageFlowController pfc;
    private static final Logger LOGGER = Logger.getLogger("org.netbeans.modules.web.jsf.navigation");
    private boolean isWellFormed = true;
    private static final String NEWLINE = "\n";

    public FacesModelPropertyChangeListener(PageFlowController pfc) {
        this.pfc = pfc;
    }

    @Override
    public void propertyChange(PropertyChangeEvent ev) {
        LogRecord record = new LogRecord(Level.FINE, "Faces Config File Changed:" + this.pfc.getConfigDataObject().getName());
        record.setSourceClassName("FacesModelPropertyChangeListener");
        record.setSourceMethodName("propertyChangeEvent.");
        record.setParameters(new Object[]{ev.getPropertyName(), ev.getOldValue(), ev.getNewValue()});
        LOGGER.log(record);
        if (this.pfc.getView().isShowing()) {
            this.runEventNow(ev);
        } else {
            this.setGraphDirty(ev);
        }
    }

    private final void setGraphDirty(PropertyChangeEvent ev) {
        if (!ev.getPropertyName().equals("managed-bean-class") && !ev.getPropertyName().equals("managed-bean-name") && ev.getNewValue() != Model.State.NOT_SYNCED) {
            if (ev.getOldValue() == Model.State.NOT_WELL_FORMED) {
                this.isWellFormed = true;
            } else if (ev.getNewValue() == Model.State.NOT_WELL_FORMED) {
                this.isWellFormed = false;
            }
            this.pfc.setGraphDirtyWellFormed(this.isWellFormed);
        }
    }

    protected final void runEventNow(final PropertyChangeEvent ev) {
        if (ev.getOldValue() == Model.State.NOT_WELL_FORMED) {
            EventQueue.invokeLater(new Runnable(){
                final /* synthetic */ FacesModelPropertyChangeListener this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    PageFlowView view = this.this$0.pfc.getView();
                    if (view == null) {
                        return;
                    }
                    view.removeUserMalFormedFacesConfig();
                    this.this$0.setupGraph(ev);
                }
            });
        } else if (!ev.getPropertyName().equals("managed-bean-class") && !ev.getPropertyName().equals("managed-bean-name") && ev.getNewValue() != Model.State.NOT_SYNCED) {
            if (ev.getPropertyName().equals("navigation-case")) {
                final NavigationCase myNewCase = (NavigationCase)ev.getNewValue();
                final NavigationCase myOldCase = (NavigationCase)ev.getOldValue();
                EventQueue.invokeLater(new Runnable(){
                    final /* synthetic */ FacesModelPropertyChangeListener this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public void run() {
                        if (this.this$0.pfc.getView() == null) {
                            return;
                        }
                        this.this$0.navigationCaseEventHandler(myNewCase, myOldCase);
                    }
                });
            } else if (ev.getPropertyName().equals("navigation-rule")) {
                final NavigationRule myNewRule = (NavigationRule)ev.getNewValue();
                final NavigationRule myOldRule = (NavigationRule)ev.getOldValue();
                EventQueue.invokeLater(new Runnable(){
                    final /* synthetic */ FacesModelPropertyChangeListener this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public void run() {
                        if (this.this$0.pfc.getView() == null) {
                            return;
                        }
                        this.this$0.navigationRuleEventHandler(myNewRule, myOldRule);
                    }
                });
            } else if (ev.getNewValue() == Model.State.NOT_WELL_FORMED) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        PageFlowView view = FacesModelPropertyChangeListener.this.pfc.getView();
                        if (view == null) {
                            return;
                        }
                        view.clearGraph();
                        view.warnUserMalFormedFacesConfig();
                    }
                });
            } else if (ev.getPropertyName().equals("textContent")) {
                this.setupGraphInAWTThread(ev);
            } else if (ev.getPropertyName().equals("from-view-id") || ev.getPropertyName().equals("to-view-id")) {
                final String oldName = FacesModelUtility.getViewIdFiltiered((String)ev.getOldValue());
                final String newName = FacesModelUtility.getViewIdFiltiered((String)ev.getNewValue());
                final Object source = ev.getSource();
                EventQueue.invokeLater(new Runnable(){
                    final /* synthetic */ FacesModelPropertyChangeListener this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public void run() {
                        if (this.this$0.pfc.getView() == null) {
                            return;
                        }
                        this.this$0.replaceFromViewIdToViewIdEventHandler(ev, source, oldName, newName);
                    }
                });
            } else if (ev.getPropertyName().equals("from-outcome")) {
                final String oldName = (String)ev.getOldValue();
                final String newName = (String)ev.getNewValue();
                final NavigationCase navCase = (NavigationCase)ev.getSource();
                EventQueue.invokeLater(new Runnable(){
                    final /* synthetic */ FacesModelPropertyChangeListener this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public void run() {
                        if (this.this$0.pfc.getView() == null) {
                            return;
                        }
                        this.this$0.replaceFromOutcomeEventHandler(navCase, oldName, newName);
                    }
                });
            } else {
                this.setupGraphInAWTThread(ev);
            }
        }
    }

    private final void replaceFromOutcomeEventHandler(NavigationCase navCase, String oldName, String newName) {
        NavigationCaseEdge edge = this.pfc.getNavCase2NavCaseEdge(navCase);
        PageFlowView view = this.pfc.getView();
        view.renameEdgeWidget(edge, newName, oldName);
        view.validateGraph();
    }

    private final void replaceFromViewIdToViewIdEventHandler(PropertyChangeEvent ev, Object source, String oldName, String newName) {
        LOGGER.entering("\n\nFacesModelPropertyChangeListener", "replaceFromViewIdToViewIdEventHandler");
        NavigationCase navCase = source instanceof NavigationCase ? (NavigationCase)source : null;
        NavigationRule navRule = source instanceof NavigationRule ? (NavigationRule)source : null;
        Page oldPageNode = this.pfc.getPageName2Page(oldName);
        Page newPageNode = this.pfc.getPageName2Page(newName);
        LOGGER.finest("OldPageNode: " + oldPageNode + "\nNewPageNode: " + newPageNode + NEWLINE);
        boolean isNewPageLinked = false;
        if (newPageNode != null && this.pfc.getView().getNodeEdges(newPageNode).size() > 0) {
            isNewPageLinked = true;
        }
        if (oldPageNode != null && !this.pfc.isPageInAnyFacesConfig(oldName) && !isNewPageLinked) {
            LOGGER.finest("CASE 1: OldPage is not null and does not exist in the facesconfig anymore.  This is the firsttime the new page is linked.");
            FileObject fileObj = this.pfc.getWebFolder().getFileObject(newName);
            if (fileObj != null && this.pfc.containsWebFile(fileObj)) {
                try {
                    Node delegate = DataObject.find((FileObject)fileObj).getNodeDelegate();
                    oldPageNode.replaceWrappedNode(delegate);
                    this.pfc.getView().resetNodeWidget(oldPageNode, true);
                    this.pfc.getView().validateGraph();
                }
                catch (DataObjectNotFoundException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            } else {
                this.pfc.changeToAbstractNode(oldPageNode, newName);
            }
        } else if (oldPageNode == null && !this.pfc.isPageInAnyFacesConfig(oldName)) {
            LOGGER.finest("CASE 2: OldPage was removed before.");
        } else if (navCase != null && this.pfc.isPageInAnyFacesConfig(oldName)) {
            LOGGER.finest("CASE 3: NavCase is not null");
            NavigationCaseEdge oldCaseEdge = this.pfc.removeNavCase2NavCaseEdge(navCase);
            NavigationCaseEdge newCaseEdge = new NavigationCaseEdge(this.pfc.getView().getPageFlowController(), navCase);
            this.pfc.putNavCase2NavCaseEdge(navCase, newCaseEdge);
            this.navigationCaseEdgeEventHandler(newCaseEdge, oldCaseEdge);
        } else if (navRule != null && this.pfc.isPageInAnyFacesConfig(oldName)) {
            LOGGER.finest("CASE 4: NavRule is not null.");
            List navCases = navRule.getNavigationCases();
            this.pfc.putNavRule2String(navRule, FacesModelUtility.getViewIdFiltiered(newName));
            for (NavigationCase thisNavCase : navCases) {
                LOGGER.finest("CASE 4: Redrawing NavRules Case.");
                NavigationCaseEdge newCaseEdge = null;
                NavigationCaseEdge oldCaseEdge = null;
                oldCaseEdge = this.pfc.removeNavCase2NavCaseEdge(thisNavCase);
                newCaseEdge = new NavigationCaseEdge(this.pfc.getView().getPageFlowController(), thisNavCase);
                this.pfc.putNavCase2NavCaseEdge(navCase, newCaseEdge);
                this.navigationCaseEdgeEventHandler(newCaseEdge, oldCaseEdge);
            }
        } else {
            LOGGER.finest("CASE 5: Setup Graph");
            this.setupGraph(ev);
        }
        LOGGER.exiting("FacesModelPropertyChangeListener", "replaceFromViewIdToViewIdEventHandler");
    }

    private void setupGraph(PropertyChangeEvent ev) {
        LOGGER.fine("\n\nRe-setting Page Flow Editor because of change in faces config xml file.\nSource Class:  org.netbeans.modules.web.jsf.navigation.FacesModelPropertyChangeListener\nMethod Name: setupGraph(PropertyChangeEvent ev)\nEvent: " + ev + NEWLINE + "PropertyName:" + ev.getPropertyName() + NEWLINE + "New Value: " + ev.getNewValue() + NEWLINE + "Old Value: " + ev.getOldValue() + NEWLINE + "Source: " + ev.getSource());
        LogRecord record = new LogRecord(Level.FINE, "Faces Config Change Re-Setting Graph");
        record.setSourceClassName("org.netbeans.modules.web.jsf.navigation.FacesModelPropertyChangeListener");
        record.setSourceMethodName("setupGraph(PropertyChangeEvent)");
        record.setParameters(new Object[]{ev});
        LOGGER.log(record);
        this.pfc.setupGraph();
    }

    private final void navigationCaseEventHandler(NavigationCase myNewCase, NavigationCase myOldCase) {
        NavigationCaseEdge newCaseEdge = null;
        NavigationCaseEdge oldCaseEdge = null;
        if (myNewCase != null) {
            newCaseEdge = new NavigationCaseEdge(this.pfc.getView().getPageFlowController(), myNewCase);
            this.pfc.putNavCase2NavCaseEdge(myNewCase, newCaseEdge);
        }
        if (myOldCase != null) {
            oldCaseEdge = this.pfc.removeNavCase2NavCaseEdge(myOldCase);
        }
        this.navigationCaseEdgeEventHandler(newCaseEdge, oldCaseEdge);
    }

    private final void navigationCaseEdgeEventHandler(NavigationCaseEdge newCaseEdge, NavigationCaseEdge oldCaseEdge) {
        PageFlowView view = this.pfc.getView();
        if (newCaseEdge != null && newCaseEdge.getToViewId() != null && newCaseEdge.getFromViewId() != null) {
            Page fromPage = this.pfc.getPageName2Page(newCaseEdge.getFromViewId());
            Page toPage = this.pfc.getPageName2Page(newCaseEdge.getToViewId());
            if (fromPage == null) {
                fromPage = this.pfc.createPage(newCaseEdge.getFromViewId());
                view.createNode(fromPage, null, null);
            }
            if (toPage == null) {
                toPage = this.pfc.createPage(newCaseEdge.getToViewId());
                view.createNode(toPage, null, null);
            }
            this.pfc.createEdge(newCaseEdge);
        }
        if (oldCaseEdge != null) {
            view.removeEdge(oldCaseEdge);
            this.removePageIfNoReference(oldCaseEdge.getToViewId());
        }
        view.validateGraph();
    }

    private final void removePageIfNoReference(String page) {
        Page pageNode;
        if (!(page == null || (pageNode = this.pfc.getPageName2Page(page)) == null || this.pfc.isPageInAnyFacesConfig(page) || pageNode.isDataNode() && !this.pfc.isCurrentScope(PageFlowToolbarUtilities.Scope.SCOPE_FACESCONFIG))) {
            PageFlowView view = this.pfc.getView();
            if (this.pfc.isCurrentScope(PageFlowToolbarUtilities.Scope.SCOPE_ALL_FACESCONFIG) && !this.pfc.isPageInAnyFacesConfig(page)) {
                view.removeNodeWithEdges(pageNode);
                this.pfc.removePageName2Page(pageNode, true);
                view.validateGraph();
            } else if (!this.pfc.isCurrentScope(PageFlowToolbarUtilities.Scope.SCOPE_ALL_FACESCONFIG)) {
                view.removeNodeWithEdges(pageNode);
                this.pfc.removePageName2Page(pageNode, true);
                view.validateGraph();
            }
        }
    }

    private final void navigationRuleEventHandler(NavigationRule myNewRule, NavigationRule myOldRule) {
        if (myOldRule != null) {
            String fromPage = this.pfc.removeNavRule2String(myOldRule);
            List cases = myOldRule.getNavigationCases();
            for (NavigationCase navCase : cases) {
                this.navigationCaseEventHandler(null, navCase);
            }
            this.removePageIfNoReference(fromPage);
        }
        if (myNewRule != null) {
            this.pfc.putNavRule2String(myNewRule, FacesModelUtility.getFromViewIdFiltered(myNewRule));
        }
    }

    private final void setupGraphInAWTThread(final PropertyChangeEvent ev) {
        EventQueue.invokeLater(new Runnable(){
            final /* synthetic */ FacesModelPropertyChangeListener this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                if (this.this$0.pfc.getView() == null) {
                    return;
                }
                this.this$0.setupGraph(ev);
            }
        });
    }
}

