/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.core.model.InstanceConfigurationAttachVnicDetails;
import com.oracle.bmc.core.model.InstanceConfigurationBlockVolumeDetails;
import com.oracle.bmc.core.model.InstanceConfigurationInstanceDetails;
import com.oracle.bmc.core.model.InstanceConfigurationLaunchInstanceDetails;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="instanceType")
@JsonFilter(value="explicitlySetFilter")
public final class ComputeInstanceDetails
extends InstanceConfigurationInstanceDetails {
    @JsonProperty(value="blockVolumes")
    private final List<InstanceConfigurationBlockVolumeDetails> blockVolumes;
    @JsonProperty(value="launchDetails")
    private final InstanceConfigurationLaunchInstanceDetails launchDetails;
    @JsonProperty(value="secondaryVnics")
    private final List<InstanceConfigurationAttachVnicDetails> secondaryVnics;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public ComputeInstanceDetails(List<InstanceConfigurationBlockVolumeDetails> blockVolumes, InstanceConfigurationLaunchInstanceDetails launchDetails, List<InstanceConfigurationAttachVnicDetails> secondaryVnics) {
        this.blockVolumes = blockVolumes;
        this.launchDetails = launchDetails;
        this.secondaryVnics = secondaryVnics;
    }

    public List<InstanceConfigurationBlockVolumeDetails> getBlockVolumes() {
        return this.blockVolumes;
    }

    public InstanceConfigurationLaunchInstanceDetails getLaunchDetails() {
        return this.launchDetails;
    }

    public List<InstanceConfigurationAttachVnicDetails> getSecondaryVnics() {
        return this.secondaryVnics;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ComputeInstanceDetails(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", blockVolumes=").append(String.valueOf(this.blockVolumes));
        sb.append(", launchDetails=").append(String.valueOf((Object)this.launchDetails));
        sb.append(", secondaryVnics=").append(String.valueOf(this.secondaryVnics));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ComputeInstanceDetails)) {
            return false;
        }
        ComputeInstanceDetails other = (ComputeInstanceDetails)((Object)o);
        return Objects.equals(this.blockVolumes, other.blockVolumes) && Objects.equals((Object)this.launchDetails, (Object)other.launchDetails) && Objects.equals(this.secondaryVnics, other.secondaryVnics) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.blockVolumes == null ? 43 : this.blockVolumes.hashCode());
        result = result * 59 + (this.launchDetails == null ? 43 : this.launchDetails.hashCode());
        result = result * 59 + (this.secondaryVnics == null ? 43 : this.secondaryVnics.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="blockVolumes")
        private List<InstanceConfigurationBlockVolumeDetails> blockVolumes;
        @JsonProperty(value="launchDetails")
        private InstanceConfigurationLaunchInstanceDetails launchDetails;
        @JsonProperty(value="secondaryVnics")
        private List<InstanceConfigurationAttachVnicDetails> secondaryVnics;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder blockVolumes(List<InstanceConfigurationBlockVolumeDetails> blockVolumes) {
            this.blockVolumes = blockVolumes;
            this.__explicitlySet__.add("blockVolumes");
            return this;
        }

        public Builder launchDetails(InstanceConfigurationLaunchInstanceDetails launchDetails) {
            this.launchDetails = launchDetails;
            this.__explicitlySet__.add("launchDetails");
            return this;
        }

        public Builder secondaryVnics(List<InstanceConfigurationAttachVnicDetails> secondaryVnics) {
            this.secondaryVnics = secondaryVnics;
            this.__explicitlySet__.add("secondaryVnics");
            return this;
        }

        public ComputeInstanceDetails build() {
            ComputeInstanceDetails model = new ComputeInstanceDetails(this.blockVolumes, this.launchDetails, this.secondaryVnics);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ComputeInstanceDetails model) {
            if (model.wasPropertyExplicitlySet("blockVolumes")) {
                this.blockVolumes(model.getBlockVolumes());
            }
            if (model.wasPropertyExplicitlySet("launchDetails")) {
                this.launchDetails(model.getLaunchDetails());
            }
            if (model.wasPropertyExplicitlySet("secondaryVnics")) {
                this.secondaryVnics(model.getSecondaryVnics());
            }
            return this;
        }
    }
}

