/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.core.model.ComputeCapacityReservation;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ComputeCapacityReservationSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="lifecycleState")
    private final ComputeCapacityReservation.LifecycleState lifecycleState;
    @JsonProperty(value="availabilityDomain")
    private final String availabilityDomain;
    @JsonProperty(value="reservedInstanceCount")
    private final Long reservedInstanceCount;
    @JsonProperty(value="usedInstanceCount")
    private final Long usedInstanceCount;
    @JsonProperty(value="isDefaultReservation")
    private final Boolean isDefaultReservation;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;

    @Deprecated
    @ConstructorProperties(value={"id", "compartmentId", "displayName", "definedTags", "freeformTags", "lifecycleState", "availabilityDomain", "reservedInstanceCount", "usedInstanceCount", "isDefaultReservation", "timeCreated"})
    public ComputeCapacityReservationSummary(String id, String compartmentId, String displayName, Map<String, Map<String, Object>> definedTags, Map<String, String> freeformTags, ComputeCapacityReservation.LifecycleState lifecycleState, String availabilityDomain, Long reservedInstanceCount, Long usedInstanceCount, Boolean isDefaultReservation, Date timeCreated) {
        this.id = id;
        this.compartmentId = compartmentId;
        this.displayName = displayName;
        this.definedTags = definedTags;
        this.freeformTags = freeformTags;
        this.lifecycleState = lifecycleState;
        this.availabilityDomain = availabilityDomain;
        this.reservedInstanceCount = reservedInstanceCount;
        this.usedInstanceCount = usedInstanceCount;
        this.isDefaultReservation = isDefaultReservation;
        this.timeCreated = timeCreated;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public ComputeCapacityReservation.LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String getAvailabilityDomain() {
        return this.availabilityDomain;
    }

    public Long getReservedInstanceCount() {
        return this.reservedInstanceCount;
    }

    public Long getUsedInstanceCount() {
        return this.usedInstanceCount;
    }

    public Boolean getIsDefaultReservation() {
        return this.isDefaultReservation;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ComputeCapacityReservationSummary(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", availabilityDomain=").append(String.valueOf(this.availabilityDomain));
        sb.append(", reservedInstanceCount=").append(String.valueOf(this.reservedInstanceCount));
        sb.append(", usedInstanceCount=").append(String.valueOf(this.usedInstanceCount));
        sb.append(", isDefaultReservation=").append(String.valueOf(this.isDefaultReservation));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ComputeCapacityReservationSummary)) {
            return false;
        }
        ComputeCapacityReservationSummary other = (ComputeCapacityReservationSummary)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.definedTags, other.definedTags) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.availabilityDomain, other.availabilityDomain) && Objects.equals(this.reservedInstanceCount, other.reservedInstanceCount) && Objects.equals(this.usedInstanceCount, other.usedInstanceCount) && Objects.equals(this.isDefaultReservation, other.isDefaultReservation) && Objects.equals(this.timeCreated, other.timeCreated) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.availabilityDomain == null ? 43 : this.availabilityDomain.hashCode());
        result = result * 59 + (this.reservedInstanceCount == null ? 43 : this.reservedInstanceCount.hashCode());
        result = result * 59 + (this.usedInstanceCount == null ? 43 : this.usedInstanceCount.hashCode());
        result = result * 59 + (this.isDefaultReservation == null ? 43 : this.isDefaultReservation.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="lifecycleState")
        private ComputeCapacityReservation.LifecycleState lifecycleState;
        @JsonProperty(value="availabilityDomain")
        private String availabilityDomain;
        @JsonProperty(value="reservedInstanceCount")
        private Long reservedInstanceCount;
        @JsonProperty(value="usedInstanceCount")
        private Long usedInstanceCount;
        @JsonProperty(value="isDefaultReservation")
        private Boolean isDefaultReservation;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder lifecycleState(ComputeCapacityReservation.LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder availabilityDomain(String availabilityDomain) {
            this.availabilityDomain = availabilityDomain;
            this.__explicitlySet__.add("availabilityDomain");
            return this;
        }

        public Builder reservedInstanceCount(Long reservedInstanceCount) {
            this.reservedInstanceCount = reservedInstanceCount;
            this.__explicitlySet__.add("reservedInstanceCount");
            return this;
        }

        public Builder usedInstanceCount(Long usedInstanceCount) {
            this.usedInstanceCount = usedInstanceCount;
            this.__explicitlySet__.add("usedInstanceCount");
            return this;
        }

        public Builder isDefaultReservation(Boolean isDefaultReservation) {
            this.isDefaultReservation = isDefaultReservation;
            this.__explicitlySet__.add("isDefaultReservation");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public ComputeCapacityReservationSummary build() {
            ComputeCapacityReservationSummary model = new ComputeCapacityReservationSummary(this.id, this.compartmentId, this.displayName, this.definedTags, this.freeformTags, this.lifecycleState, this.availabilityDomain, this.reservedInstanceCount, this.usedInstanceCount, this.isDefaultReservation, this.timeCreated);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ComputeCapacityReservationSummary model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("availabilityDomain")) {
                this.availabilityDomain(model.getAvailabilityDomain());
            }
            if (model.wasPropertyExplicitlySet("reservedInstanceCount")) {
                this.reservedInstanceCount(model.getReservedInstanceCount());
            }
            if (model.wasPropertyExplicitlySet("usedInstanceCount")) {
                this.usedInstanceCount(model.getUsedInstanceCount());
            }
            if (model.wasPropertyExplicitlySet("isDefaultReservation")) {
                this.isDefaultReservation(model.getIsDefaultReservation());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            return this;
        }
    }
}

