/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core;

import com.oracle.bmc.core.VirtualNetwork;
import com.oracle.bmc.core.model.ByoipRange;
import com.oracle.bmc.core.model.CaptureFilter;
import com.oracle.bmc.core.model.CrossConnect;
import com.oracle.bmc.core.model.CrossConnectGroup;
import com.oracle.bmc.core.model.DhcpOptions;
import com.oracle.bmc.core.model.Drg;
import com.oracle.bmc.core.model.DrgAttachment;
import com.oracle.bmc.core.model.DrgRouteDistribution;
import com.oracle.bmc.core.model.DrgRouteTable;
import com.oracle.bmc.core.model.IPSecConnection;
import com.oracle.bmc.core.model.IPSecConnectionTunnel;
import com.oracle.bmc.core.model.InternetGateway;
import com.oracle.bmc.core.model.Ipv6;
import com.oracle.bmc.core.model.LocalPeeringGateway;
import com.oracle.bmc.core.model.NatGateway;
import com.oracle.bmc.core.model.NetworkSecurityGroup;
import com.oracle.bmc.core.model.PublicIp;
import com.oracle.bmc.core.model.PublicIpPool;
import com.oracle.bmc.core.model.RemotePeeringConnection;
import com.oracle.bmc.core.model.RouteTable;
import com.oracle.bmc.core.model.SecurityList;
import com.oracle.bmc.core.model.ServiceGateway;
import com.oracle.bmc.core.model.Subnet;
import com.oracle.bmc.core.model.Vcn;
import com.oracle.bmc.core.model.VcnDnsResolverAssociation;
import com.oracle.bmc.core.model.VirtualCircuit;
import com.oracle.bmc.core.model.Vlan;
import com.oracle.bmc.core.model.Vnic;
import com.oracle.bmc.core.model.Vtap;
import com.oracle.bmc.core.requests.AddIpv6SubnetCidrRequest;
import com.oracle.bmc.core.requests.AddIpv6VcnCidrRequest;
import com.oracle.bmc.core.requests.AddVcnCidrRequest;
import com.oracle.bmc.core.requests.ChangeCaptureFilterCompartmentRequest;
import com.oracle.bmc.core.requests.ChangeDrgCompartmentRequest;
import com.oracle.bmc.core.requests.ChangeSubnetCompartmentRequest;
import com.oracle.bmc.core.requests.ChangeVcnCompartmentRequest;
import com.oracle.bmc.core.requests.ChangeVlanCompartmentRequest;
import com.oracle.bmc.core.requests.ChangeVtapCompartmentRequest;
import com.oracle.bmc.core.requests.DeleteByoipRangeRequest;
import com.oracle.bmc.core.requests.DeleteVtapRequest;
import com.oracle.bmc.core.requests.GetByoipRangeRequest;
import com.oracle.bmc.core.requests.GetCaptureFilterRequest;
import com.oracle.bmc.core.requests.GetCrossConnectGroupRequest;
import com.oracle.bmc.core.requests.GetCrossConnectRequest;
import com.oracle.bmc.core.requests.GetDhcpOptionsRequest;
import com.oracle.bmc.core.requests.GetDrgAttachmentRequest;
import com.oracle.bmc.core.requests.GetDrgRequest;
import com.oracle.bmc.core.requests.GetDrgRouteDistributionRequest;
import com.oracle.bmc.core.requests.GetDrgRouteTableRequest;
import com.oracle.bmc.core.requests.GetIPSecConnectionRequest;
import com.oracle.bmc.core.requests.GetIPSecConnectionTunnelRequest;
import com.oracle.bmc.core.requests.GetInternetGatewayRequest;
import com.oracle.bmc.core.requests.GetIpv6Request;
import com.oracle.bmc.core.requests.GetLocalPeeringGatewayRequest;
import com.oracle.bmc.core.requests.GetNatGatewayRequest;
import com.oracle.bmc.core.requests.GetNetworkSecurityGroupRequest;
import com.oracle.bmc.core.requests.GetPublicIpPoolRequest;
import com.oracle.bmc.core.requests.GetPublicIpRequest;
import com.oracle.bmc.core.requests.GetRemotePeeringConnectionRequest;
import com.oracle.bmc.core.requests.GetRouteTableRequest;
import com.oracle.bmc.core.requests.GetSecurityListRequest;
import com.oracle.bmc.core.requests.GetServiceGatewayRequest;
import com.oracle.bmc.core.requests.GetSubnetRequest;
import com.oracle.bmc.core.requests.GetVcnDnsResolverAssociationRequest;
import com.oracle.bmc.core.requests.GetVcnRequest;
import com.oracle.bmc.core.requests.GetVirtualCircuitRequest;
import com.oracle.bmc.core.requests.GetVlanRequest;
import com.oracle.bmc.core.requests.GetVnicRequest;
import com.oracle.bmc.core.requests.GetVtapRequest;
import com.oracle.bmc.core.requests.ModifyVcnCidrRequest;
import com.oracle.bmc.core.requests.RemoveIpv6SubnetCidrRequest;
import com.oracle.bmc.core.requests.RemoveIpv6VcnCidrRequest;
import com.oracle.bmc.core.requests.RemoveVcnCidrRequest;
import com.oracle.bmc.core.requests.UpdateVtapRequest;
import com.oracle.bmc.core.requests.UpgradeDrgRequest;
import com.oracle.bmc.core.requests.ValidateByoipRangeRequest;
import com.oracle.bmc.core.responses.AddIpv6SubnetCidrResponse;
import com.oracle.bmc.core.responses.AddIpv6VcnCidrResponse;
import com.oracle.bmc.core.responses.AddVcnCidrResponse;
import com.oracle.bmc.core.responses.ChangeCaptureFilterCompartmentResponse;
import com.oracle.bmc.core.responses.ChangeDrgCompartmentResponse;
import com.oracle.bmc.core.responses.ChangeSubnetCompartmentResponse;
import com.oracle.bmc.core.responses.ChangeVcnCompartmentResponse;
import com.oracle.bmc.core.responses.ChangeVlanCompartmentResponse;
import com.oracle.bmc.core.responses.ChangeVtapCompartmentResponse;
import com.oracle.bmc.core.responses.DeleteByoipRangeResponse;
import com.oracle.bmc.core.responses.DeleteVtapResponse;
import com.oracle.bmc.core.responses.GetByoipRangeResponse;
import com.oracle.bmc.core.responses.GetCaptureFilterResponse;
import com.oracle.bmc.core.responses.GetCrossConnectGroupResponse;
import com.oracle.bmc.core.responses.GetCrossConnectResponse;
import com.oracle.bmc.core.responses.GetDhcpOptionsResponse;
import com.oracle.bmc.core.responses.GetDrgAttachmentResponse;
import com.oracle.bmc.core.responses.GetDrgResponse;
import com.oracle.bmc.core.responses.GetDrgRouteDistributionResponse;
import com.oracle.bmc.core.responses.GetDrgRouteTableResponse;
import com.oracle.bmc.core.responses.GetIPSecConnectionResponse;
import com.oracle.bmc.core.responses.GetIPSecConnectionTunnelResponse;
import com.oracle.bmc.core.responses.GetInternetGatewayResponse;
import com.oracle.bmc.core.responses.GetIpv6Response;
import com.oracle.bmc.core.responses.GetLocalPeeringGatewayResponse;
import com.oracle.bmc.core.responses.GetNatGatewayResponse;
import com.oracle.bmc.core.responses.GetNetworkSecurityGroupResponse;
import com.oracle.bmc.core.responses.GetPublicIpPoolResponse;
import com.oracle.bmc.core.responses.GetPublicIpResponse;
import com.oracle.bmc.core.responses.GetRemotePeeringConnectionResponse;
import com.oracle.bmc.core.responses.GetRouteTableResponse;
import com.oracle.bmc.core.responses.GetSecurityListResponse;
import com.oracle.bmc.core.responses.GetServiceGatewayResponse;
import com.oracle.bmc.core.responses.GetSubnetResponse;
import com.oracle.bmc.core.responses.GetVcnDnsResolverAssociationResponse;
import com.oracle.bmc.core.responses.GetVcnResponse;
import com.oracle.bmc.core.responses.GetVirtualCircuitResponse;
import com.oracle.bmc.core.responses.GetVlanResponse;
import com.oracle.bmc.core.responses.GetVnicResponse;
import com.oracle.bmc.core.responses.GetVtapResponse;
import com.oracle.bmc.core.responses.ModifyVcnCidrResponse;
import com.oracle.bmc.core.responses.RemoveIpv6SubnetCidrResponse;
import com.oracle.bmc.core.responses.RemoveIpv6VcnCidrResponse;
import com.oracle.bmc.core.responses.RemoveVcnCidrResponse;
import com.oracle.bmc.core.responses.UpdateVtapResponse;
import com.oracle.bmc.core.responses.UpgradeDrgResponse;
import com.oracle.bmc.core.responses.ValidateByoipRangeResponse;
import com.oracle.bmc.util.internal.Validate;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import com.oracle.bmc.workrequests.WorkRequest;
import com.oracle.bmc.workrequests.requests.GetWorkRequestRequest;
import jakarta.annotation.Nonnull;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.function.Predicate;

public class VirtualNetworkWaiters {
    @Nonnull
    private final ExecutorService executorService;
    @Nonnull
    private final VirtualNetwork client;
    private final WorkRequest workRequestClient;

    @Deprecated
    public VirtualNetworkWaiters(@Nonnull ExecutorService executorService, @Nonnull VirtualNetwork client) {
        this(executorService, client, null);
    }

    public VirtualNetworkWaiters(@Nonnull ExecutorService executorService, @Nonnull VirtualNetwork client, WorkRequest workRequestClient) {
        if (executorService == null) {
            throw new NullPointerException("executorService is marked non-null but is null");
        }
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        this.executorService = executorService;
        this.client = client;
        this.workRequestClient = workRequestClient;
    }

    public Waiter<AddIpv6SubnetCidrRequest, AddIpv6SubnetCidrResponse> forAddIpv6SubnetCidr(AddIpv6SubnetCidrRequest request) {
        return this.forAddIpv6SubnetCidr(request, Waiters.DEFAULT_POLLING_TERMINATION_STRATEGY, Waiters.DEFAULT_POLLING_DELAY_STRATEGY);
    }

    public Waiter<AddIpv6SubnetCidrRequest, AddIpv6SubnetCidrResponse> forAddIpv6SubnetCidr(final AddIpv6SubnetCidrRequest request, final TerminationStrategy terminationStrategy, final DelayStrategy delayStrategy) {
        if (this.workRequestClient == null) {
            throw new IllegalStateException("A WorkRequestClient must be supplied to this waiter for this operation");
        }
        return new SimpleWaiterImpl(this.executorService, (Callable)new Callable<AddIpv6SubnetCidrResponse>(){

            @Override
            public AddIpv6SubnetCidrResponse call() throws Exception {
                AddIpv6SubnetCidrResponse response = VirtualNetworkWaiters.this.client.addIpv6SubnetCidr(request);
                GetWorkRequestRequest getWorkRequestRequest = GetWorkRequestRequest.builder().workRequestId(response.getOpcWorkRequestId()).build();
                VirtualNetworkWaiters.this.workRequestClient.getWaiters().forWorkRequest(getWorkRequestRequest, terminationStrategy, delayStrategy).execute();
                return response;
            }
        }, (Object)request);
    }

    public Waiter<AddIpv6VcnCidrRequest, AddIpv6VcnCidrResponse> forAddIpv6VcnCidr(AddIpv6VcnCidrRequest request) {
        return this.forAddIpv6VcnCidr(request, Waiters.DEFAULT_POLLING_TERMINATION_STRATEGY, Waiters.DEFAULT_POLLING_DELAY_STRATEGY);
    }

    public Waiter<AddIpv6VcnCidrRequest, AddIpv6VcnCidrResponse> forAddIpv6VcnCidr(final AddIpv6VcnCidrRequest request, final TerminationStrategy terminationStrategy, final DelayStrategy delayStrategy) {
        if (this.workRequestClient == null) {
            throw new IllegalStateException("A WorkRequestClient must be supplied to this waiter for this operation");
        }
        return new SimpleWaiterImpl(this.executorService, (Callable)new Callable<AddIpv6VcnCidrResponse>(){

            @Override
            public AddIpv6VcnCidrResponse call() throws Exception {
                AddIpv6VcnCidrResponse response = VirtualNetworkWaiters.this.client.addIpv6VcnCidr(request);
                GetWorkRequestRequest getWorkRequestRequest = GetWorkRequestRequest.builder().workRequestId(response.getOpcWorkRequestId()).build();
                VirtualNetworkWaiters.this.workRequestClient.getWaiters().forWorkRequest(getWorkRequestRequest, terminationStrategy, delayStrategy).execute();
                return response;
            }
        }, (Object)request);
    }

    public Waiter<AddVcnCidrRequest, AddVcnCidrResponse> forAddVcnCidr(AddVcnCidrRequest request) {
        return this.forAddVcnCidr(request, Waiters.DEFAULT_POLLING_TERMINATION_STRATEGY, Waiters.DEFAULT_POLLING_DELAY_STRATEGY);
    }

    public Waiter<AddVcnCidrRequest, AddVcnCidrResponse> forAddVcnCidr(final AddVcnCidrRequest request, final TerminationStrategy terminationStrategy, final DelayStrategy delayStrategy) {
        if (this.workRequestClient == null) {
            throw new IllegalStateException("A WorkRequestClient must be supplied to this waiter for this operation");
        }
        return new SimpleWaiterImpl(this.executorService, (Callable)new Callable<AddVcnCidrResponse>(){

            @Override
            public AddVcnCidrResponse call() throws Exception {
                AddVcnCidrResponse response = VirtualNetworkWaiters.this.client.addVcnCidr(request);
                GetWorkRequestRequest getWorkRequestRequest = GetWorkRequestRequest.builder().workRequestId(response.getOpcWorkRequestId()).build();
                VirtualNetworkWaiters.this.workRequestClient.getWaiters().forWorkRequest(getWorkRequestRequest, terminationStrategy, delayStrategy).execute();
                return response;
            }
        }, (Object)request);
    }

    public Waiter<ChangeCaptureFilterCompartmentRequest, ChangeCaptureFilterCompartmentResponse> forChangeCaptureFilterCompartment(ChangeCaptureFilterCompartmentRequest request) {
        return this.forChangeCaptureFilterCompartment(request, Waiters.DEFAULT_POLLING_TERMINATION_STRATEGY, Waiters.DEFAULT_POLLING_DELAY_STRATEGY);
    }

    public Waiter<ChangeCaptureFilterCompartmentRequest, ChangeCaptureFilterCompartmentResponse> forChangeCaptureFilterCompartment(final ChangeCaptureFilterCompartmentRequest request, final TerminationStrategy terminationStrategy, final DelayStrategy delayStrategy) {
        if (this.workRequestClient == null) {
            throw new IllegalStateException("A WorkRequestClient must be supplied to this waiter for this operation");
        }
        return new SimpleWaiterImpl(this.executorService, (Callable)new Callable<ChangeCaptureFilterCompartmentResponse>(){

            @Override
            public ChangeCaptureFilterCompartmentResponse call() throws Exception {
                ChangeCaptureFilterCompartmentResponse response = VirtualNetworkWaiters.this.client.changeCaptureFilterCompartment(request);
                GetWorkRequestRequest getWorkRequestRequest = GetWorkRequestRequest.builder().workRequestId(response.getOpcWorkRequestId()).build();
                VirtualNetworkWaiters.this.workRequestClient.getWaiters().forWorkRequest(getWorkRequestRequest, terminationStrategy, delayStrategy).execute();
                return response;
            }
        }, (Object)request);
    }

    public Waiter<ChangeDrgCompartmentRequest, ChangeDrgCompartmentResponse> forChangeDrgCompartment(ChangeDrgCompartmentRequest request) {
        return this.forChangeDrgCompartment(request, Waiters.DEFAULT_POLLING_TERMINATION_STRATEGY, Waiters.DEFAULT_POLLING_DELAY_STRATEGY);
    }

    public Waiter<ChangeDrgCompartmentRequest, ChangeDrgCompartmentResponse> forChangeDrgCompartment(final ChangeDrgCompartmentRequest request, final TerminationStrategy terminationStrategy, final DelayStrategy delayStrategy) {
        if (this.workRequestClient == null) {
            throw new IllegalStateException("A WorkRequestClient must be supplied to this waiter for this operation");
        }
        return new SimpleWaiterImpl(this.executorService, (Callable)new Callable<ChangeDrgCompartmentResponse>(){

            @Override
            public ChangeDrgCompartmentResponse call() throws Exception {
                ChangeDrgCompartmentResponse response = VirtualNetworkWaiters.this.client.changeDrgCompartment(request);
                GetWorkRequestRequest getWorkRequestRequest = GetWorkRequestRequest.builder().workRequestId(response.getOpcWorkRequestId()).build();
                VirtualNetworkWaiters.this.workRequestClient.getWaiters().forWorkRequest(getWorkRequestRequest, terminationStrategy, delayStrategy).execute();
                return response;
            }
        }, (Object)request);
    }

    public Waiter<ChangeSubnetCompartmentRequest, ChangeSubnetCompartmentResponse> forChangeSubnetCompartment(ChangeSubnetCompartmentRequest request) {
        return this.forChangeSubnetCompartment(request, Waiters.DEFAULT_POLLING_TERMINATION_STRATEGY, Waiters.DEFAULT_POLLING_DELAY_STRATEGY);
    }

    public Waiter<ChangeSubnetCompartmentRequest, ChangeSubnetCompartmentResponse> forChangeSubnetCompartment(final ChangeSubnetCompartmentRequest request, final TerminationStrategy terminationStrategy, final DelayStrategy delayStrategy) {
        if (this.workRequestClient == null) {
            throw new IllegalStateException("A WorkRequestClient must be supplied to this waiter for this operation");
        }
        return new SimpleWaiterImpl(this.executorService, (Callable)new Callable<ChangeSubnetCompartmentResponse>(){

            @Override
            public ChangeSubnetCompartmentResponse call() throws Exception {
                ChangeSubnetCompartmentResponse response = VirtualNetworkWaiters.this.client.changeSubnetCompartment(request);
                GetWorkRequestRequest getWorkRequestRequest = GetWorkRequestRequest.builder().workRequestId(response.getOpcWorkRequestId()).build();
                VirtualNetworkWaiters.this.workRequestClient.getWaiters().forWorkRequest(getWorkRequestRequest, terminationStrategy, delayStrategy).execute();
                return response;
            }
        }, (Object)request);
    }

    public Waiter<ChangeVcnCompartmentRequest, ChangeVcnCompartmentResponse> forChangeVcnCompartment(ChangeVcnCompartmentRequest request) {
        return this.forChangeVcnCompartment(request, Waiters.DEFAULT_POLLING_TERMINATION_STRATEGY, Waiters.DEFAULT_POLLING_DELAY_STRATEGY);
    }

    public Waiter<ChangeVcnCompartmentRequest, ChangeVcnCompartmentResponse> forChangeVcnCompartment(final ChangeVcnCompartmentRequest request, final TerminationStrategy terminationStrategy, final DelayStrategy delayStrategy) {
        if (this.workRequestClient == null) {
            throw new IllegalStateException("A WorkRequestClient must be supplied to this waiter for this operation");
        }
        return new SimpleWaiterImpl(this.executorService, (Callable)new Callable<ChangeVcnCompartmentResponse>(){

            @Override
            public ChangeVcnCompartmentResponse call() throws Exception {
                ChangeVcnCompartmentResponse response = VirtualNetworkWaiters.this.client.changeVcnCompartment(request);
                GetWorkRequestRequest getWorkRequestRequest = GetWorkRequestRequest.builder().workRequestId(response.getOpcWorkRequestId()).build();
                VirtualNetworkWaiters.this.workRequestClient.getWaiters().forWorkRequest(getWorkRequestRequest, terminationStrategy, delayStrategy).execute();
                return response;
            }
        }, (Object)request);
    }

    public Waiter<ChangeVlanCompartmentRequest, ChangeVlanCompartmentResponse> forChangeVlanCompartment(ChangeVlanCompartmentRequest request) {
        return this.forChangeVlanCompartment(request, Waiters.DEFAULT_POLLING_TERMINATION_STRATEGY, Waiters.DEFAULT_POLLING_DELAY_STRATEGY);
    }

    public Waiter<ChangeVlanCompartmentRequest, ChangeVlanCompartmentResponse> forChangeVlanCompartment(final ChangeVlanCompartmentRequest request, final TerminationStrategy terminationStrategy, final DelayStrategy delayStrategy) {
        if (this.workRequestClient == null) {
            throw new IllegalStateException("A WorkRequestClient must be supplied to this waiter for this operation");
        }
        return new SimpleWaiterImpl(this.executorService, (Callable)new Callable<ChangeVlanCompartmentResponse>(){

            @Override
            public ChangeVlanCompartmentResponse call() throws Exception {
                ChangeVlanCompartmentResponse response = VirtualNetworkWaiters.this.client.changeVlanCompartment(request);
                GetWorkRequestRequest getWorkRequestRequest = GetWorkRequestRequest.builder().workRequestId(response.getOpcWorkRequestId()).build();
                VirtualNetworkWaiters.this.workRequestClient.getWaiters().forWorkRequest(getWorkRequestRequest, terminationStrategy, delayStrategy).execute();
                return response;
            }
        }, (Object)request);
    }

    public Waiter<ChangeVtapCompartmentRequest, ChangeVtapCompartmentResponse> forChangeVtapCompartment(ChangeVtapCompartmentRequest request) {
        return this.forChangeVtapCompartment(request, Waiters.DEFAULT_POLLING_TERMINATION_STRATEGY, Waiters.DEFAULT_POLLING_DELAY_STRATEGY);
    }

    public Waiter<ChangeVtapCompartmentRequest, ChangeVtapCompartmentResponse> forChangeVtapCompartment(final ChangeVtapCompartmentRequest request, final TerminationStrategy terminationStrategy, final DelayStrategy delayStrategy) {
        if (this.workRequestClient == null) {
            throw new IllegalStateException("A WorkRequestClient must be supplied to this waiter for this operation");
        }
        return new SimpleWaiterImpl(this.executorService, (Callable)new Callable<ChangeVtapCompartmentResponse>(){

            @Override
            public ChangeVtapCompartmentResponse call() throws Exception {
                ChangeVtapCompartmentResponse response = VirtualNetworkWaiters.this.client.changeVtapCompartment(request);
                GetWorkRequestRequest getWorkRequestRequest = GetWorkRequestRequest.builder().workRequestId(response.getOpcWorkRequestId()).build();
                VirtualNetworkWaiters.this.workRequestClient.getWaiters().forWorkRequest(getWorkRequestRequest, terminationStrategy, delayStrategy).execute();
                return response;
            }
        }, (Object)request);
    }

    public Waiter<DeleteByoipRangeRequest, DeleteByoipRangeResponse> forDeleteByoipRange(DeleteByoipRangeRequest request) {
        return this.forDeleteByoipRange(request, Waiters.DEFAULT_POLLING_TERMINATION_STRATEGY, Waiters.DEFAULT_POLLING_DELAY_STRATEGY);
    }

    public Waiter<DeleteByoipRangeRequest, DeleteByoipRangeResponse> forDeleteByoipRange(final DeleteByoipRangeRequest request, final TerminationStrategy terminationStrategy, final DelayStrategy delayStrategy) {
        if (this.workRequestClient == null) {
            throw new IllegalStateException("A WorkRequestClient must be supplied to this waiter for this operation");
        }
        return new SimpleWaiterImpl(this.executorService, (Callable)new Callable<DeleteByoipRangeResponse>(){

            @Override
            public DeleteByoipRangeResponse call() throws Exception {
                DeleteByoipRangeResponse response = VirtualNetworkWaiters.this.client.deleteByoipRange(request);
                GetWorkRequestRequest getWorkRequestRequest = GetWorkRequestRequest.builder().workRequestId(response.getOpcWorkRequestId()).build();
                VirtualNetworkWaiters.this.workRequestClient.getWaiters().forWorkRequest(getWorkRequestRequest, terminationStrategy, delayStrategy).execute();
                return response;
            }
        }, (Object)request);
    }

    public Waiter<DeleteVtapRequest, DeleteVtapResponse> forDeleteVtap(DeleteVtapRequest request) {
        return this.forDeleteVtap(request, Waiters.DEFAULT_POLLING_TERMINATION_STRATEGY, Waiters.DEFAULT_POLLING_DELAY_STRATEGY);
    }

    public Waiter<DeleteVtapRequest, DeleteVtapResponse> forDeleteVtap(final DeleteVtapRequest request, final TerminationStrategy terminationStrategy, final DelayStrategy delayStrategy) {
        if (this.workRequestClient == null) {
            throw new IllegalStateException("A WorkRequestClient must be supplied to this waiter for this operation");
        }
        return new SimpleWaiterImpl(this.executorService, (Callable)new Callable<DeleteVtapResponse>(){

            @Override
            public DeleteVtapResponse call() throws Exception {
                DeleteVtapResponse response = VirtualNetworkWaiters.this.client.deleteVtap(request);
                GetWorkRequestRequest getWorkRequestRequest = GetWorkRequestRequest.builder().workRequestId(response.getOpcWorkRequestId()).build();
                VirtualNetworkWaiters.this.workRequestClient.getWaiters().forWorkRequest(getWorkRequestRequest, terminationStrategy, delayStrategy).execute();
                return response;
            }
        }, (Object)request);
    }

    public Waiter<GetByoipRangeRequest, GetByoipRangeResponse> forByoipRange(GetByoipRangeRequest request, ByoipRange.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forByoipRange(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetByoipRangeRequest, GetByoipRangeResponse> forByoipRange(GetByoipRangeRequest request, ByoipRange.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forByoipRange(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetByoipRangeRequest, GetByoipRangeResponse> forByoipRange(GetByoipRangeRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, ByoipRange.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forByoipRange(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetByoipRangeRequest, GetByoipRangeResponse> forByoipRange(BmcGenericWaiter waiter, GetByoipRangeRequest request, ByoipRange.LifecycleState ... targetStates) {
        final HashSet<ByoipRange.LifecycleState> targetStatesSet = new HashSet<ByoipRange.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetByoipRangeRequest, GetByoipRangeResponse>(){

            @Override
            public GetByoipRangeResponse apply(GetByoipRangeRequest request) {
                return VirtualNetworkWaiters.this.client.getByoipRange(request);
            }
        }, (Predicate)new Predicate<GetByoipRangeResponse>(){

            @Override
            public boolean test(GetByoipRangeResponse response) {
                return targetStatesSet.contains((Object)response.getByoipRange().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)ByoipRange.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetCaptureFilterRequest, GetCaptureFilterResponse> forCaptureFilter(GetCaptureFilterRequest request, CaptureFilter.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forCaptureFilter(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetCaptureFilterRequest, GetCaptureFilterResponse> forCaptureFilter(GetCaptureFilterRequest request, CaptureFilter.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forCaptureFilter(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetCaptureFilterRequest, GetCaptureFilterResponse> forCaptureFilter(GetCaptureFilterRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, CaptureFilter.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forCaptureFilter(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetCaptureFilterRequest, GetCaptureFilterResponse> forCaptureFilter(BmcGenericWaiter waiter, GetCaptureFilterRequest request, CaptureFilter.LifecycleState ... targetStates) {
        final HashSet<CaptureFilter.LifecycleState> targetStatesSet = new HashSet<CaptureFilter.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetCaptureFilterRequest, GetCaptureFilterResponse>(){

            @Override
            public GetCaptureFilterResponse apply(GetCaptureFilterRequest request) {
                return VirtualNetworkWaiters.this.client.getCaptureFilter(request);
            }
        }, (Predicate)new Predicate<GetCaptureFilterResponse>(){

            @Override
            public boolean test(GetCaptureFilterResponse response) {
                return targetStatesSet.contains((Object)response.getCaptureFilter().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)CaptureFilter.LifecycleState.Terminated)), (Object)request);
    }

    public Waiter<GetCrossConnectRequest, GetCrossConnectResponse> forCrossConnect(GetCrossConnectRequest request, CrossConnect.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forCrossConnect(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetCrossConnectRequest, GetCrossConnectResponse> forCrossConnect(GetCrossConnectRequest request, CrossConnect.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forCrossConnect(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetCrossConnectRequest, GetCrossConnectResponse> forCrossConnect(GetCrossConnectRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, CrossConnect.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forCrossConnect(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetCrossConnectRequest, GetCrossConnectResponse> forCrossConnect(BmcGenericWaiter waiter, GetCrossConnectRequest request, CrossConnect.LifecycleState ... targetStates) {
        final HashSet<CrossConnect.LifecycleState> targetStatesSet = new HashSet<CrossConnect.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetCrossConnectRequest, GetCrossConnectResponse>(){

            @Override
            public GetCrossConnectResponse apply(GetCrossConnectRequest request) {
                return VirtualNetworkWaiters.this.client.getCrossConnect(request);
            }
        }, (Predicate)new Predicate<GetCrossConnectResponse>(){

            @Override
            public boolean test(GetCrossConnectResponse response) {
                return targetStatesSet.contains((Object)response.getCrossConnect().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)CrossConnect.LifecycleState.Terminated)), (Object)request);
    }

    public Waiter<GetCrossConnectGroupRequest, GetCrossConnectGroupResponse> forCrossConnectGroup(GetCrossConnectGroupRequest request, CrossConnectGroup.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forCrossConnectGroup(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetCrossConnectGroupRequest, GetCrossConnectGroupResponse> forCrossConnectGroup(GetCrossConnectGroupRequest request, CrossConnectGroup.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forCrossConnectGroup(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetCrossConnectGroupRequest, GetCrossConnectGroupResponse> forCrossConnectGroup(GetCrossConnectGroupRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, CrossConnectGroup.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forCrossConnectGroup(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetCrossConnectGroupRequest, GetCrossConnectGroupResponse> forCrossConnectGroup(BmcGenericWaiter waiter, GetCrossConnectGroupRequest request, CrossConnectGroup.LifecycleState ... targetStates) {
        final HashSet<CrossConnectGroup.LifecycleState> targetStatesSet = new HashSet<CrossConnectGroup.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetCrossConnectGroupRequest, GetCrossConnectGroupResponse>(){

            @Override
            public GetCrossConnectGroupResponse apply(GetCrossConnectGroupRequest request) {
                return VirtualNetworkWaiters.this.client.getCrossConnectGroup(request);
            }
        }, (Predicate)new Predicate<GetCrossConnectGroupResponse>(){

            @Override
            public boolean test(GetCrossConnectGroupResponse response) {
                return targetStatesSet.contains((Object)response.getCrossConnectGroup().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)CrossConnectGroup.LifecycleState.Terminated)), (Object)request);
    }

    public Waiter<GetDhcpOptionsRequest, GetDhcpOptionsResponse> forDhcpOptions(GetDhcpOptionsRequest request, DhcpOptions.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forDhcpOptions(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetDhcpOptionsRequest, GetDhcpOptionsResponse> forDhcpOptions(GetDhcpOptionsRequest request, DhcpOptions.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forDhcpOptions(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetDhcpOptionsRequest, GetDhcpOptionsResponse> forDhcpOptions(GetDhcpOptionsRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, DhcpOptions.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forDhcpOptions(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetDhcpOptionsRequest, GetDhcpOptionsResponse> forDhcpOptions(BmcGenericWaiter waiter, GetDhcpOptionsRequest request, DhcpOptions.LifecycleState ... targetStates) {
        final HashSet<DhcpOptions.LifecycleState> targetStatesSet = new HashSet<DhcpOptions.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetDhcpOptionsRequest, GetDhcpOptionsResponse>(){

            @Override
            public GetDhcpOptionsResponse apply(GetDhcpOptionsRequest request) {
                return VirtualNetworkWaiters.this.client.getDhcpOptions(request);
            }
        }, (Predicate)new Predicate<GetDhcpOptionsResponse>(){

            @Override
            public boolean test(GetDhcpOptionsResponse response) {
                return targetStatesSet.contains((Object)response.getDhcpOptions().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)DhcpOptions.LifecycleState.Terminated)), (Object)request);
    }

    public Waiter<GetDrgRequest, GetDrgResponse> forDrg(GetDrgRequest request, Drg.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forDrg(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetDrgRequest, GetDrgResponse> forDrg(GetDrgRequest request, Drg.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forDrg(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetDrgRequest, GetDrgResponse> forDrg(GetDrgRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, Drg.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forDrg(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetDrgRequest, GetDrgResponse> forDrg(BmcGenericWaiter waiter, GetDrgRequest request, Drg.LifecycleState ... targetStates) {
        final HashSet<Drg.LifecycleState> targetStatesSet = new HashSet<Drg.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetDrgRequest, GetDrgResponse>(){

            @Override
            public GetDrgResponse apply(GetDrgRequest request) {
                return VirtualNetworkWaiters.this.client.getDrg(request);
            }
        }, (Predicate)new Predicate<GetDrgResponse>(){

            @Override
            public boolean test(GetDrgResponse response) {
                return targetStatesSet.contains((Object)response.getDrg().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)Drg.LifecycleState.Terminated)), (Object)request);
    }

    public Waiter<GetDrgAttachmentRequest, GetDrgAttachmentResponse> forDrgAttachment(GetDrgAttachmentRequest request, DrgAttachment.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forDrgAttachment(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetDrgAttachmentRequest, GetDrgAttachmentResponse> forDrgAttachment(GetDrgAttachmentRequest request, DrgAttachment.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forDrgAttachment(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetDrgAttachmentRequest, GetDrgAttachmentResponse> forDrgAttachment(GetDrgAttachmentRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, DrgAttachment.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forDrgAttachment(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetDrgAttachmentRequest, GetDrgAttachmentResponse> forDrgAttachment(BmcGenericWaiter waiter, GetDrgAttachmentRequest request, DrgAttachment.LifecycleState ... targetStates) {
        final HashSet<DrgAttachment.LifecycleState> targetStatesSet = new HashSet<DrgAttachment.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetDrgAttachmentRequest, GetDrgAttachmentResponse>(){

            @Override
            public GetDrgAttachmentResponse apply(GetDrgAttachmentRequest request) {
                return VirtualNetworkWaiters.this.client.getDrgAttachment(request);
            }
        }, (Predicate)new Predicate<GetDrgAttachmentResponse>(){

            @Override
            public boolean test(GetDrgAttachmentResponse response) {
                return targetStatesSet.contains((Object)response.getDrgAttachment().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)DrgAttachment.LifecycleState.Detached)), (Object)request);
    }

    public Waiter<GetDrgRouteDistributionRequest, GetDrgRouteDistributionResponse> forDrgRouteDistribution(GetDrgRouteDistributionRequest request, DrgRouteDistribution.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forDrgRouteDistribution(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetDrgRouteDistributionRequest, GetDrgRouteDistributionResponse> forDrgRouteDistribution(GetDrgRouteDistributionRequest request, DrgRouteDistribution.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forDrgRouteDistribution(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetDrgRouteDistributionRequest, GetDrgRouteDistributionResponse> forDrgRouteDistribution(GetDrgRouteDistributionRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, DrgRouteDistribution.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forDrgRouteDistribution(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetDrgRouteDistributionRequest, GetDrgRouteDistributionResponse> forDrgRouteDistribution(BmcGenericWaiter waiter, GetDrgRouteDistributionRequest request, DrgRouteDistribution.LifecycleState ... targetStates) {
        final HashSet<DrgRouteDistribution.LifecycleState> targetStatesSet = new HashSet<DrgRouteDistribution.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetDrgRouteDistributionRequest, GetDrgRouteDistributionResponse>(){

            @Override
            public GetDrgRouteDistributionResponse apply(GetDrgRouteDistributionRequest request) {
                return VirtualNetworkWaiters.this.client.getDrgRouteDistribution(request);
            }
        }, (Predicate)new Predicate<GetDrgRouteDistributionResponse>(){

            @Override
            public boolean test(GetDrgRouteDistributionResponse response) {
                return targetStatesSet.contains((Object)response.getDrgRouteDistribution().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)DrgRouteDistribution.LifecycleState.Terminated)), (Object)request);
    }

    public Waiter<GetDrgRouteTableRequest, GetDrgRouteTableResponse> forDrgRouteTable(GetDrgRouteTableRequest request, DrgRouteTable.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forDrgRouteTable(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetDrgRouteTableRequest, GetDrgRouteTableResponse> forDrgRouteTable(GetDrgRouteTableRequest request, DrgRouteTable.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forDrgRouteTable(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetDrgRouteTableRequest, GetDrgRouteTableResponse> forDrgRouteTable(GetDrgRouteTableRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, DrgRouteTable.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forDrgRouteTable(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetDrgRouteTableRequest, GetDrgRouteTableResponse> forDrgRouteTable(BmcGenericWaiter waiter, GetDrgRouteTableRequest request, DrgRouteTable.LifecycleState ... targetStates) {
        final HashSet<DrgRouteTable.LifecycleState> targetStatesSet = new HashSet<DrgRouteTable.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetDrgRouteTableRequest, GetDrgRouteTableResponse>(){

            @Override
            public GetDrgRouteTableResponse apply(GetDrgRouteTableRequest request) {
                return VirtualNetworkWaiters.this.client.getDrgRouteTable(request);
            }
        }, (Predicate)new Predicate<GetDrgRouteTableResponse>(){

            @Override
            public boolean test(GetDrgRouteTableResponse response) {
                return targetStatesSet.contains((Object)response.getDrgRouteTable().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)DrgRouteTable.LifecycleState.Terminated)), (Object)request);
    }

    public Waiter<GetIPSecConnectionRequest, GetIPSecConnectionResponse> forIPSecConnection(GetIPSecConnectionRequest request, IPSecConnection.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forIPSecConnection(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetIPSecConnectionRequest, GetIPSecConnectionResponse> forIPSecConnection(GetIPSecConnectionRequest request, IPSecConnection.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forIPSecConnection(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetIPSecConnectionRequest, GetIPSecConnectionResponse> forIPSecConnection(GetIPSecConnectionRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, IPSecConnection.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forIPSecConnection(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetIPSecConnectionRequest, GetIPSecConnectionResponse> forIPSecConnection(BmcGenericWaiter waiter, GetIPSecConnectionRequest request, IPSecConnection.LifecycleState ... targetStates) {
        final HashSet<IPSecConnection.LifecycleState> targetStatesSet = new HashSet<IPSecConnection.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetIPSecConnectionRequest, GetIPSecConnectionResponse>(){

            @Override
            public GetIPSecConnectionResponse apply(GetIPSecConnectionRequest request) {
                return VirtualNetworkWaiters.this.client.getIPSecConnection(request);
            }
        }, (Predicate)new Predicate<GetIPSecConnectionResponse>(){

            @Override
            public boolean test(GetIPSecConnectionResponse response) {
                return targetStatesSet.contains((Object)response.getIPSecConnection().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)IPSecConnection.LifecycleState.Terminated)), (Object)request);
    }

    public Waiter<GetIPSecConnectionTunnelRequest, GetIPSecConnectionTunnelResponse> forIPSecConnectionTunnel(GetIPSecConnectionTunnelRequest request, IPSecConnectionTunnel.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forIPSecConnectionTunnel(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetIPSecConnectionTunnelRequest, GetIPSecConnectionTunnelResponse> forIPSecConnectionTunnel(GetIPSecConnectionTunnelRequest request, IPSecConnectionTunnel.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forIPSecConnectionTunnel(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetIPSecConnectionTunnelRequest, GetIPSecConnectionTunnelResponse> forIPSecConnectionTunnel(GetIPSecConnectionTunnelRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, IPSecConnectionTunnel.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forIPSecConnectionTunnel(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetIPSecConnectionTunnelRequest, GetIPSecConnectionTunnelResponse> forIPSecConnectionTunnel(BmcGenericWaiter waiter, GetIPSecConnectionTunnelRequest request, IPSecConnectionTunnel.LifecycleState ... targetStates) {
        final HashSet<IPSecConnectionTunnel.LifecycleState> targetStatesSet = new HashSet<IPSecConnectionTunnel.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetIPSecConnectionTunnelRequest, GetIPSecConnectionTunnelResponse>(){

            @Override
            public GetIPSecConnectionTunnelResponse apply(GetIPSecConnectionTunnelRequest request) {
                return VirtualNetworkWaiters.this.client.getIPSecConnectionTunnel(request);
            }
        }, (Predicate)new Predicate<GetIPSecConnectionTunnelResponse>(){

            @Override
            public boolean test(GetIPSecConnectionTunnelResponse response) {
                return targetStatesSet.contains((Object)response.getIPSecConnectionTunnel().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)IPSecConnectionTunnel.LifecycleState.Terminated)), (Object)request);
    }

    public Waiter<GetInternetGatewayRequest, GetInternetGatewayResponse> forInternetGateway(GetInternetGatewayRequest request, InternetGateway.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forInternetGateway(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetInternetGatewayRequest, GetInternetGatewayResponse> forInternetGateway(GetInternetGatewayRequest request, InternetGateway.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forInternetGateway(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetInternetGatewayRequest, GetInternetGatewayResponse> forInternetGateway(GetInternetGatewayRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, InternetGateway.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forInternetGateway(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetInternetGatewayRequest, GetInternetGatewayResponse> forInternetGateway(BmcGenericWaiter waiter, GetInternetGatewayRequest request, InternetGateway.LifecycleState ... targetStates) {
        final HashSet<InternetGateway.LifecycleState> targetStatesSet = new HashSet<InternetGateway.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetInternetGatewayRequest, GetInternetGatewayResponse>(){

            @Override
            public GetInternetGatewayResponse apply(GetInternetGatewayRequest request) {
                return VirtualNetworkWaiters.this.client.getInternetGateway(request);
            }
        }, (Predicate)new Predicate<GetInternetGatewayResponse>(){

            @Override
            public boolean test(GetInternetGatewayResponse response) {
                return targetStatesSet.contains((Object)response.getInternetGateway().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)InternetGateway.LifecycleState.Terminated)), (Object)request);
    }

    public Waiter<GetIpv6Request, GetIpv6Response> forIpv6(GetIpv6Request request, Ipv6.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forIpv6(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetIpv6Request, GetIpv6Response> forIpv6(GetIpv6Request request, Ipv6.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forIpv6(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetIpv6Request, GetIpv6Response> forIpv6(GetIpv6Request request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, Ipv6.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forIpv6(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetIpv6Request, GetIpv6Response> forIpv6(BmcGenericWaiter waiter, GetIpv6Request request, Ipv6.LifecycleState ... targetStates) {
        final HashSet<Ipv6.LifecycleState> targetStatesSet = new HashSet<Ipv6.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetIpv6Request, GetIpv6Response>(){

            @Override
            public GetIpv6Response apply(GetIpv6Request request) {
                return VirtualNetworkWaiters.this.client.getIpv6(request);
            }
        }, (Predicate)new Predicate<GetIpv6Response>(){

            @Override
            public boolean test(GetIpv6Response response) {
                return targetStatesSet.contains((Object)response.getIpv6().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)Ipv6.LifecycleState.Terminated)), (Object)request);
    }

    public Waiter<GetLocalPeeringGatewayRequest, GetLocalPeeringGatewayResponse> forLocalPeeringGateway(GetLocalPeeringGatewayRequest request, LocalPeeringGateway.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forLocalPeeringGateway(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetLocalPeeringGatewayRequest, GetLocalPeeringGatewayResponse> forLocalPeeringGateway(GetLocalPeeringGatewayRequest request, LocalPeeringGateway.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forLocalPeeringGateway(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetLocalPeeringGatewayRequest, GetLocalPeeringGatewayResponse> forLocalPeeringGateway(GetLocalPeeringGatewayRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, LocalPeeringGateway.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forLocalPeeringGateway(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetLocalPeeringGatewayRequest, GetLocalPeeringGatewayResponse> forLocalPeeringGateway(BmcGenericWaiter waiter, GetLocalPeeringGatewayRequest request, LocalPeeringGateway.LifecycleState ... targetStates) {
        final HashSet<LocalPeeringGateway.LifecycleState> targetStatesSet = new HashSet<LocalPeeringGateway.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetLocalPeeringGatewayRequest, GetLocalPeeringGatewayResponse>(){

            @Override
            public GetLocalPeeringGatewayResponse apply(GetLocalPeeringGatewayRequest request) {
                return VirtualNetworkWaiters.this.client.getLocalPeeringGateway(request);
            }
        }, (Predicate)new Predicate<GetLocalPeeringGatewayResponse>(){

            @Override
            public boolean test(GetLocalPeeringGatewayResponse response) {
                return targetStatesSet.contains((Object)response.getLocalPeeringGateway().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)LocalPeeringGateway.LifecycleState.Terminated)), (Object)request);
    }

    public Waiter<GetLocalPeeringGatewayRequest, GetLocalPeeringGatewayResponse> forLocalPeeringGateway(GetLocalPeeringGatewayRequest request, LocalPeeringGateway.PeeringStatus ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forLocalPeeringGateway(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetLocalPeeringGatewayRequest, GetLocalPeeringGatewayResponse> forLocalPeeringGateway(GetLocalPeeringGatewayRequest request, LocalPeeringGateway.PeeringStatus targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forLocalPeeringGateway(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetLocalPeeringGatewayRequest, GetLocalPeeringGatewayResponse> forLocalPeeringGateway(GetLocalPeeringGatewayRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, LocalPeeringGateway.PeeringStatus ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forLocalPeeringGateway(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetLocalPeeringGatewayRequest, GetLocalPeeringGatewayResponse> forLocalPeeringGateway(BmcGenericWaiter waiter, GetLocalPeeringGatewayRequest request, LocalPeeringGateway.PeeringStatus ... targetStates) {
        final HashSet<LocalPeeringGateway.PeeringStatus> targetStatesSet = new HashSet<LocalPeeringGateway.PeeringStatus>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetLocalPeeringGatewayRequest, GetLocalPeeringGatewayResponse>(){

            @Override
            public GetLocalPeeringGatewayResponse apply(GetLocalPeeringGatewayRequest request) {
                return VirtualNetworkWaiters.this.client.getLocalPeeringGateway(request);
            }
        }, (Predicate)new Predicate<GetLocalPeeringGatewayResponse>(){

            @Override
            public boolean test(GetLocalPeeringGatewayResponse response) {
                return targetStatesSet.contains((Object)response.getLocalPeeringGateway().getPeeringStatus());
            }
        }, targetStatesSet.contains((Object)LocalPeeringGateway.PeeringStatus.Revoked)), (Object)request);
    }

    public Waiter<GetNatGatewayRequest, GetNatGatewayResponse> forNatGateway(GetNatGatewayRequest request, NatGateway.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forNatGateway(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetNatGatewayRequest, GetNatGatewayResponse> forNatGateway(GetNatGatewayRequest request, NatGateway.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forNatGateway(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetNatGatewayRequest, GetNatGatewayResponse> forNatGateway(GetNatGatewayRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, NatGateway.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forNatGateway(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetNatGatewayRequest, GetNatGatewayResponse> forNatGateway(BmcGenericWaiter waiter, GetNatGatewayRequest request, NatGateway.LifecycleState ... targetStates) {
        final HashSet<NatGateway.LifecycleState> targetStatesSet = new HashSet<NatGateway.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetNatGatewayRequest, GetNatGatewayResponse>(){

            @Override
            public GetNatGatewayResponse apply(GetNatGatewayRequest request) {
                return VirtualNetworkWaiters.this.client.getNatGateway(request);
            }
        }, (Predicate)new Predicate<GetNatGatewayResponse>(){

            @Override
            public boolean test(GetNatGatewayResponse response) {
                return targetStatesSet.contains((Object)response.getNatGateway().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)NatGateway.LifecycleState.Terminated)), (Object)request);
    }

    public Waiter<GetNetworkSecurityGroupRequest, GetNetworkSecurityGroupResponse> forNetworkSecurityGroup(GetNetworkSecurityGroupRequest request, NetworkSecurityGroup.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forNetworkSecurityGroup(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetNetworkSecurityGroupRequest, GetNetworkSecurityGroupResponse> forNetworkSecurityGroup(GetNetworkSecurityGroupRequest request, NetworkSecurityGroup.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forNetworkSecurityGroup(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetNetworkSecurityGroupRequest, GetNetworkSecurityGroupResponse> forNetworkSecurityGroup(GetNetworkSecurityGroupRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, NetworkSecurityGroup.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forNetworkSecurityGroup(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetNetworkSecurityGroupRequest, GetNetworkSecurityGroupResponse> forNetworkSecurityGroup(BmcGenericWaiter waiter, GetNetworkSecurityGroupRequest request, NetworkSecurityGroup.LifecycleState ... targetStates) {
        final HashSet<NetworkSecurityGroup.LifecycleState> targetStatesSet = new HashSet<NetworkSecurityGroup.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetNetworkSecurityGroupRequest, GetNetworkSecurityGroupResponse>(){

            @Override
            public GetNetworkSecurityGroupResponse apply(GetNetworkSecurityGroupRequest request) {
                return VirtualNetworkWaiters.this.client.getNetworkSecurityGroup(request);
            }
        }, (Predicate)new Predicate<GetNetworkSecurityGroupResponse>(){

            @Override
            public boolean test(GetNetworkSecurityGroupResponse response) {
                return targetStatesSet.contains((Object)response.getNetworkSecurityGroup().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)NetworkSecurityGroup.LifecycleState.Terminated)), (Object)request);
    }

    public Waiter<GetPublicIpRequest, GetPublicIpResponse> forPublicIp(GetPublicIpRequest request, PublicIp.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forPublicIp(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetPublicIpRequest, GetPublicIpResponse> forPublicIp(GetPublicIpRequest request, PublicIp.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forPublicIp(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetPublicIpRequest, GetPublicIpResponse> forPublicIp(GetPublicIpRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, PublicIp.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forPublicIp(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetPublicIpRequest, GetPublicIpResponse> forPublicIp(BmcGenericWaiter waiter, GetPublicIpRequest request, PublicIp.LifecycleState ... targetStates) {
        final HashSet<PublicIp.LifecycleState> targetStatesSet = new HashSet<PublicIp.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetPublicIpRequest, GetPublicIpResponse>(){

            @Override
            public GetPublicIpResponse apply(GetPublicIpRequest request) {
                return VirtualNetworkWaiters.this.client.getPublicIp(request);
            }
        }, (Predicate)new Predicate<GetPublicIpResponse>(){

            @Override
            public boolean test(GetPublicIpResponse response) {
                return targetStatesSet.contains((Object)response.getPublicIp().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)PublicIp.LifecycleState.Terminated)), (Object)request);
    }

    public Waiter<GetPublicIpPoolRequest, GetPublicIpPoolResponse> forPublicIpPool(GetPublicIpPoolRequest request, PublicIpPool.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forPublicIpPool(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetPublicIpPoolRequest, GetPublicIpPoolResponse> forPublicIpPool(GetPublicIpPoolRequest request, PublicIpPool.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forPublicIpPool(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetPublicIpPoolRequest, GetPublicIpPoolResponse> forPublicIpPool(GetPublicIpPoolRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, PublicIpPool.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forPublicIpPool(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetPublicIpPoolRequest, GetPublicIpPoolResponse> forPublicIpPool(BmcGenericWaiter waiter, GetPublicIpPoolRequest request, PublicIpPool.LifecycleState ... targetStates) {
        final HashSet<PublicIpPool.LifecycleState> targetStatesSet = new HashSet<PublicIpPool.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetPublicIpPoolRequest, GetPublicIpPoolResponse>(){

            @Override
            public GetPublicIpPoolResponse apply(GetPublicIpPoolRequest request) {
                return VirtualNetworkWaiters.this.client.getPublicIpPool(request);
            }
        }, (Predicate)new Predicate<GetPublicIpPoolResponse>(){

            @Override
            public boolean test(GetPublicIpPoolResponse response) {
                return targetStatesSet.contains((Object)response.getPublicIpPool().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)PublicIpPool.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetRemotePeeringConnectionRequest, GetRemotePeeringConnectionResponse> forRemotePeeringConnection(GetRemotePeeringConnectionRequest request, RemotePeeringConnection.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forRemotePeeringConnection(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetRemotePeeringConnectionRequest, GetRemotePeeringConnectionResponse> forRemotePeeringConnection(GetRemotePeeringConnectionRequest request, RemotePeeringConnection.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forRemotePeeringConnection(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetRemotePeeringConnectionRequest, GetRemotePeeringConnectionResponse> forRemotePeeringConnection(GetRemotePeeringConnectionRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, RemotePeeringConnection.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forRemotePeeringConnection(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetRemotePeeringConnectionRequest, GetRemotePeeringConnectionResponse> forRemotePeeringConnection(BmcGenericWaiter waiter, GetRemotePeeringConnectionRequest request, RemotePeeringConnection.LifecycleState ... targetStates) {
        final HashSet<RemotePeeringConnection.LifecycleState> targetStatesSet = new HashSet<RemotePeeringConnection.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetRemotePeeringConnectionRequest, GetRemotePeeringConnectionResponse>(){

            @Override
            public GetRemotePeeringConnectionResponse apply(GetRemotePeeringConnectionRequest request) {
                return VirtualNetworkWaiters.this.client.getRemotePeeringConnection(request);
            }
        }, (Predicate)new Predicate<GetRemotePeeringConnectionResponse>(){

            @Override
            public boolean test(GetRemotePeeringConnectionResponse response) {
                return targetStatesSet.contains((Object)response.getRemotePeeringConnection().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)RemotePeeringConnection.LifecycleState.Terminated)), (Object)request);
    }

    public Waiter<GetRemotePeeringConnectionRequest, GetRemotePeeringConnectionResponse> forRemotePeeringConnection(GetRemotePeeringConnectionRequest request, RemotePeeringConnection.PeeringStatus ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forRemotePeeringConnection(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetRemotePeeringConnectionRequest, GetRemotePeeringConnectionResponse> forRemotePeeringConnection(GetRemotePeeringConnectionRequest request, RemotePeeringConnection.PeeringStatus targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forRemotePeeringConnection(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetRemotePeeringConnectionRequest, GetRemotePeeringConnectionResponse> forRemotePeeringConnection(GetRemotePeeringConnectionRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, RemotePeeringConnection.PeeringStatus ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forRemotePeeringConnection(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetRemotePeeringConnectionRequest, GetRemotePeeringConnectionResponse> forRemotePeeringConnection(BmcGenericWaiter waiter, GetRemotePeeringConnectionRequest request, RemotePeeringConnection.PeeringStatus ... targetStates) {
        final HashSet<RemotePeeringConnection.PeeringStatus> targetStatesSet = new HashSet<RemotePeeringConnection.PeeringStatus>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetRemotePeeringConnectionRequest, GetRemotePeeringConnectionResponse>(){

            @Override
            public GetRemotePeeringConnectionResponse apply(GetRemotePeeringConnectionRequest request) {
                return VirtualNetworkWaiters.this.client.getRemotePeeringConnection(request);
            }
        }, (Predicate)new Predicate<GetRemotePeeringConnectionResponse>(){

            @Override
            public boolean test(GetRemotePeeringConnectionResponse response) {
                return targetStatesSet.contains((Object)response.getRemotePeeringConnection().getPeeringStatus());
            }
        }, targetStatesSet.contains((Object)RemotePeeringConnection.PeeringStatus.Revoked)), (Object)request);
    }

    public Waiter<GetRouteTableRequest, GetRouteTableResponse> forRouteTable(GetRouteTableRequest request, RouteTable.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forRouteTable(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetRouteTableRequest, GetRouteTableResponse> forRouteTable(GetRouteTableRequest request, RouteTable.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forRouteTable(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetRouteTableRequest, GetRouteTableResponse> forRouteTable(GetRouteTableRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, RouteTable.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forRouteTable(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetRouteTableRequest, GetRouteTableResponse> forRouteTable(BmcGenericWaiter waiter, GetRouteTableRequest request, RouteTable.LifecycleState ... targetStates) {
        final HashSet<RouteTable.LifecycleState> targetStatesSet = new HashSet<RouteTable.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetRouteTableRequest, GetRouteTableResponse>(){

            @Override
            public GetRouteTableResponse apply(GetRouteTableRequest request) {
                return VirtualNetworkWaiters.this.client.getRouteTable(request);
            }
        }, (Predicate)new Predicate<GetRouteTableResponse>(){

            @Override
            public boolean test(GetRouteTableResponse response) {
                return targetStatesSet.contains((Object)response.getRouteTable().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)RouteTable.LifecycleState.Terminated)), (Object)request);
    }

    public Waiter<GetSecurityListRequest, GetSecurityListResponse> forSecurityList(GetSecurityListRequest request, SecurityList.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forSecurityList(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetSecurityListRequest, GetSecurityListResponse> forSecurityList(GetSecurityListRequest request, SecurityList.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forSecurityList(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetSecurityListRequest, GetSecurityListResponse> forSecurityList(GetSecurityListRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, SecurityList.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forSecurityList(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetSecurityListRequest, GetSecurityListResponse> forSecurityList(BmcGenericWaiter waiter, GetSecurityListRequest request, SecurityList.LifecycleState ... targetStates) {
        final HashSet<SecurityList.LifecycleState> targetStatesSet = new HashSet<SecurityList.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetSecurityListRequest, GetSecurityListResponse>(){

            @Override
            public GetSecurityListResponse apply(GetSecurityListRequest request) {
                return VirtualNetworkWaiters.this.client.getSecurityList(request);
            }
        }, (Predicate)new Predicate<GetSecurityListResponse>(){

            @Override
            public boolean test(GetSecurityListResponse response) {
                return targetStatesSet.contains((Object)response.getSecurityList().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)SecurityList.LifecycleState.Terminated)), (Object)request);
    }

    public Waiter<GetServiceGatewayRequest, GetServiceGatewayResponse> forServiceGateway(GetServiceGatewayRequest request, ServiceGateway.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forServiceGateway(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetServiceGatewayRequest, GetServiceGatewayResponse> forServiceGateway(GetServiceGatewayRequest request, ServiceGateway.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forServiceGateway(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetServiceGatewayRequest, GetServiceGatewayResponse> forServiceGateway(GetServiceGatewayRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, ServiceGateway.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forServiceGateway(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetServiceGatewayRequest, GetServiceGatewayResponse> forServiceGateway(BmcGenericWaiter waiter, GetServiceGatewayRequest request, ServiceGateway.LifecycleState ... targetStates) {
        final HashSet<ServiceGateway.LifecycleState> targetStatesSet = new HashSet<ServiceGateway.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetServiceGatewayRequest, GetServiceGatewayResponse>(){

            @Override
            public GetServiceGatewayResponse apply(GetServiceGatewayRequest request) {
                return VirtualNetworkWaiters.this.client.getServiceGateway(request);
            }
        }, (Predicate)new Predicate<GetServiceGatewayResponse>(){

            @Override
            public boolean test(GetServiceGatewayResponse response) {
                return targetStatesSet.contains((Object)response.getServiceGateway().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)ServiceGateway.LifecycleState.Terminated)), (Object)request);
    }

    public Waiter<GetSubnetRequest, GetSubnetResponse> forSubnet(GetSubnetRequest request, Subnet.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forSubnet(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetSubnetRequest, GetSubnetResponse> forSubnet(GetSubnetRequest request, Subnet.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forSubnet(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetSubnetRequest, GetSubnetResponse> forSubnet(GetSubnetRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, Subnet.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forSubnet(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetSubnetRequest, GetSubnetResponse> forSubnet(BmcGenericWaiter waiter, GetSubnetRequest request, Subnet.LifecycleState ... targetStates) {
        final HashSet<Subnet.LifecycleState> targetStatesSet = new HashSet<Subnet.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetSubnetRequest, GetSubnetResponse>(){

            @Override
            public GetSubnetResponse apply(GetSubnetRequest request) {
                return VirtualNetworkWaiters.this.client.getSubnet(request);
            }
        }, (Predicate)new Predicate<GetSubnetResponse>(){

            @Override
            public boolean test(GetSubnetResponse response) {
                return targetStatesSet.contains((Object)response.getSubnet().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)Subnet.LifecycleState.Terminated)), (Object)request);
    }

    public Waiter<GetVcnRequest, GetVcnResponse> forVcn(GetVcnRequest request, Vcn.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forVcn(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetVcnRequest, GetVcnResponse> forVcn(GetVcnRequest request, Vcn.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forVcn(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetVcnRequest, GetVcnResponse> forVcn(GetVcnRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, Vcn.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forVcn(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetVcnRequest, GetVcnResponse> forVcn(BmcGenericWaiter waiter, GetVcnRequest request, Vcn.LifecycleState ... targetStates) {
        final HashSet<Vcn.LifecycleState> targetStatesSet = new HashSet<Vcn.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetVcnRequest, GetVcnResponse>(){

            @Override
            public GetVcnResponse apply(GetVcnRequest request) {
                return VirtualNetworkWaiters.this.client.getVcn(request);
            }
        }, (Predicate)new Predicate<GetVcnResponse>(){

            @Override
            public boolean test(GetVcnResponse response) {
                return targetStatesSet.contains((Object)response.getVcn().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)Vcn.LifecycleState.Terminated)), (Object)request);
    }

    public Waiter<GetVcnDnsResolverAssociationRequest, GetVcnDnsResolverAssociationResponse> forVcnDnsResolverAssociation(GetVcnDnsResolverAssociationRequest request, VcnDnsResolverAssociation.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forVcnDnsResolverAssociation(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetVcnDnsResolverAssociationRequest, GetVcnDnsResolverAssociationResponse> forVcnDnsResolverAssociation(GetVcnDnsResolverAssociationRequest request, VcnDnsResolverAssociation.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forVcnDnsResolverAssociation(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetVcnDnsResolverAssociationRequest, GetVcnDnsResolverAssociationResponse> forVcnDnsResolverAssociation(GetVcnDnsResolverAssociationRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, VcnDnsResolverAssociation.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forVcnDnsResolverAssociation(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetVcnDnsResolverAssociationRequest, GetVcnDnsResolverAssociationResponse> forVcnDnsResolverAssociation(BmcGenericWaiter waiter, GetVcnDnsResolverAssociationRequest request, VcnDnsResolverAssociation.LifecycleState ... targetStates) {
        final HashSet<VcnDnsResolverAssociation.LifecycleState> targetStatesSet = new HashSet<VcnDnsResolverAssociation.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetVcnDnsResolverAssociationRequest, GetVcnDnsResolverAssociationResponse>(){

            @Override
            public GetVcnDnsResolverAssociationResponse apply(GetVcnDnsResolverAssociationRequest request) {
                return VirtualNetworkWaiters.this.client.getVcnDnsResolverAssociation(request);
            }
        }, (Predicate)new Predicate<GetVcnDnsResolverAssociationResponse>(){

            @Override
            public boolean test(GetVcnDnsResolverAssociationResponse response) {
                return targetStatesSet.contains((Object)response.getVcnDnsResolverAssociation().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)VcnDnsResolverAssociation.LifecycleState.Terminated)), (Object)request);
    }

    public Waiter<GetVirtualCircuitRequest, GetVirtualCircuitResponse> forVirtualCircuit(GetVirtualCircuitRequest request, VirtualCircuit.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forVirtualCircuit(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetVirtualCircuitRequest, GetVirtualCircuitResponse> forVirtualCircuit(GetVirtualCircuitRequest request, VirtualCircuit.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forVirtualCircuit(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetVirtualCircuitRequest, GetVirtualCircuitResponse> forVirtualCircuit(GetVirtualCircuitRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, VirtualCircuit.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forVirtualCircuit(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetVirtualCircuitRequest, GetVirtualCircuitResponse> forVirtualCircuit(BmcGenericWaiter waiter, GetVirtualCircuitRequest request, VirtualCircuit.LifecycleState ... targetStates) {
        final HashSet<VirtualCircuit.LifecycleState> targetStatesSet = new HashSet<VirtualCircuit.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetVirtualCircuitRequest, GetVirtualCircuitResponse>(){

            @Override
            public GetVirtualCircuitResponse apply(GetVirtualCircuitRequest request) {
                return VirtualNetworkWaiters.this.client.getVirtualCircuit(request);
            }
        }, (Predicate)new Predicate<GetVirtualCircuitResponse>(){

            @Override
            public boolean test(GetVirtualCircuitResponse response) {
                return targetStatesSet.contains((Object)response.getVirtualCircuit().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)VirtualCircuit.LifecycleState.Terminated)), (Object)request);
    }

    public Waiter<GetVlanRequest, GetVlanResponse> forVlan(GetVlanRequest request, Vlan.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forVlan(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetVlanRequest, GetVlanResponse> forVlan(GetVlanRequest request, Vlan.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forVlan(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetVlanRequest, GetVlanResponse> forVlan(GetVlanRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, Vlan.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forVlan(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetVlanRequest, GetVlanResponse> forVlan(BmcGenericWaiter waiter, GetVlanRequest request, Vlan.LifecycleState ... targetStates) {
        final HashSet<Vlan.LifecycleState> targetStatesSet = new HashSet<Vlan.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetVlanRequest, GetVlanResponse>(){

            @Override
            public GetVlanResponse apply(GetVlanRequest request) {
                return VirtualNetworkWaiters.this.client.getVlan(request);
            }
        }, (Predicate)new Predicate<GetVlanResponse>(){

            @Override
            public boolean test(GetVlanResponse response) {
                return targetStatesSet.contains((Object)response.getVlan().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)Vlan.LifecycleState.Terminated)), (Object)request);
    }

    public Waiter<GetVnicRequest, GetVnicResponse> forVnic(GetVnicRequest request, Vnic.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forVnic(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetVnicRequest, GetVnicResponse> forVnic(GetVnicRequest request, Vnic.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forVnic(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetVnicRequest, GetVnicResponse> forVnic(GetVnicRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, Vnic.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forVnic(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetVnicRequest, GetVnicResponse> forVnic(BmcGenericWaiter waiter, GetVnicRequest request, Vnic.LifecycleState ... targetStates) {
        final HashSet<Vnic.LifecycleState> targetStatesSet = new HashSet<Vnic.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetVnicRequest, GetVnicResponse>(){

            @Override
            public GetVnicResponse apply(GetVnicRequest request) {
                return VirtualNetworkWaiters.this.client.getVnic(request);
            }
        }, (Predicate)new Predicate<GetVnicResponse>(){

            @Override
            public boolean test(GetVnicResponse response) {
                return targetStatesSet.contains((Object)response.getVnic().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)Vnic.LifecycleState.Terminated)), (Object)request);
    }

    public Waiter<GetVtapRequest, GetVtapResponse> forVtap(GetVtapRequest request, Vtap.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forVtap(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetVtapRequest, GetVtapResponse> forVtap(GetVtapRequest request, Vtap.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forVtap(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetVtapRequest, GetVtapResponse> forVtap(GetVtapRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, Vtap.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forVtap(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetVtapRequest, GetVtapResponse> forVtap(BmcGenericWaiter waiter, GetVtapRequest request, Vtap.LifecycleState ... targetStates) {
        final HashSet<Vtap.LifecycleState> targetStatesSet = new HashSet<Vtap.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetVtapRequest, GetVtapResponse>(){

            @Override
            public GetVtapResponse apply(GetVtapRequest request) {
                return VirtualNetworkWaiters.this.client.getVtap(request);
            }
        }, (Predicate)new Predicate<GetVtapResponse>(){

            @Override
            public boolean test(GetVtapResponse response) {
                return targetStatesSet.contains((Object)response.getVtap().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)Vtap.LifecycleState.Terminated)), (Object)request);
    }

    public Waiter<ModifyVcnCidrRequest, ModifyVcnCidrResponse> forModifyVcnCidr(ModifyVcnCidrRequest request) {
        return this.forModifyVcnCidr(request, Waiters.DEFAULT_POLLING_TERMINATION_STRATEGY, Waiters.DEFAULT_POLLING_DELAY_STRATEGY);
    }

    public Waiter<ModifyVcnCidrRequest, ModifyVcnCidrResponse> forModifyVcnCidr(final ModifyVcnCidrRequest request, final TerminationStrategy terminationStrategy, final DelayStrategy delayStrategy) {
        if (this.workRequestClient == null) {
            throw new IllegalStateException("A WorkRequestClient must be supplied to this waiter for this operation");
        }
        return new SimpleWaiterImpl(this.executorService, (Callable)new Callable<ModifyVcnCidrResponse>(){

            @Override
            public ModifyVcnCidrResponse call() throws Exception {
                ModifyVcnCidrResponse response = VirtualNetworkWaiters.this.client.modifyVcnCidr(request);
                GetWorkRequestRequest getWorkRequestRequest = GetWorkRequestRequest.builder().workRequestId(response.getOpcWorkRequestId()).build();
                VirtualNetworkWaiters.this.workRequestClient.getWaiters().forWorkRequest(getWorkRequestRequest, terminationStrategy, delayStrategy).execute();
                return response;
            }
        }, (Object)request);
    }

    public Waiter<RemoveIpv6SubnetCidrRequest, RemoveIpv6SubnetCidrResponse> forRemoveIpv6SubnetCidr(RemoveIpv6SubnetCidrRequest request) {
        return this.forRemoveIpv6SubnetCidr(request, Waiters.DEFAULT_POLLING_TERMINATION_STRATEGY, Waiters.DEFAULT_POLLING_DELAY_STRATEGY);
    }

    public Waiter<RemoveIpv6SubnetCidrRequest, RemoveIpv6SubnetCidrResponse> forRemoveIpv6SubnetCidr(final RemoveIpv6SubnetCidrRequest request, final TerminationStrategy terminationStrategy, final DelayStrategy delayStrategy) {
        if (this.workRequestClient == null) {
            throw new IllegalStateException("A WorkRequestClient must be supplied to this waiter for this operation");
        }
        return new SimpleWaiterImpl(this.executorService, (Callable)new Callable<RemoveIpv6SubnetCidrResponse>(){

            @Override
            public RemoveIpv6SubnetCidrResponse call() throws Exception {
                RemoveIpv6SubnetCidrResponse response = VirtualNetworkWaiters.this.client.removeIpv6SubnetCidr(request);
                GetWorkRequestRequest getWorkRequestRequest = GetWorkRequestRequest.builder().workRequestId(response.getOpcWorkRequestId()).build();
                VirtualNetworkWaiters.this.workRequestClient.getWaiters().forWorkRequest(getWorkRequestRequest, terminationStrategy, delayStrategy).execute();
                return response;
            }
        }, (Object)request);
    }

    public Waiter<RemoveIpv6VcnCidrRequest, RemoveIpv6VcnCidrResponse> forRemoveIpv6VcnCidr(RemoveIpv6VcnCidrRequest request) {
        return this.forRemoveIpv6VcnCidr(request, Waiters.DEFAULT_POLLING_TERMINATION_STRATEGY, Waiters.DEFAULT_POLLING_DELAY_STRATEGY);
    }

    public Waiter<RemoveIpv6VcnCidrRequest, RemoveIpv6VcnCidrResponse> forRemoveIpv6VcnCidr(final RemoveIpv6VcnCidrRequest request, final TerminationStrategy terminationStrategy, final DelayStrategy delayStrategy) {
        if (this.workRequestClient == null) {
            throw new IllegalStateException("A WorkRequestClient must be supplied to this waiter for this operation");
        }
        return new SimpleWaiterImpl(this.executorService, (Callable)new Callable<RemoveIpv6VcnCidrResponse>(){

            @Override
            public RemoveIpv6VcnCidrResponse call() throws Exception {
                RemoveIpv6VcnCidrResponse response = VirtualNetworkWaiters.this.client.removeIpv6VcnCidr(request);
                GetWorkRequestRequest getWorkRequestRequest = GetWorkRequestRequest.builder().workRequestId(response.getOpcWorkRequestId()).build();
                VirtualNetworkWaiters.this.workRequestClient.getWaiters().forWorkRequest(getWorkRequestRequest, terminationStrategy, delayStrategy).execute();
                return response;
            }
        }, (Object)request);
    }

    public Waiter<RemoveVcnCidrRequest, RemoveVcnCidrResponse> forRemoveVcnCidr(RemoveVcnCidrRequest request) {
        return this.forRemoveVcnCidr(request, Waiters.DEFAULT_POLLING_TERMINATION_STRATEGY, Waiters.DEFAULT_POLLING_DELAY_STRATEGY);
    }

    public Waiter<RemoveVcnCidrRequest, RemoveVcnCidrResponse> forRemoveVcnCidr(final RemoveVcnCidrRequest request, final TerminationStrategy terminationStrategy, final DelayStrategy delayStrategy) {
        if (this.workRequestClient == null) {
            throw new IllegalStateException("A WorkRequestClient must be supplied to this waiter for this operation");
        }
        return new SimpleWaiterImpl(this.executorService, (Callable)new Callable<RemoveVcnCidrResponse>(){

            @Override
            public RemoveVcnCidrResponse call() throws Exception {
                RemoveVcnCidrResponse response = VirtualNetworkWaiters.this.client.removeVcnCidr(request);
                GetWorkRequestRequest getWorkRequestRequest = GetWorkRequestRequest.builder().workRequestId(response.getOpcWorkRequestId()).build();
                VirtualNetworkWaiters.this.workRequestClient.getWaiters().forWorkRequest(getWorkRequestRequest, terminationStrategy, delayStrategy).execute();
                return response;
            }
        }, (Object)request);
    }

    public Waiter<UpdateVtapRequest, UpdateVtapResponse> forUpdateVtap(UpdateVtapRequest request) {
        return this.forUpdateVtap(request, Waiters.DEFAULT_POLLING_TERMINATION_STRATEGY, Waiters.DEFAULT_POLLING_DELAY_STRATEGY);
    }

    public Waiter<UpdateVtapRequest, UpdateVtapResponse> forUpdateVtap(final UpdateVtapRequest request, final TerminationStrategy terminationStrategy, final DelayStrategy delayStrategy) {
        if (this.workRequestClient == null) {
            throw new IllegalStateException("A WorkRequestClient must be supplied to this waiter for this operation");
        }
        return new SimpleWaiterImpl(this.executorService, (Callable)new Callable<UpdateVtapResponse>(){

            @Override
            public UpdateVtapResponse call() throws Exception {
                UpdateVtapResponse response = VirtualNetworkWaiters.this.client.updateVtap(request);
                GetWorkRequestRequest getWorkRequestRequest = GetWorkRequestRequest.builder().workRequestId(response.getOpcWorkRequestId()).build();
                VirtualNetworkWaiters.this.workRequestClient.getWaiters().forWorkRequest(getWorkRequestRequest, terminationStrategy, delayStrategy).execute();
                return response;
            }
        }, (Object)request);
    }

    public Waiter<UpgradeDrgRequest, UpgradeDrgResponse> forUpgradeDrg(UpgradeDrgRequest request) {
        return this.forUpgradeDrg(request, Waiters.DEFAULT_POLLING_TERMINATION_STRATEGY, Waiters.DEFAULT_POLLING_DELAY_STRATEGY);
    }

    public Waiter<UpgradeDrgRequest, UpgradeDrgResponse> forUpgradeDrg(final UpgradeDrgRequest request, final TerminationStrategy terminationStrategy, final DelayStrategy delayStrategy) {
        if (this.workRequestClient == null) {
            throw new IllegalStateException("A WorkRequestClient must be supplied to this waiter for this operation");
        }
        return new SimpleWaiterImpl(this.executorService, (Callable)new Callable<UpgradeDrgResponse>(){

            @Override
            public UpgradeDrgResponse call() throws Exception {
                UpgradeDrgResponse response = VirtualNetworkWaiters.this.client.upgradeDrg(request);
                GetWorkRequestRequest getWorkRequestRequest = GetWorkRequestRequest.builder().workRequestId(response.getOpcWorkRequestId()).build();
                VirtualNetworkWaiters.this.workRequestClient.getWaiters().forWorkRequest(getWorkRequestRequest, terminationStrategy, delayStrategy).execute();
                return response;
            }
        }, (Object)request);
    }

    public Waiter<ValidateByoipRangeRequest, ValidateByoipRangeResponse> forValidateByoipRange(ValidateByoipRangeRequest request) {
        return this.forValidateByoipRange(request, Waiters.DEFAULT_POLLING_TERMINATION_STRATEGY, Waiters.DEFAULT_POLLING_DELAY_STRATEGY);
    }

    public Waiter<ValidateByoipRangeRequest, ValidateByoipRangeResponse> forValidateByoipRange(final ValidateByoipRangeRequest request, final TerminationStrategy terminationStrategy, final DelayStrategy delayStrategy) {
        if (this.workRequestClient == null) {
            throw new IllegalStateException("A WorkRequestClient must be supplied to this waiter for this operation");
        }
        return new SimpleWaiterImpl(this.executorService, (Callable)new Callable<ValidateByoipRangeResponse>(){

            @Override
            public ValidateByoipRangeResponse call() throws Exception {
                ValidateByoipRangeResponse response = VirtualNetworkWaiters.this.client.validateByoipRange(request);
                GetWorkRequestRequest getWorkRequestRequest = GetWorkRequestRequest.builder().workRequestId(response.getOpcWorkRequestId()).build();
                VirtualNetworkWaiters.this.workRequestClient.getWaiters().forWorkRequest(getWorkRequestRequest, terminationStrategy, delayStrategy).execute();
                return response;
            }
        }, (Object)request);
    }
}

