/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.refactoring.utils;

import org.netbeans.api.fileinfo.NonRecursiveFolder;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.refactoring.api.RenameRefactoring;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Parameters;
import org.openide.util.Utilities;

public final class IdentifiersUtil {
    private IdentifiersUtil() {
    }

    public static String constructNewName(FileObject file, RenameRefactoring rename) {
        Parameters.notNull((CharSequence)"file", (Object)file);
        Parameters.notNull((CharSequence)"rename", (Object)rename);
        String fqn = IdentifiersUtil.getQualifiedName(file);
        if (IdentifiersUtil.isPackageRename(rename)) {
            return rename.getNewName() + "." + IdentifiersUtil.unqualify(fqn);
        }
        FileObject folder = (FileObject)rename.getRefactoringSource().lookup(FileObject.class);
        ClassPath classPath = ClassPath.getClassPath((FileObject)folder, (String)"classpath/source");
        if (classPath == null) {
            return "Cannot construct new name!";
        }
        FileObject root = classPath.findOwnerRoot(folder);
        String prefix = FileUtil.getRelativePath((FileObject)root, (FileObject)folder.getParent()).replace('/', '.');
        String oldName = IdentifiersUtil.buildName(prefix, folder.getName());
        String newName = IdentifiersUtil.buildName(prefix, rename.getNewName());
        int oldNameIndex = fqn.lastIndexOf(oldName) + oldName.length();
        return newName + fqn.substring(oldNameIndex);
    }

    public static boolean isPackageRename(RenameRefactoring rename) {
        return rename.getRefactoringSource().lookup(NonRecursiveFolder.class) != null;
    }

    private static String buildName(String prefix, String name) {
        if (prefix.length() == 0) {
            return name;
        }
        return prefix + "." + name;
    }

    public static boolean isValidPackageName(String packageName) {
        Parameters.notNull((CharSequence)"packageName", (Object)packageName);
        if ("".equals(packageName)) {
            return true;
        }
        if (packageName.startsWith(".") || packageName.endsWith(".")) {
            return false;
        }
        String[] tokens = packageName.split("\\.");
        if (tokens.length == 0) {
            return Utilities.isJavaIdentifier((String)packageName);
        }
        for (String token : tokens) {
            if (Utilities.isJavaIdentifier((String)token)) continue;
            return false;
        }
        return true;
    }

    public static String getPackageName(FileObject fo) {
        String fqn = IdentifiersUtil.getQualifiedName(fo);
        if (fqn != null) {
            return IdentifiersUtil.unqualify(fqn);
        }
        return "";
    }

    public static String getQualifiedName(FileObject fo) {
        Parameters.notNull((CharSequence)"fileObject", (Object)fo);
        ClassPath classPath = ClassPath.getClassPath((FileObject)fo, (String)"classpath/source");
        if (classPath != null) {
            return classPath.getResourceName(fo, '.', false);
        }
        return null;
    }

    public static String unqualify(String fqn) {
        IdentifiersUtil.checkFQN(fqn);
        int lastDot = fqn.lastIndexOf(".");
        if (lastDot < 0) {
            return fqn;
        }
        return fqn.substring(lastDot + 1);
    }

    public static String getPackageName(String fqn) {
        IdentifiersUtil.checkFQN(fqn);
        int lastDot = fqn.lastIndexOf(".");
        if (lastDot < 0) {
            return "";
        }
        return fqn.substring(0, lastDot);
    }

    private static void checkFQN(String fqn) {
        Parameters.notEmpty((CharSequence)"fqn", (CharSequence)fqn);
        if (!IdentifiersUtil.isValidPackageName(fqn)) {
            throw new IllegalArgumentException("The given fqn [" + fqn + "] does not represent a fully qualified class name");
        }
    }
}

