/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.database.model.BackupDestinationDetails;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class CreateAutonomousDatabaseBackupDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="autonomousDatabaseId")
    private final String autonomousDatabaseId;
    @JsonProperty(value="retentionPeriodInDays")
    private final Integer retentionPeriodInDays;
    @JsonProperty(value="isLongTermBackup")
    private final Boolean isLongTermBackup;
    @JsonProperty(value="backupDestinationDetails")
    private final BackupDestinationDetails backupDestinationDetails;

    @Deprecated
    @ConstructorProperties(value={"displayName", "autonomousDatabaseId", "retentionPeriodInDays", "isLongTermBackup", "backupDestinationDetails"})
    public CreateAutonomousDatabaseBackupDetails(String displayName, String autonomousDatabaseId, Integer retentionPeriodInDays, Boolean isLongTermBackup, BackupDestinationDetails backupDestinationDetails) {
        this.displayName = displayName;
        this.autonomousDatabaseId = autonomousDatabaseId;
        this.retentionPeriodInDays = retentionPeriodInDays;
        this.isLongTermBackup = isLongTermBackup;
        this.backupDestinationDetails = backupDestinationDetails;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getAutonomousDatabaseId() {
        return this.autonomousDatabaseId;
    }

    public Integer getRetentionPeriodInDays() {
        return this.retentionPeriodInDays;
    }

    public Boolean getIsLongTermBackup() {
        return this.isLongTermBackup;
    }

    public BackupDestinationDetails getBackupDestinationDetails() {
        return this.backupDestinationDetails;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CreateAutonomousDatabaseBackupDetails(");
        sb.append("super=").append(super.toString());
        sb.append("displayName=").append(String.valueOf(this.displayName));
        sb.append(", autonomousDatabaseId=").append(String.valueOf(this.autonomousDatabaseId));
        sb.append(", retentionPeriodInDays=").append(String.valueOf(this.retentionPeriodInDays));
        sb.append(", isLongTermBackup=").append(String.valueOf(this.isLongTermBackup));
        sb.append(", backupDestinationDetails=").append(String.valueOf((Object)this.backupDestinationDetails));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateAutonomousDatabaseBackupDetails)) {
            return false;
        }
        CreateAutonomousDatabaseBackupDetails other = (CreateAutonomousDatabaseBackupDetails)((Object)o);
        return Objects.equals(this.displayName, other.displayName) && Objects.equals(this.autonomousDatabaseId, other.autonomousDatabaseId) && Objects.equals(this.retentionPeriodInDays, other.retentionPeriodInDays) && Objects.equals(this.isLongTermBackup, other.isLongTermBackup) && Objects.equals((Object)this.backupDestinationDetails, (Object)other.backupDestinationDetails) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.autonomousDatabaseId == null ? 43 : this.autonomousDatabaseId.hashCode());
        result = result * 59 + (this.retentionPeriodInDays == null ? 43 : this.retentionPeriodInDays.hashCode());
        result = result * 59 + (this.isLongTermBackup == null ? 43 : this.isLongTermBackup.hashCode());
        result = result * 59 + (this.backupDestinationDetails == null ? 43 : this.backupDestinationDetails.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="autonomousDatabaseId")
        private String autonomousDatabaseId;
        @JsonProperty(value="retentionPeriodInDays")
        private Integer retentionPeriodInDays;
        @JsonProperty(value="isLongTermBackup")
        private Boolean isLongTermBackup;
        @JsonProperty(value="backupDestinationDetails")
        private BackupDestinationDetails backupDestinationDetails;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder autonomousDatabaseId(String autonomousDatabaseId) {
            this.autonomousDatabaseId = autonomousDatabaseId;
            this.__explicitlySet__.add("autonomousDatabaseId");
            return this;
        }

        public Builder retentionPeriodInDays(Integer retentionPeriodInDays) {
            this.retentionPeriodInDays = retentionPeriodInDays;
            this.__explicitlySet__.add("retentionPeriodInDays");
            return this;
        }

        public Builder isLongTermBackup(Boolean isLongTermBackup) {
            this.isLongTermBackup = isLongTermBackup;
            this.__explicitlySet__.add("isLongTermBackup");
            return this;
        }

        public Builder backupDestinationDetails(BackupDestinationDetails backupDestinationDetails) {
            this.backupDestinationDetails = backupDestinationDetails;
            this.__explicitlySet__.add("backupDestinationDetails");
            return this;
        }

        public CreateAutonomousDatabaseBackupDetails build() {
            CreateAutonomousDatabaseBackupDetails model = new CreateAutonomousDatabaseBackupDetails(this.displayName, this.autonomousDatabaseId, this.retentionPeriodInDays, this.isLongTermBackup, this.backupDestinationDetails);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CreateAutonomousDatabaseBackupDetails model) {
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("autonomousDatabaseId")) {
                this.autonomousDatabaseId(model.getAutonomousDatabaseId());
            }
            if (model.wasPropertyExplicitlySet("retentionPeriodInDays")) {
                this.retentionPeriodInDays(model.getRetentionPeriodInDays());
            }
            if (model.wasPropertyExplicitlySet("isLongTermBackup")) {
                this.isLongTermBackup(model.getIsLongTermBackup());
            }
            if (model.wasPropertyExplicitlySet("backupDestinationDetails")) {
                this.backupDestinationDetails(model.getBackupDestinationDetails());
            }
            return this;
        }
    }
}

