/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.registry.uddi;

import com.sun.xml.registry.common.BulkResponseImpl;
import com.sun.xml.registry.uddi.RegistryServiceImpl;
import com.sun.xml.registry.uddi.UDDIMapper;
import java.util.Collection;
import javax.xml.registry.JAXRException;
import javax.xml.registry.infomodel.Key;

public abstract class JAXRCommand {
    RegistryServiceImpl service;
    UDDIMapper mapper;
    BulkResponseImpl response;
    BulkResponseImpl content;

    public JAXRCommand(RegistryServiceImpl service, BulkResponseImpl response) throws JAXRException {
        this.service = service;
        this.response = response;
        this.mapper = new UDDIMapper(service);
    }

    abstract void execute() throws JAXRException;

    static class SaveServicesCommand
    extends JAXRCommand {
        Collection services;

        public SaveServicesCommand(RegistryServiceImpl service, BulkResponseImpl response, Collection services) throws JAXRException {
            super(service, response);
            this.services = services;
        }

        @Override
        void execute() throws JAXRException {
            this.response.updateResponse(this.mapper.saveServices(this.services));
        }
    }

    static class SaveServiceBindingsCommand
    extends JAXRCommand {
        Collection bindings;

        public SaveServiceBindingsCommand(RegistryServiceImpl service, BulkResponseImpl response, Collection bindings) throws JAXRException {
            super(service, response);
            this.bindings = bindings;
        }

        @Override
        void execute() throws JAXRException {
            this.response.updateResponse(this.mapper.saveServiceBindings(this.bindings));
        }
    }

    static class SaveOrganizationsCommand
    extends JAXRCommand {
        Collection organizations;

        public SaveOrganizationsCommand(RegistryServiceImpl service, BulkResponseImpl response, Collection organizations) throws JAXRException {
            super(service, response);
            this.organizations = organizations;
        }

        @Override
        void execute() throws JAXRException {
            this.response.updateResponse(this.mapper.saveOrganizations(this.organizations));
        }
    }

    static class SaveObjectsCommand
    extends JAXRCommand {
        Collection cataloguedObjects;

        public SaveObjectsCommand(RegistryServiceImpl service, BulkResponseImpl response, Collection cataloguedObjects) throws JAXRException {
            super(service, response);
            this.cataloguedObjects = cataloguedObjects;
        }

        @Override
        void execute() throws JAXRException {
            this.response.updateResponse(this.mapper.saveObjects(this.cataloguedObjects));
        }
    }

    static class SaveConceptsCommand
    extends JAXRCommand {
        Collection concepts;

        public SaveConceptsCommand(RegistryServiceImpl service, BulkResponseImpl response, Collection concepts) throws JAXRException {
            super(service, response);
            this.concepts = concepts;
        }

        @Override
        void execute() throws JAXRException {
            this.response.updateResponse(this.mapper.saveConcepts(this.concepts));
        }
    }

    static class SaveClassificationSchemesCommand
    extends JAXRCommand {
        Collection schemes;

        public SaveClassificationSchemesCommand(RegistryServiceImpl service, BulkResponseImpl response, Collection schemes) throws JAXRException {
            super(service, response);
            this.schemes = schemes;
        }

        @Override
        void execute() throws JAXRException {
            this.response.updateResponse(this.mapper.saveClassificationSchemes(this.schemes));
        }
    }

    static class SaveAssociationsCommand
    extends JAXRCommand {
        Collection associations;
        boolean replace;

        public SaveAssociationsCommand(RegistryServiceImpl service, BulkResponseImpl response, Collection associations, boolean replace) throws JAXRException {
            super(service, response);
            this.associations = associations;
            this.replace = replace;
        }

        @Override
        void execute() throws JAXRException {
            this.response.updateResponse(this.mapper.saveAssociations(this.associations, this.replace));
        }
    }

    static class GetRegistryObjectsByTypeCommand
    extends JAXRCommand {
        String objectType;

        public GetRegistryObjectsByTypeCommand(RegistryServiceImpl service, BulkResponseImpl response, String objectType) throws JAXRException {
            super(service, response);
            this.objectType = objectType;
        }

        @Override
        void execute() throws JAXRException {
            this.response.updateResponse(this.mapper.getRegistryObjects(this.objectType));
        }
    }

    static class GetRegistryObjectsByKeysCommand
    extends JAXRCommand {
        Collection objectKeys;
        String type;

        public GetRegistryObjectsByKeysCommand(RegistryServiceImpl service, BulkResponseImpl response, Collection objectKeys, String type) throws JAXRException {
            super(service, response);
            this.objectKeys = objectKeys;
            this.type = type;
        }

        @Override
        void execute() throws JAXRException {
            this.response.updateResponse(this.mapper.getRegistryObjects(this.objectKeys, this.type));
        }
    }

    static class FindCallerAssociationsCommand
    extends JAXRCommand {
        Collection findQualifiers;
        Boolean confirmedByCaller;
        Boolean confirmedByOther;
        Collection associationTypes;

        public FindCallerAssociationsCommand(RegistryServiceImpl service, BulkResponseImpl response, Collection findQualifiers, Boolean confirmedByCaller, Boolean confirmedByOther, Collection associationTypes) throws JAXRException {
            super(service, response);
            this.findQualifiers = findQualifiers;
            this.confirmedByCaller = confirmedByCaller;
            this.confirmedByOther = confirmedByOther;
            this.associationTypes = associationTypes;
        }

        @Override
        void execute() throws JAXRException {
            this.response.updateResponse(this.mapper.findCallerAssociations(this.findQualifiers, this.confirmedByCaller, this.confirmedByOther, this.associationTypes));
        }
    }

    static class FindAssociationsCommand
    extends JAXRCommand {
        Collection findQualifiers;
        String sourceObjectId;
        String targetObjectId;
        Collection associationTypes;

        public FindAssociationsCommand(RegistryServiceImpl service, BulkResponseImpl response, Collection findQualifiers, String sourceObjectId, String targetObjectId, Collection associationTypes) throws JAXRException {
            super(service, response);
            this.findQualifiers = findQualifiers;
            this.sourceObjectId = sourceObjectId;
            this.targetObjectId = targetObjectId;
            this.associationTypes = associationTypes;
        }

        @Override
        void execute() throws JAXRException {
            this.response.updateResponse(this.mapper.findAssociations(this.findQualifiers, this.sourceObjectId, this.targetObjectId, this.associationTypes));
        }
    }

    static class FindServicesCommand
    extends JAXRCommand {
        Key orgKey;
        Collection findQualifiers;
        Collection namePatterns;
        Collection classifications;
        Collection specifications;

        public FindServicesCommand(RegistryServiceImpl service, BulkResponseImpl response, Key orgKey, Collection findQualifiers, Collection namePatterns, Collection classifications, Collection specifications) throws JAXRException {
            super(service, response);
            this.orgKey = orgKey;
            this.findQualifiers = findQualifiers;
            this.namePatterns = namePatterns;
            this.classifications = classifications;
            this.specifications = specifications;
        }

        @Override
        void execute() throws JAXRException {
            this.response.updateResponse(this.mapper.findServices(this.orgKey, this.findQualifiers, this.namePatterns, this.classifications, this.specifications));
        }
    }

    static class FindServiceBindingsCommand
    extends JAXRCommand {
        Key serviceKey;
        Collection findQualifiers;
        Collection classifications;
        Collection specifications;

        public FindServiceBindingsCommand(RegistryServiceImpl service, BulkResponseImpl response, Key serviceKey, Collection findQualifiers, Collection classifications, Collection specifications) throws JAXRException {
            super(service, response);
            this.serviceKey = serviceKey;
            this.findQualifiers = findQualifiers;
            this.classifications = classifications;
            this.specifications = specifications;
        }

        @Override
        void execute() throws JAXRException {
            this.response.updateResponse(this.mapper.findServiceBindings(this.serviceKey, this.findQualifiers, this.classifications, this.specifications));
        }
    }

    static class FindOrganizationsCommand
    extends JAXRCommand {
        Collection findQualifiers;
        Collection namePatterns;
        Collection classifications;
        Collection specifications;
        Collection identifiers;
        Collection externalLinks;

        public FindOrganizationsCommand(RegistryServiceImpl service, BulkResponseImpl response, Collection findQualifiers, Collection namePatterns, Collection classifications, Collection specifications, Collection identifiers, Collection externalLinks) throws JAXRException {
            super(service, response);
            this.findQualifiers = findQualifiers;
            this.namePatterns = namePatterns;
            this.classifications = classifications;
            this.specifications = specifications;
            this.identifiers = identifiers;
            this.externalLinks = externalLinks;
        }

        @Override
        void execute() throws JAXRException {
            this.response.updateResponse(this.mapper.findOrganizations(this.findQualifiers, this.namePatterns, this.classifications, this.specifications, this.identifiers, this.externalLinks));
        }
    }

    static class FindConceptsCommand
    extends JAXRCommand {
        Collection findQualifiers;
        Collection namePatterns;
        Collection classifications;
        Collection identifiers;
        Collection externalLinks;

        public FindConceptsCommand(RegistryServiceImpl service, BulkResponseImpl response, Collection findQualifiers, Collection namePatterns, Collection classifications, Collection identifiers, Collection externalLinks) throws JAXRException {
            super(service, response);
            this.findQualifiers = findQualifiers;
            this.namePatterns = namePatterns;
            this.classifications = classifications;
            this.identifiers = identifiers;
            this.externalLinks = externalLinks;
        }

        @Override
        void execute() throws JAXRException {
            this.response.updateResponse(this.mapper.findConcepts(this.findQualifiers, this.namePatterns, this.classifications, this.identifiers, this.externalLinks));
        }
    }

    static class FindClassificationSchemesCommand
    extends JAXRCommand {
        Collection findQualifiers;
        Collection namePatterns;
        Collection classifications;
        Collection externalLinks;

        public FindClassificationSchemesCommand(RegistryServiceImpl service, BulkResponseImpl response, Collection findQualifiers, Collection namePatterns, Collection classifications, Collection externalLinks) throws JAXRException {
            super(service, response);
            this.findQualifiers = findQualifiers;
            this.namePatterns = namePatterns;
            this.classifications = classifications;
            this.externalLinks = externalLinks;
        }

        @Override
        void execute() throws JAXRException {
            this.response.updateResponse(this.mapper.findClassificationSchemes(this.findQualifiers, this.namePatterns, this.classifications, this.externalLinks));
        }
    }

    static class DeleteServicesCommand
    extends JAXRCommand {
        Collection serviceKeys;

        public DeleteServicesCommand(RegistryServiceImpl service, BulkResponseImpl response, Collection serviceKeys) throws JAXRException {
            super(service, response);
            this.serviceKeys = serviceKeys;
        }

        @Override
        void execute() throws JAXRException {
            this.response.updateResponse(this.mapper.deleteServices(this.serviceKeys));
        }
    }

    static class DeleteServiceBindingsCommand
    extends JAXRCommand {
        Collection bindingKeys;

        public DeleteServiceBindingsCommand(RegistryServiceImpl service, BulkResponseImpl response, Collection bindingKeys) throws JAXRException {
            super(service, response);
            this.bindingKeys = bindingKeys;
        }

        @Override
        void execute() throws JAXRException {
            this.response.updateResponse(this.mapper.deleteServiceBindings(this.bindingKeys));
        }
    }

    static class DeleteOrganizationsCommand
    extends JAXRCommand {
        Collection organizationKeys;

        public DeleteOrganizationsCommand(RegistryServiceImpl service, BulkResponseImpl response, Collection organizationKeys) throws JAXRException {
            super(service, response);
            this.organizationKeys = organizationKeys;
        }

        @Override
        void execute() throws JAXRException {
            this.response.updateResponse(this.mapper.deleteOrganizations(this.organizationKeys));
        }
    }

    static class DeleteObjectsCommand
    extends JAXRCommand {
        Collection keys;
        String type;

        public DeleteObjectsCommand(RegistryServiceImpl service, BulkResponseImpl response, Collection keys, String type) throws JAXRException {
            super(service, response);
            this.keys = keys;
            this.type = type;
        }

        @Override
        void execute() throws JAXRException {
            this.response.updateResponse(this.mapper.deleteObjects(this.keys, this.type));
        }
    }

    static class DeleteConceptsCommand
    extends JAXRCommand {
        Collection conceptKeys;

        public DeleteConceptsCommand(RegistryServiceImpl service, BulkResponseImpl response, Collection conceptKeys) throws JAXRException {
            super(service, response);
            this.conceptKeys = conceptKeys;
        }

        @Override
        void execute() throws JAXRException {
            this.response.updateResponse(this.mapper.deleteConcepts(this.conceptKeys));
        }
    }

    static class DeleteClassificationSchemesCommand
    extends JAXRCommand {
        Collection schemeKeys;

        public DeleteClassificationSchemesCommand(RegistryServiceImpl service, BulkResponseImpl response, Collection schemeKeys) throws JAXRException {
            super(service, response);
            this.schemeKeys = schemeKeys;
        }

        @Override
        void execute() throws JAXRException {
            this.response.updateResponse(this.mapper.deleteConcepts(this.schemeKeys));
        }
    }

    static class DeleteAssociationsCommand
    extends JAXRCommand {
        Collection schemeKeys;

        public DeleteAssociationsCommand(RegistryServiceImpl service, BulkResponseImpl response, Collection schemeKeys) throws JAXRException {
            super(service, response);
            this.schemeKeys = schemeKeys;
        }

        @Override
        void execute() throws JAXRException {
            this.response.updateResponse(this.mapper.deleteAssociations(this.schemeKeys));
        }
    }

    static class GetRegistryObjectsCommand
    extends JAXRCommand {
        public GetRegistryObjectsCommand(RegistryServiceImpl service, BulkResponseImpl response) throws JAXRException {
            super(service, response);
        }

        @Override
        void execute() throws JAXRException {
            this.response.updateResponse(this.mapper.getRegistryObjects());
        }
    }
}

