/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.client;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.websvc.rest.client.ClientJavaSourceHelper;
import org.netbeans.modules.websvc.saas.model.WadlSaasMethod;
import org.netbeans.modules.websvc.saas.model.WadlSaasResource;
import org.netbeans.modules.websvc.saas.model.wadl.Param;
import org.netbeans.modules.websvc.saas.model.wadl.ParamStyle;
import org.netbeans.modules.websvc.saas.model.wadl.Representation;
import org.netbeans.modules.websvc.saas.model.wadl.Request;

public class HttpParams {
    private boolean hasFormParams = false;
    private boolean hasHeaderParams = false;
    private boolean hasQueryParams = false;
    private boolean hasRequiredQueryParams = false;
    private boolean hasOptionalQueryParams = false;
    private boolean hasDefaultQueryParams = false;
    private List<String> formParams = new ArrayList<String>();
    private Map<String, String> fixedFormParams = new HashMap<String, String>();
    private List<String> headerParams = new ArrayList<String>();
    private Map<String, String> fixedHeaderParams = new HashMap<String, String>();
    private Map<String, String> defaultQueryParams = new HashMap<String, String>();
    private List<String> requiredQueryParams = new ArrayList<String>();
    private List<String> optionalQueryParams = new ArrayList<String>();
    private Map<String, String> fixedQueryParams = new HashMap<String, String>();

    HttpParams(WadlSaasResource saasResource) {
        this.initParams(saasResource.getResource().getParam(), null);
    }

    HttpParams(WadlSaasMethod saasMethod) {
        Request request = saasMethod.getWadlMethod().getRequest();
        if (request != null) {
            Representation formType = null;
            List representations = request.getRepresentation();
            for (Representation repr : representations) {
                if (!ClientJavaSourceHelper.HttpMimeType.FORM.getMimeType().equals(repr.getMediaType())) continue;
                formType = repr;
                break;
            }
            this.initParams(request.getParam(), formType);
        }
    }

    private void initParams(List<Param> params, Representation formType) {
        List formParamList;
        if (formType != null && (formParamList = formType.getParam()).size() > 0) {
            this.hasFormParams = true;
            for (Param param : formParamList) {
                String fixedValue = param.getFixed();
                if (fixedValue != null) {
                    this.fixedFormParams.put(param.getName(), fixedValue);
                    continue;
                }
                this.formParams.add(param.getName());
            }
        }
        for (Param param : params) {
            if (ParamStyle.HEADER == param.getStyle()) {
                this.hasHeaderParams = true;
                String fixedValue = param.getFixed();
                if (fixedValue != null) {
                    this.fixedHeaderParams.put(param.getName(), fixedValue);
                } else {
                    this.headerParams.add(param.getName());
                }
            }
            if (ParamStyle.QUERY != param.getStyle()) continue;
            this.hasQueryParams = true;
            if (param.isRequired() && param.getFixed() == null && param.getDefault() == null) {
                this.hasRequiredQueryParams = true;
                this.requiredQueryParams.add(param.getName());
                continue;
            }
            if (param.getFixed() != null) {
                this.hasRequiredQueryParams = true;
                this.fixedQueryParams.put(param.getName(), param.getFixed());
                continue;
            }
            if (param.getDefault() != null) {
                this.hasDefaultQueryParams = true;
                this.defaultQueryParams.put(param.getName(), param.getDefault());
                continue;
            }
            this.hasOptionalQueryParams = true;
            this.optionalQueryParams.add(param.getName());
        }
    }

    boolean hasMultipleParamsInList() {
        if (!this.hasQueryParams) {
            return false;
        }
        return this.requiredQueryParams.size() + this.fixedQueryParams.size() > 1 || !this.hasRequiredQueryParams && this.optionalQueryParams.size() > 0;
    }

    boolean hasFormParams() {
        return this.hasFormParams;
    }

    boolean hasQueryParams() {
        return this.hasQueryParams;
    }

    boolean hasHeaderParams() {
        return this.hasHeaderParams;
    }

    boolean hasRequiredQueryParams() {
        return this.hasRequiredQueryParams;
    }

    boolean hasOptionalQueryParams() {
        return this.hasOptionalQueryParams;
    }

    boolean hasDefaultQueryParams() {
        return this.hasDefaultQueryParams;
    }

    Map<String, String> getDefaultQueryParams() {
        return this.defaultQueryParams;
    }

    Map<String, String> getFixedQueryParams() {
        return this.fixedQueryParams;
    }

    List<String> getOptionalQueryParams() {
        return this.optionalQueryParams;
    }

    List<String> getRequiredQueryParams() {
        return this.requiredQueryParams;
    }

    List<String> getFormParams() {
        return this.formParams;
    }

    Map<String, String> getFixedFormParams() {
        return this.fixedFormParams;
    }

    List<String> getHeaderParams() {
        return this.headerParams;
    }

    Map<String, String> getFixedHeaderParams() {
        return this.fixedHeaderParams;
    }

    void mergeQueryandHeaderParams(HttpParams params) {
        this.hasQueryParams = this.hasQueryParams || params.hasQueryParams;
        this.hasRequiredQueryParams = this.hasRequiredQueryParams || params.hasRequiredQueryParams;
        this.hasOptionalQueryParams = this.hasOptionalQueryParams || params.hasOptionalQueryParams;
        this.hasHeaderParams = this.hasHeaderParams || params.hasHeaderParams;
        this.requiredQueryParams.addAll(params.requiredQueryParams);
        this.optionalQueryParams.addAll(params.optionalQueryParams);
        this.fixedQueryParams.putAll(params.fixedQueryParams);
        this.defaultQueryParams.putAll(params.defaultQueryParams);
        this.headerParams.addAll(params.headerParams);
        this.fixedHeaderParams.putAll(params.fixedHeaderParams);
    }
}

