/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui.actions;

import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.spi.project.ActionProvider;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.Lookup;
import org.openide.util.Pair;

class ActionsUtil {
    private static final HashMap<String, MessageFormat> pattern2format = new HashMap();

    private ActionsUtil() {
    }

    @NonNull
    public static Project[] getProjectsFromLookup(Lookup lookup, String command) {
        LinkedHashSet<Project> result = new LinkedHashSet<Project>();
        for (Project p : lookup.lookupAll(Project.class)) {
            if (command != null && !ActionsUtil.commandSupported(p, command, lookup)) {
                return new Project[0];
            }
            result.add(p);
        }
        for (DataObject dObj : lookup.lookupAll(DataObject.class)) {
            FileObject fObj = dObj.getPrimaryFile();
            Project p = FileOwnerQuery.getOwner((FileObject)fObj);
            if (p == null) continue;
            if (command != null && !ActionsUtil.commandSupported(p, command, lookup)) {
                return new Project[0];
            }
            result.add(p);
        }
        Project[] projectsArray = result.toArray(new Project[0]);
        return projectsArray;
    }

    public static Pair<List<Project>, List<FileObject>> mineFromLookup(Lookup lookup) {
        ArrayList<Project> result = new ArrayList<Project>();
        for (Project p : lookup.lookupAll(Project.class)) {
            result.add(p);
        }
        ArrayList<FileObject> result2 = new ArrayList<FileObject>();
        for (DataObject dObj : lookup.lookupAll(DataObject.class)) {
            result2.add(dObj.getPrimaryFile());
        }
        return Pair.of(result, result2);
    }

    @NonNull
    public static Project[] getProjects(Pair<List<Project>, List<FileObject>> data) {
        LinkedHashSet<Project> result = new LinkedHashSet<Project>();
        result.addAll((Collection)data.first());
        for (FileObject fObj : (List)data.second()) {
            Project p = FileOwnerQuery.getOwner((FileObject)fObj);
            if (p == null) continue;
            result.add(p);
        }
        Project[] projectsArray = result.toArray(new Project[0]);
        return projectsArray;
    }

    public static FileObject[] getFilesFromLookup(Lookup lookup, Project project) {
        HashSet<FileObject> result = new HashSet<FileObject>();
        for (DataObject dObj : lookup.lookupAll(DataObject.class)) {
            FileObject fObj = dObj.getPrimaryFile();
            Project p = FileOwnerQuery.getOwner((FileObject)fObj);
            if (p == null || !p.equals((Object)project)) continue;
            result.add(fObj);
        }
        FileObject[] fos = new FileObject[result.size()];
        result.toArray(fos);
        return fos;
    }

    public static boolean commandSupported(Project project, String command, Lookup context) {
        List<String> commands;
        ActionProvider ap = (ActionProvider)project.getLookup().lookup(ActionProvider.class);
        if (ap != null && (commands = Arrays.asList(ap.getSupportedActions())).contains(command)) {
            try {
                if (context == null || ap.isActionEnabled(command, context)) {
                    return true;
                }
            }
            catch (IllegalArgumentException x) {
                Logger.getLogger(ActionsUtil.class.getName()).log(Level.INFO, "#213589: possible race condition in MergedActionProvider", x);
            }
        }
        return false;
    }

    public static String formatProjectSensitiveName(String namePattern, Project[] projects) {
        if (projects == null || projects.length == 0) {
            return ActionsUtil.formatName(namePattern, 0, null);
        }
        return ActionsUtil.formatName(namePattern, projects.length, new Wrapper(projects[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String formatName(String namePattern, int numberOfObjects, Object firstObjectName) {
        MessageFormat mf = null;
        HashMap<String, MessageFormat> hashMap = pattern2format;
        synchronized (hashMap) {
            mf = pattern2format.get(namePattern);
            if (mf == null) {
                mf = new MessageFormat(namePattern);
                pattern2format.put(namePattern, mf);
            }
        }
        StringBuffer result = new StringBuffer();
        mf.format(new Object[]{numberOfObjects, firstObjectName == null ? "" : firstObjectName.toString()}, result, (FieldPosition)null);
        return result.toString();
    }

    private static class Wrapper {
        private Project project;

        Wrapper(Project prj) {
            this.project = prj;
        }

        public String toString() {
            return ProjectUtils.getInformation((Project)this.project).getDisplayName();
        }
    }
}

