/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.parser.model;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Link {
    private String name;
    private String link;

    public Link(String name, String link) {
        this.name = name;
        this.link = link;
    }

    public String getName() {
        return this.name;
    }

    public String getLink() {
        return this.link;
    }

    public URL getUrl(String baseURL) {
        try {
            StringBuilder fullLink = new StringBuilder(baseURL);
            if (fullLink.charAt(fullLink.length() - 1) != '/') {
                fullLink.append('/');
            }
            fullLink.append(this.link);
            return new URL(fullLink.toString());
        }
        catch (MalformedURLException ex) {
            Logger.getLogger(Link.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public String toString() {
        return "Link{name=" + this.name + ", link=" + this.link + '}';
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Link other = (Link)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.link == null ? other.link != null : !this.link.equals(other.link));
    }

    public int hashCode() {
        int hash = 3;
        hash = 53 * hash + (this.name != null ? this.name.hashCode() : 0);
        hash = 53 * hash + (this.link != null ? this.link.hashCode() : 0);
        return hash;
    }
}

