/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.csl.editor.semantic;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.modules.csl.api.ColoringAttributes;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.SemanticAnalyzer;
import org.netbeans.modules.csl.core.CancelSupportImplementation;
import org.netbeans.modules.csl.core.Language;
import org.netbeans.modules.csl.core.LanguageRegistry;
import org.netbeans.modules.csl.core.SchedulerTaskCancelSupportImpl;
import org.netbeans.modules.csl.core.SpiSupportAccessor;
import org.netbeans.modules.csl.editor.semantic.ColoringManager;
import org.netbeans.modules.csl.editor.semantic.GsfSemanticLayer;
import org.netbeans.modules.csl.editor.semantic.SequenceElement;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.parsing.api.Embedding;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.spi.IndexingAwareParserResultTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.Scheduler;
import org.netbeans.modules.parsing.spi.SchedulerEvent;
import org.netbeans.modules.parsing.spi.SchedulerTask;
import org.netbeans.modules.parsing.spi.TaskIndexingMode;

public final class SemanticHighlighter
extends IndexingAwareParserResultTask<ParserResult> {
    private static final Logger LOG = Logger.getLogger(SemanticHighlighter.class.getName());
    private final CancelSupportImplementation cancel = SchedulerTaskCancelSupportImpl.create((SchedulerTask)this);

    SemanticHighlighter() {
        super(TaskIndexingMode.ALLOWED_DURING_SCAN);
    }

    public int getPriority() {
        return Integer.MAX_VALUE;
    }

    public Class<? extends Scheduler> getSchedulerClass() {
        return Scheduler.EDITOR_SENSITIVE_TASK_SCHEDULER;
    }

    public final void cancel() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(ParserResult info, SchedulerEvent event) {
        Document doc = info.getSnapshot().getSource().getDocument(false);
        if (doc == null) {
            return;
        }
        SpiSupportAccessor.getInstance().setCancelSupport(this.cancel);
        try {
            long startTime = System.currentTimeMillis();
            Source source = info.getSnapshot().getSource();
            TreeSet<? super SequenceElement> newColoring = new TreeSet<SequenceElement>(SequenceElement.POSITION_ORDER);
            try {
                ParserManager.parse(Collections.singleton(source), ri -> this.processColorings(ri, newColoring));
            }
            catch (ParseException e) {
                LOG.log(Level.WARNING, null, e);
                SpiSupportAccessor.getInstance().removeCancelSupport(this.cancel);
                return;
            }
            long endTime = System.currentTimeMillis();
            Logger.getLogger("TIMER").log(Level.FINE, "Semantic (" + source.getMimeType() + ")", new Object[]{source.getFileObject(), endTime - startTime});
            if (this.cancel.isCancelled()) {
                return;
            }
            GsfSemanticLayer layer = GsfSemanticLayer.getLayer(SemanticHighlighter.class, doc);
            SwingUtilities.invokeLater(() -> layer.setColorings(newColoring));
        }
        finally {
            SpiSupportAccessor.getInstance().removeCancelSupport(this.cancel);
        }
    }

    private void processColorings(ResultIterator resultIterator, SortedSet<SequenceElement> newColoring) throws ParseException {
        Parser.Result r;
        String mimeType = resultIterator.getSnapshot().getMimeType();
        Language language = LanguageRegistry.getInstance().getLanguageByMimeType(mimeType);
        if (language != null && (r = resultIterator.getParserResult()) instanceof ParserResult) {
            ParserResult pr = (ParserResult)r;
            this.process(language, pr, newColoring);
        }
        for (Embedding e : resultIterator.getEmbeddings()) {
            if (this.cancel.isCancelled()) {
                return;
            }
            this.processColorings(resultIterator.getResultIterator(e), newColoring);
        }
    }

    private void process(Language language, ParserResult result, Set<SequenceElement> newColoring) throws ParseException {
        if (this.cancel.isCancelled()) {
            return;
        }
        ColoringManager manager = language.getColoringManager();
        SemanticAnalyzer task = language.getSemanticAnalyzer();
        if (task == null) {
            return;
        }
        try {
            task.run((Parser.Result)result, null);
        }
        catch (Exception ex) {
            LOG.log(Level.WARNING, "SemanticAnalyzer = " + String.valueOf((Object)task) + "; Language = " + String.valueOf(language) + " (mimetype = " + language.getMimeType() + "; ParserResult = " + String.valueOf(result) + "(mimepath = " + String.valueOf(result.getSnapshot().getMimePath()) + ")", ex);
        }
        if (this.cancel.isCancelled()) {
            task.cancel();
            return;
        }
        Document doc = result.getSnapshot().getSource().getDocument(false);
        Map<Object, Set<ColoringAttributes>> highlights = task.getHighlights();
        if (highlights == null) {
            LOG.log(Level.INFO, "Broken SemanticAnalyser detected: {0}#getHighlights returned null", ((Object)((Object)task)).getClass().getName());
            highlights = Collections.emptyMap();
        }
        for (Map.Entry<OffsetRange, Set<ColoringAttributes>> entry : highlights.entrySet()) {
            OffsetRange range = entry.getKey();
            Set<ColoringAttributes> colors = entry.getValue();
            if (colors == null) continue;
            ColoringAttributes.Coloring c = manager.getColoring(colors);
            try {
                newColoring.add(new SequenceElement(language, doc.createPosition(range.getStart()), doc.createPosition(range.getEnd()), c));
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            if (!this.cancel.isCancelled()) continue;
            return;
        }
    }
}

