/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mylyn.util;

import java.util.EventListener;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.mylyn.internal.tasks.core.data.TaskAttributeDiff;
import org.eclipse.mylyn.internal.tasks.core.data.TaskDataState;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.ITaskDataWorkingCopy;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.core.data.TaskDataModel;
import org.eclipse.mylyn.tasks.core.data.TaskDataModelEvent;
import org.eclipse.mylyn.tasks.core.data.TaskDataModelListener;
import org.netbeans.modules.mylyn.util.NbTask;

public final class NbTaskDataModel {
    private final ITaskDataWorkingCopy workingCopy;
    private final TaskDataModel delegateModel;
    private final List<NbTaskDataModelListener> listeners = new CopyOnWriteArrayList<NbTaskDataModelListener>();
    private final NbTask task;
    private final Set<TaskAttribute> unsavedChangedAttributes = new HashSet<TaskAttribute>();

    NbTaskDataModel(TaskRepository taskRepository, NbTask task, ITaskDataWorkingCopy workingCopy) {
        this.task = task;
        this.delegateModel = new TaskDataModel(taskRepository, task.getDelegate(), workingCopy);
        this.workingCopy = workingCopy;
        this.delegateModel.addModelListener(new TaskDataModelListener(){

            public void attributeChanged(TaskDataModelEvent modelEvent) {
                NbTaskDataModelEvent event = new NbTaskDataModelEvent(NbTaskDataModel.this, modelEvent);
                for (NbTaskDataModelListener list : NbTaskDataModel.this.listeners.toArray(new NbTaskDataModelListener[0])) {
                    list.attributeChanged(event);
                }
            }
        });
    }

    public boolean hasIncomingChanges(TaskAttribute taskAttribute, boolean includeConflicts) {
        TaskData repositoryData = this.workingCopy.getRepositoryData();
        if (repositoryData == null) {
            return false;
        }
        taskAttribute = repositoryData.getRoot().getMappedAttribute(taskAttribute.getPath());
        if (taskAttribute == null) {
            return false;
        }
        boolean incoming = this.delegateModel.hasIncomingChanges(taskAttribute);
        if (includeConflicts && !incoming && this.delegateModel.hasOutgoingChanges(taskAttribute)) {
            TaskData lastReadData = this.workingCopy.getLastReadData();
            if (lastReadData == null) {
                return true;
            }
            TaskAttribute oldAttribute = lastReadData.getRoot().getMappedAttribute(taskAttribute.getPath());
            if (oldAttribute == null) {
                return true;
            }
            return !repositoryData.getAttributeMapper().equals(taskAttribute, oldAttribute);
        }
        return incoming;
    }

    public boolean hasOutgoingChanges(TaskAttribute ta) {
        return this.delegateModel.hasOutgoingChanges(ta);
    }

    public TaskData getLocalTaskData() {
        return this.delegateModel.getTaskData();
    }

    public TaskData getLastReadTaskData() {
        return this.workingCopy.getLastReadData();
    }

    public TaskData getRepositoryTaskData() {
        return this.workingCopy.getRepositoryData();
    }

    public void addNbTaskDataModelListener(NbTaskDataModelListener listener) {
        this.listeners.add(listener);
    }

    public void removeNbTaskDataModelListener(NbTaskDataModelListener listener) {
        this.listeners.remove(listener);
    }

    public boolean isDirty() {
        return this.delegateModel.isDirty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attributeChanged(TaskAttribute a) {
        Set<TaskAttribute> set = this.unsavedChangedAttributes;
        synchronized (set) {
            this.unsavedChangedAttributes.remove(a);
            this.unsavedChangedAttributes.add(a);
            this.delegateModel.attributeChanged(a);
        }
    }

    public Set<TaskAttribute> getChangedAttributes() {
        return this.delegateModel.getChangedAttributes();
    }

    public Set<TaskAttribute> getChangedOldAttributes() {
        return this.delegateModel.getChangedOldAttributes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() throws CoreException {
        HashSet<TaskAttribute> changedAttributes;
        this.delegateModel.refresh(null);
        this.delegateModel.revert();
        if (this.workingCopy instanceof TaskDataState && this.workingCopy.getLastReadData() == null) {
            ((TaskDataState)this.workingCopy).setLastReadData(this.workingCopy.getRepositoryData());
        }
        Set<TaskAttribute> set = this.unsavedChangedAttributes;
        synchronized (set) {
            changedAttributes = new HashSet<TaskAttribute>(this.unsavedChangedAttributes);
        }
        for (TaskAttribute ta : changedAttributes) {
            TaskData td = this.getLocalTaskData();
            td.getRoot().deepAddCopy(ta);
            TaskAttribute attribute = td.getRoot().getAttribute(ta.getId());
            this.attributeChanged(attribute);
        }
    }

    public void save() throws CoreException {
        this.save(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(IProgressMonitor monitor) throws CoreException {
        this.delegateModel.save(monitor);
        TaskData editsData = this.workingCopy.getEditsData();
        TaskData repositoryData = this.workingCopy.getRepositoryData();
        Set<TaskAttribute> set = this.unsavedChangedAttributes;
        synchronized (set) {
            boolean noChanges;
            if (editsData != null && repositoryData != null) {
                Iterator<TaskAttribute> it = this.unsavedChangedAttributes.iterator();
                while (it.hasNext()) {
                    TaskAttribute ta = it.next();
                    if (this.editsDiffer(ta, repositoryData)) continue;
                    editsData.getRoot().removeAttribute(ta.getId());
                    it.remove();
                }
            }
            boolean bl = noChanges = this.unsavedChangedAttributes.isEmpty() && !this.hasOutgoingChanged();
            if (noChanges) {
                this.task.discardLocalEdits();
            }
            this.delegateModel.revert();
            this.unsavedChangedAttributes.clear();
        }
    }

    public boolean hasBeenRead() {
        return this.delegateModel.hasBeenRead();
    }

    public TaskRepository getTaskRepository() {
        return this.delegateModel.getTaskRepository();
    }

    public NbTask getTask() {
        return this.task;
    }

    ITask getDelegateTask() {
        return this.delegateModel.getTask();
    }

    public boolean hasOutgoingChanged() {
        return this.isDirty() || !this.getChangedAttributes().isEmpty();
    }

    public void clearUnsavedChanges() {
        if (this.isDirty()) {
            this.delegateModel.revert();
            this.unsavedChangedAttributes.clear();
        }
    }

    private boolean editsDiffer(TaskAttribute ta, TaskData repositoryData) {
        TaskAttribute repositoryTA = repositoryData.getRoot().getMappedAttribute(ta.getPath());
        boolean changes = new TaskAttributeDiff(ta, repositoryTA).hasChanges();
        if (!changes) {
            for (TaskAttribute childTA : ta.getAttributes().values()) {
                if (!this.editsDiffer(childTA, repositoryData)) continue;
                changes = true;
                break;
            }
        }
        return changes;
    }

    public static final class NbTaskDataModelEvent
    extends EventObject {
        private final TaskDataModelEvent modelEvent;
        private final NbTaskDataModel model;

        private NbTaskDataModelEvent(NbTaskDataModel source, TaskDataModelEvent modelEvent) {
            super(source);
            this.model = source;
            this.modelEvent = modelEvent;
        }

        public NbTaskDataModel getModel() {
            return this.model;
        }

        public TaskAttribute getTaskAttribute() {
            return this.modelEvent.getTaskAttribute();
        }
    }

    public static interface NbTaskDataModelListener
    extends EventListener {
        public void attributeChanged(NbTaskDataModelEvent var1);
    }
}

