/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.devops.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class GetRepositoryRequest
extends BmcRequest<Void> {
    private String repositoryId;
    private String opcRequestId;
    private List<Fields> fields;

    public String getRepositoryId() {
        return this.repositoryId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public List<Fields> getFields() {
        return this.fields;
    }

    public Builder toBuilder() {
        return new Builder().repositoryId(this.repositoryId).opcRequestId(this.opcRequestId).fields(this.fields);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",repositoryId=").append(String.valueOf(this.repositoryId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",fields=").append(String.valueOf(this.fields));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetRepositoryRequest)) {
            return false;
        }
        GetRepositoryRequest other = (GetRepositoryRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.repositoryId, other.repositoryId) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.fields, other.fields);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.repositoryId == null ? 43 : this.repositoryId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.fields == null ? 43 : this.fields.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetRepositoryRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String repositoryId = null;
        private String opcRequestId = null;
        private List<Fields> fields = null;

        public Builder repositoryId(String repositoryId) {
            this.repositoryId = repositoryId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder fields(List<Fields> fields) {
            this.fields = fields;
            return this;
        }

        public Builder fields(Fields singularValue) {
            return this.fields(Arrays.asList(singularValue));
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetRepositoryRequest o) {
            this.repositoryId(o.getRepositoryId());
            this.opcRequestId(o.getOpcRequestId());
            this.fields(o.getFields());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetRepositoryRequest build() {
            GetRepositoryRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetRepositoryRequest buildWithoutInvocationCallback() {
            GetRepositoryRequest request = new GetRepositoryRequest();
            request.repositoryId = this.repositoryId;
            request.opcRequestId = this.opcRequestId;
            request.fields = this.fields;
            return request;
        }
    }

    public static enum Fields implements BmcEnum
    {
        BranchCount("branchCount"),
        CommitCount("commitCount"),
        SizeInBytes("sizeInBytes");

        private final String value;
        private static Map<String, Fields> map;

        private Fields(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Fields create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid Fields: " + key);
        }

        static {
            map = new HashMap<String, Fields>();
            for (Fields v : Fields.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

