/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.junit.Test;
import org.languagetool.JLanguageTool;

public class GlobalSpellingTest {
    private List<String> prohibitedExpressions = Arrays.asList("Dnipro", "Dnepr");
    private List<String> prohibitedTokens = Arrays.asList("Tolstoi", "Tolstoy", "Dostoevsky");

    @Test
    public void avoidSomeWords() throws IOException {
        List lines = JLanguageTool.getDataBroker().getFromResourceDirAsLines("spelling_global.txt");
        for (String line : lines) {
            String[] tokens;
            String[] parts = line.split("#");
            if (parts.length == 0) continue;
            String entry = parts[0].trim();
            if (this.prohibitedExpressions.contains(entry)) {
                throw new IllegalStateException("Do not use '" + entry + "' in global_spelling.txt. It is not a valid spelling for all languages.");
            }
            for (String token : tokens = entry.split(" ")) {
                if (!this.prohibitedTokens.contains(token)) continue;
                throw new IllegalStateException("Do not use '" + token + "' in global_spelling.txt. It is not a valid spelling for all languages.");
            }
        }
    }
}

