/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.raft;

import org.apache.kafka.common.Node;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.raft.RaftMessage;

public abstract class RaftResponse
implements RaftMessage {
    private final int correlationId;
    private final ApiMessage data;

    protected RaftResponse(int correlationId, ApiMessage data) {
        this.correlationId = correlationId;
        this.data = data;
    }

    @Override
    public int correlationId() {
        return this.correlationId;
    }

    @Override
    public ApiMessage data() {
        return this.data;
    }

    public static final class Outbound
    extends RaftResponse {
        public Outbound(int requestId, ApiMessage data) {
            super(requestId, data);
        }

        public String toString() {
            return String.format("OutboundResponse(correlationId=%d, data=%s)", this.correlationId(), this.data());
        }
    }

    public static final class Inbound
    extends RaftResponse {
        private final Node source;

        public Inbound(int correlationId, ApiMessage data, Node source) {
            super(correlationId, data);
            this.source = source;
        }

        public Node source() {
            return this.source;
        }

        public String toString() {
            return String.format("InboundResponse(correlationId=%d, data=%s, source=%s)", this.correlationId(), this.data(), this.source);
        }
    }
}

