/*
 * Decompiled with CFR 0.152.
 */
package org.fibs.geotag.gui.menus;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.fibs.geotag.Settings;
import org.fibs.geotag.data.ImageInfo;
import org.fibs.geotag.gui.menus.MenuConstants;
import org.fibs.geotag.image.ThumbnailWorker;
import org.fibs.geotag.table.ImagesTable;
import org.fibs.geotag.table.ImagesTableModel;
import org.fibs.geotag.tasks.TaskExecutor;
import org.fibs.geotag.tasks.ThumbnailsTask;
import org.fibs.geotag.util.BrowserLauncher;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class ShowOnMapMenu
extends JMenu
implements ActionListener,
MenuConstants {
    private static final I18n i18n = I18nFactory.getI18n(ShowOnMapMenu.class);
    private static final int DEFAULT_GOOGLE_ZOOM_LEVEL = 15;
    private static final String SHOW_ON_MAP = i18n.tr("Show on map");
    private static final String SHOW_ON_MAP_WITH_DIRECTION = i18n.tr("Show on map (with direction)");
    private JMenuItem showOneOnMapItem;
    private JMenuItem showSelectedOnMapItem;
    private JMenuItem showAllOnMapItem;
    private ImagesTable imagesTable;
    private ImageInfo imageInfo;
    private boolean withDirection;

    public ShowOnMapMenu(boolean backgroundTask, ImagesTable imagesTable, ImageInfo imageInfo, boolean withDirection) {
        super(withDirection ? SHOW_ON_MAP_WITH_DIRECTION : SHOW_ON_MAP);
        this.imagesTable = imagesTable;
        this.imageInfo = imageInfo;
        this.withDirection = withDirection;
        this.showOneOnMapItem = new JMenuItem(SHOW_THIS_IMAGE);
        boolean enabled = true;
        this.showOneOnMapItem.setEnabled(enabled);
        this.showOneOnMapItem.addActionListener(this);
        this.add(this.showOneOnMapItem);
        this.showSelectedOnMapItem = new JMenuItem(SHOW_SELECTED_IMAGES);
        enabled = !backgroundTask && imagesTable.getSelectedRows().length > 0;
        this.showSelectedOnMapItem.setEnabled(enabled);
        this.showSelectedOnMapItem.addActionListener(this);
        this.add(this.showSelectedOnMapItem);
        this.showAllOnMapItem = new JMenuItem(SHOW_ALL_IMAGES);
        enabled = !backgroundTask;
        this.showAllOnMapItem.setEnabled(enabled);
        this.showAllOnMapItem.addActionListener(this);
        this.add(this.showAllOnMapItem);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.showOneOnMapItem) {
            this.showOneImageOnMap(this.withDirection);
        } else if (event.getSource() == this.showSelectedOnMapItem) {
            this.showSelectedImagesOnMap(this.withDirection);
        } else if (event.getSource() == this.showAllOnMapItem) {
            this.showAllImagesOnMap(this.withDirection);
        }
    }

    private void showOneImageOnMap(boolean showDirection) {
        ArrayList<ImageInfo> images = new ArrayList<ImageInfo>();
        images.add(this.imageInfo);
        this.showImagesOnMap(images, showDirection);
    }

    private void showSelectedImagesOnMap(boolean showDirection) {
        ImagesTableModel tableModel = (ImagesTableModel)this.imagesTable.getModel();
        int[] selectedRows = this.imagesTable.getSelectedRows();
        ArrayList<ImageInfo> images = new ArrayList<ImageInfo>();
        int index = 0;
        while (index < selectedRows.length) {
            images.add(tableModel.getImageInfo(selectedRows[index]));
            ++index;
        }
        this.showImagesOnMap(images, showDirection);
    }

    private void showAllImagesOnMap(boolean showDirection) {
        ImagesTableModel tableModel = (ImagesTableModel)this.imagesTable.getModel();
        ArrayList<ImageInfo> images = new ArrayList<ImageInfo>();
        int index = 0;
        while (index < tableModel.getRowCount()) {
            images.add(tableModel.getImageInfo(index));
            ++index;
        }
        this.showImagesOnMap(images, showDirection);
    }

    private void showImagesOnMap(final List<ImageInfo> images, final boolean showDirection) {
        if (images.size() == 1) {
            TaskExecutor.execute(new ThumbnailWorker(images.get(0)){

                @Override
                public void done() {
                    ShowOnMapMenu.this.showOnMap(images, showDirection);
                }
            });
        } else {
            TaskExecutor.execute(new ThumbnailsTask(i18n.tr("Generate thumbnails"), images){

                @Override
                public void done() {
                    ShowOnMapMenu.this.showOnMap(images, showDirection);
                }
            });
        }
    }

    void showOnMap(List<ImageInfo> images, boolean showDirection) {
        String latitude = Double.toString(51.477222222222224);
        String longitude = Double.toString(0.0);
        int defaultZoomLevel = 5;
        int zoomLevel = 5;
        latitude = Settings.get(Settings.SETTING.LAST_GOOGLE_MAPS_LATITUDE, latitude);
        longitude = Settings.get(Settings.SETTING.LAST_GOOGLE_MAPS_LONGITUDE, longitude);
        if ((zoomLevel = Settings.get(Settings.SETTING.LAST_GOOGLE_MAPS_ZOOM_LEVEL, zoomLevel)) > 6) {
            zoomLevel -= 2;
        }
        for (ImageInfo image : images) {
            if (image.getGpsLatitude() == null || image.getGpsLongitude() == null) continue;
            latitude = image.getGpsLatitude();
            longitude = image.getGpsLongitude();
            zoomLevel = Settings.get(Settings.SETTING.LAST_GOOGLE_MAPS_ZOOM_LEVEL, 15);
            break;
        }
        String url = "http://localhost:4321/map/map.html?";
        url = String.valueOf(url) + "apiVersion=3&";
        url = String.valueOf(url) + "latitude=" + latitude + "&longitude=" + longitude + "&direction=" + showDirection + "&zoom=" + zoomLevel + "&images=";
        int index = 0;
        while (index < images.size()) {
            url = String.valueOf(url) + (index == 0 ? "" : "_") + images.get(index).getSequenceNumber();
            ++index;
        }
        url = String.valueOf(url) + "&language=" + Locale.getDefault().getLanguage() + "&maptype=" + Settings.get(Settings.SETTING.LAST_GOOGLE_MAPS_MAP_TYPE, "Hybrid");
        url = String.valueOf(url) + "&menuopen=" + Settings.get(Settings.SETTING.GOOGLE_MAPS_MENU_OPEN, true);
        url = String.valueOf(url) + "&wheelzoom=" + Settings.get(Settings.SETTING.GOOGLE_MAPS_MOUSE_WHEEL_ZOOM, false);
        url = String.valueOf(url) + "&showtracks=" + Settings.get(Settings.SETTING.GOOGLE_MAP_SHOW_TRACKS, false);
        url = String.valueOf(url) + "&wikipedia=" + Settings.get(Settings.SETTING.GOOGLE_MAP_SHOW_WIKIPEDIA, false);
        System.out.println(url);
        BrowserLauncher.openURL(Settings.get(Settings.SETTING.BROWSER, null), url.toString());
    }
}

