/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.core.util.string;

import org.apache.wicket.request.Response;
import org.apache.wicket.util.string.Strings;
import org.apache.wicket.util.value.AttributeMap;

public class JavaScriptUtils {
    public static final String SCRIPT_CONTENT_PREFIX = "\n/*<![CDATA[*/\n";
    public static final String SCRIPT_CONTENT_SUFFIX = "\n/*]]>*/\n";
    public static final String SCRIPT_OPEN_TAG = "<script type=\"text/javascript\">\n/*<![CDATA[*/\n";
    public static final String SCRIPT_CLOSE_TAG = "\n/*]]>*/\n</script>\n";
    public static final String ATTR_ID = "id";
    public static final String ATTR_TYPE = "type";
    public static final String ATTR_SCRIPT_SRC = "src";
    public static final String ATTR_SCRIPT_DEFER = "defer";
    public static final String ATTR_SCRIPT_ASYNC = "async";
    public static final String ATTR_CSP_NONCE = "nonce";
    public static final String ATTR_CROSS_ORIGIN = "crossOrigin";
    public static final String ATTR_INTEGRITY = "integrity";
    private final Response response;

    public JavaScriptUtils(Response response, String id) {
        this.response = response;
        JavaScriptUtils.writeOpenTag(response, id);
    }

    public JavaScriptUtils(Response response) {
        this.response = response;
        JavaScriptUtils.writeOpenTag(response);
    }

    public static CharSequence escapeQuotes(CharSequence input) {
        CharSequence s = input;
        if (s != null) {
            s = Strings.replaceAll(s, "'", "\\'");
            s = Strings.replaceAll(s, "\"", "\\\"");
        }
        return s;
    }

    @Deprecated
    public static void writeJavaScriptUrl(Response response, CharSequence url, String id) {
        JavaScriptUtils.writeJavaScriptUrl(response, url, id, false, null, false);
    }

    @Deprecated
    public static void writeJavaScriptUrl(Response response, CharSequence url, String id, boolean defer, String charset) {
        JavaScriptUtils.writeJavaScriptUrl(response, url, id, defer, charset, false);
    }

    @Deprecated
    public static void writeJavaScriptUrl(Response response, CharSequence url, String id, boolean defer, String charset, boolean async) {
        AttributeMap attributes = new AttributeMap();
        attributes.putAttribute(ATTR_TYPE, "text/javascript");
        attributes.putAttribute(ATTR_SCRIPT_SRC, url);
        attributes.putAttribute(ATTR_ID, id);
        attributes.putAttribute(ATTR_SCRIPT_DEFER, defer);
        attributes.putAttribute(ATTR_SCRIPT_ASYNC, async);
        attributes.putAttribute("charset", charset);
        JavaScriptUtils.writeScript(response, attributes);
    }

    public static void writeScript(Response response, AttributeMap attributes) {
        response.write("<script");
        response.write(attributes.toCharSequence());
        response.write("></script>");
        response.write("\n");
    }

    @Deprecated
    public static void writeJavaScriptUrl(Response response, CharSequence url) {
        JavaScriptUtils.writeJavaScriptUrl(response, url, null);
    }

    public static void writeJavaScript(Response response, CharSequence text, String id) {
        JavaScriptUtils.writeOpenTag(response, id);
        response.write(Strings.replaceAll(text, "</", "<\\/"));
        JavaScriptUtils.writeCloseTag(response);
    }

    public static void writeInlineScript(Response response, CharSequence text, AttributeMap attributes) {
        JavaScriptUtils.writeOpenTag(response, attributes);
        response.write(Strings.replaceAll(text, "</", "<\\/"));
        JavaScriptUtils.writeCloseTag(response);
    }

    public static void writeJavaScript(Response response, CharSequence text) {
        AttributeMap attributes = new AttributeMap();
        attributes.putAttribute(ATTR_TYPE, "text/javascript");
        JavaScriptUtils.writeInlineScript(response, text, attributes);
    }

    @Deprecated
    public static void writeOpenTag(Response response, String id) {
        AttributeMap attributes = new AttributeMap();
        attributes.putAttribute(ATTR_TYPE, "text/javascript");
        attributes.putAttribute(ATTR_ID, id);
        JavaScriptUtils.writeOpenTag(response, attributes);
    }

    public static void writeOpenTag(Response response, AttributeMap attributes) {
        response.write("<script");
        response.write(attributes.toCharSequence());
        response.write(">");
        response.write(SCRIPT_CONTENT_PREFIX);
    }

    @Deprecated
    public static void writeOpenTag(Response response) {
        AttributeMap attributes = new AttributeMap();
        attributes.putAttribute(ATTR_TYPE, "text/javascript");
        JavaScriptUtils.writeOpenTag(response, attributes);
    }

    public static void writeCloseTag(Response response) {
        response.write(SCRIPT_CONTENT_SUFFIX);
        response.write("</script>\n");
    }

    public void write(CharSequence script) {
        this.response.write(script);
    }

    public void println(CharSequence script) {
        this.response.write(script);
    }

    public void close() {
        JavaScriptUtils.writeCloseTag(this.response);
    }
}

