/*
 * Decompiled with CFR 0.152.
 */
package io.github.classgraph;

import io.github.classgraph.Resource;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nonapi.io.github.classgraph.utils.CollectionUtils;

public class ResourceList
extends ArrayList<Resource>
implements AutoCloseable {
    static final long serialVersionUID = 1L;
    static final ResourceList EMPTY_LIST = new ResourceList(){

        @Override
        public boolean add(Resource e) {
            throw new IllegalArgumentException("List is immutable");
        }

        @Override
        public void add(int index, Resource element) {
            throw new IllegalArgumentException("List is immutable");
        }

        @Override
        public boolean remove(Object o) {
            throw new IllegalArgumentException("List is immutable");
        }

        @Override
        public Resource remove(int index) {
            throw new IllegalArgumentException("List is immutable");
        }

        @Override
        public boolean addAll(Collection<? extends Resource> c) {
            throw new IllegalArgumentException("List is immutable");
        }

        @Override
        public boolean addAll(int index, Collection<? extends Resource> c) {
            throw new IllegalArgumentException("List is immutable");
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new IllegalArgumentException("List is immutable");
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new IllegalArgumentException("List is immutable");
        }

        @Override
        public void clear() {
            throw new IllegalArgumentException("List is immutable");
        }

        @Override
        public Resource set(int index, Resource element) {
            throw new IllegalArgumentException("List is immutable");
        }
    };
    private static final ResourceFilter CLASSFILE_FILTER = new ResourceFilter(){

        @Override
        public boolean accept(Resource resource) {
            String path = resource.getPath();
            if (!path.endsWith(".class") || path.length() < 7) {
                return false;
            }
            char c = path.charAt(path.length() - 7);
            return c != '/' && c != '.';
        }
    };

    ResourceList() {
    }

    ResourceList(int sizeHint) {
        super(sizeHint);
    }

    ResourceList(Collection<Resource> collection) {
        super(collection);
    }

    public List<String> getPaths() {
        ArrayList<String> resourcePaths = new ArrayList<String>(this.size());
        for (Resource resource : this) {
            resourcePaths.add(resource.getPath());
        }
        return resourcePaths;
    }

    public List<String> getPathsRelativeToClasspathElement() {
        ArrayList<String> resourcePaths = new ArrayList<String>(this.size());
        for (Resource resource : this) {
            resourcePaths.add(resource.getPath());
        }
        return resourcePaths;
    }

    public List<URL> getURLs() {
        ArrayList<URL> resourceURLs = new ArrayList<URL>(this.size());
        for (Resource resource : this) {
            resourceURLs.add(resource.getURL());
        }
        return resourceURLs;
    }

    public ResourceList classFilesOnly() {
        return this.filter(CLASSFILE_FILTER);
    }

    public ResourceList nonClassFilesOnly() {
        return this.filter(new ResourceFilter(){

            @Override
            public boolean accept(Resource resource) {
                return !CLASSFILE_FILTER.accept(resource);
            }
        });
    }

    public Map<String, ResourceList> asMap() {
        HashMap<String, ResourceList> pathToResourceList = new HashMap<String, ResourceList>();
        for (Resource resource : this) {
            String path = resource.getPath();
            ResourceList resourceList = (ResourceList)pathToResourceList.get(path);
            if (resourceList == null) {
                resourceList = new ResourceList(1);
                pathToResourceList.put(path, resourceList);
            }
            resourceList.add(resource);
        }
        return pathToResourceList;
    }

    public List<Map.Entry<String, ResourceList>> findDuplicatePaths() {
        ArrayList<Map.Entry<String, ResourceList>> duplicatePaths = new ArrayList<Map.Entry<String, ResourceList>>();
        for (Map.Entry<String, ResourceList> pathAndResourceList : this.asMap().entrySet()) {
            if (pathAndResourceList.getValue().size() <= 1) continue;
            duplicatePaths.add(new AbstractMap.SimpleEntry<String, ResourceList>(pathAndResourceList.getKey(), pathAndResourceList.getValue()));
        }
        CollectionUtils.sortIfNotEmpty(duplicatePaths, new Comparator<Map.Entry<String, ResourceList>>(){

            @Override
            public int compare(Map.Entry<String, ResourceList> o1, Map.Entry<String, ResourceList> o2) {
                return o1.getKey().compareTo(o2.getKey());
            }
        });
        return duplicatePaths;
    }

    public ResourceList filter(ResourceFilter filter) {
        ResourceList resourcesFiltered = new ResourceList();
        for (Resource resource : this) {
            if (!filter.accept(resource)) continue;
            resourcesFiltered.add(resource);
        }
        return resourcesFiltered;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forEachByteArray(ByteArrayConsumer byteArrayConsumer, boolean ignoreIOExceptions) {
        for (Resource resource : this) {
            try {
                byte[] resourceContent = resource.load();
                byteArrayConsumer.accept(resource, resourceContent);
            }
            catch (IOException e) {
                if (ignoreIOExceptions) continue;
                throw new IllegalArgumentException("Could not load resource " + resource, e);
            }
            finally {
                resource.close();
            }
        }
    }

    public void forEachByteArray(ByteArrayConsumer byteArrayConsumer) {
        this.forEachByteArray(byteArrayConsumer, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forEachInputStream(InputStreamConsumer inputStreamConsumer, boolean ignoreIOExceptions) {
        for (Resource resource : this) {
            try {
                inputStreamConsumer.accept(resource, resource.open());
            }
            catch (IOException e) {
                if (ignoreIOExceptions) continue;
                throw new IllegalArgumentException("Could not load resource " + resource, e);
            }
            finally {
                resource.close();
            }
        }
    }

    public void forEachInputStream(InputStreamConsumer inputStreamConsumer) {
        this.forEachInputStream(inputStreamConsumer, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forEachByteBuffer(ByteBufferConsumer byteBufferConsumer, boolean ignoreIOExceptions) {
        for (Resource resource : this) {
            try {
                ByteBuffer byteBuffer = resource.read();
                byteBufferConsumer.accept(resource, byteBuffer);
            }
            catch (IOException e) {
                if (ignoreIOExceptions) continue;
                throw new IllegalArgumentException("Could not load resource " + resource, e);
            }
            finally {
                resource.close();
            }
        }
    }

    public void forEachByteBuffer(ByteBufferConsumer byteBufferConsumer) {
        this.forEachByteBuffer(byteBufferConsumer, false);
    }

    @Override
    public void close() {
        for (Resource resource : this) {
            resource.close();
        }
    }

    @FunctionalInterface
    public static interface ByteBufferConsumer {
        public void accept(Resource var1, ByteBuffer var2);
    }

    @FunctionalInterface
    public static interface InputStreamConsumer {
        public void accept(Resource var1, InputStream var2);
    }

    @FunctionalInterface
    public static interface ByteArrayConsumer {
        public void accept(Resource var1, byte[] var2);
    }

    @FunctionalInterface
    public static interface ResourceFilter {
        public boolean accept(Resource var1);
    }
}

