/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.snakeyaml.engine.v1.representer;

import com.hazelcast.org.snakeyaml.engine.v1.api.RepresentToNode;
import com.hazelcast.org.snakeyaml.engine.v1.common.FlowStyle;
import com.hazelcast.org.snakeyaml.engine.v1.common.ScalarStyle;
import com.hazelcast.org.snakeyaml.engine.v1.nodes.AnchorNode;
import com.hazelcast.org.snakeyaml.engine.v1.nodes.MappingNode;
import com.hazelcast.org.snakeyaml.engine.v1.nodes.Node;
import com.hazelcast.org.snakeyaml.engine.v1.nodes.NodeTuple;
import com.hazelcast.org.snakeyaml.engine.v1.nodes.ScalarNode;
import com.hazelcast.org.snakeyaml.engine.v1.nodes.SequenceNode;
import com.hazelcast.org.snakeyaml.engine.v1.nodes.Tag;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public abstract class BaseRepresenter {
    protected final Map<Class<?>, RepresentToNode> representers = new HashMap();
    protected RepresentToNode nullRepresenter;
    protected final Map<Class<?>, RepresentToNode> multiRepresenters = new LinkedHashMap();
    protected ScalarStyle defaultScalarStyle = ScalarStyle.PLAIN;
    protected FlowStyle defaultFlowStyle = FlowStyle.AUTO;
    protected final Map<Object, Node> representedObjects = new IdentityHashMap<Object, Node>(){

        @Override
        public Node put(Object key, Node value) {
            return super.put(key, new AnchorNode(value));
        }
    };
    protected Object objectToRepresent;

    abstract RepresentToNode getDefaultRepresent();

    public Node represent(Object data) {
        Node node = this.representData(data);
        this.representedObjects.clear();
        this.objectToRepresent = null;
        return node;
    }

    protected final Node representData(Object data) {
        Node node;
        this.objectToRepresent = data;
        if (this.representedObjects.containsKey(this.objectToRepresent)) {
            Node node2 = this.representedObjects.get(this.objectToRepresent);
            return node2;
        }
        if (data == null) {
            Node node3 = this.nullRepresenter.representData(null);
            return node3;
        }
        Class<?> clazz = data.getClass();
        if (this.representers.containsKey(clazz)) {
            RepresentToNode representer = this.representers.get(clazz);
            node = representer.representData(data);
        } else {
            Object representer;
            for (Class<?> repr : this.multiRepresenters.keySet()) {
                if (repr == null || !repr.isInstance(data)) continue;
                RepresentToNode representer2 = this.multiRepresenters.get(repr);
                Node node4 = representer2.representData(data);
                return node4;
            }
            if (this.multiRepresenters.containsKey(null)) {
                representer = this.multiRepresenters.get(null);
                node = representer.representData(data);
            } else {
                representer = this.getDefaultRepresent();
                node = representer.representData(data);
            }
        }
        return node;
    }

    protected Node representScalar(Tag tag, String value, ScalarStyle style) {
        if (style == ScalarStyle.PLAIN) {
            style = this.defaultScalarStyle;
        }
        ScalarNode node = new ScalarNode(tag, value, style);
        return node;
    }

    protected Node representScalar(Tag tag, String value) {
        return this.representScalar(tag, value, ScalarStyle.PLAIN);
    }

    protected Node representSequence(Tag tag, Iterable<?> sequence, FlowStyle flowStyle) {
        int size = 10;
        if (sequence instanceof List) {
            size = ((List)sequence).size();
        }
        ArrayList<Node> value = new ArrayList<Node>(size);
        SequenceNode node = new SequenceNode(tag, value, flowStyle);
        this.representedObjects.put(this.objectToRepresent, node);
        FlowStyle bestStyle = FlowStyle.FLOW;
        for (Object item : sequence) {
            Node nodeItem = this.representData(item);
            if (!(nodeItem instanceof ScalarNode) || !((ScalarNode)nodeItem).isPlain()) {
                bestStyle = FlowStyle.BLOCK;
            }
            value.add(nodeItem);
        }
        if (flowStyle == FlowStyle.AUTO) {
            if (this.defaultFlowStyle != FlowStyle.AUTO) {
                node.setFlowStyle(this.defaultFlowStyle);
            } else {
                node.setFlowStyle(bestStyle);
            }
        }
        return node;
    }

    protected Node representMapping(Tag tag, Map<?, ?> mapping, FlowStyle flowStyle) {
        ArrayList<NodeTuple> value = new ArrayList<NodeTuple>(mapping.size());
        MappingNode node = new MappingNode(tag, value, flowStyle);
        this.representedObjects.put(this.objectToRepresent, node);
        FlowStyle bestStyle = FlowStyle.FLOW;
        for (Map.Entry<?, ?> entry : mapping.entrySet()) {
            Node nodeKey = this.representData(entry.getKey());
            Node nodeValue = this.representData(entry.getValue());
            if (!(nodeKey instanceof ScalarNode) || !((ScalarNode)nodeKey).isPlain()) {
                bestStyle = FlowStyle.BLOCK;
            }
            if (!(nodeValue instanceof ScalarNode) || !((ScalarNode)nodeValue).isPlain()) {
                bestStyle = FlowStyle.BLOCK;
            }
            value.add(new NodeTuple(nodeKey, nodeValue));
        }
        if (flowStyle == FlowStyle.AUTO) {
            if (this.defaultFlowStyle != FlowStyle.AUTO) {
                node.setFlowStyle(this.defaultFlowStyle);
            } else {
                node.setFlowStyle(bestStyle);
            }
        }
        return node;
    }
}

