/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.fit.internal;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.uima.fit.internal.LegacySupport;
import org.apache.uima.fit.internal.MetaDataType;
import org.apache.uima.resource.ResourceInitializationException;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public final class MetaDataUtil {
    private MetaDataUtil() {
    }

    public static String[] scanImportsAndManifests(MetaDataType aType) throws ResourceInitializationException {
        ArrayList<String> patterns = new ArrayList<String>();
        for (String property : MetaDataUtil.getImportProperties(aType)) {
            patterns.addAll(Arrays.asList(System.getProperty(property, "").split(";")));
        }
        for (String mfUrl : MetaDataUtil.resolve(MetaDataUtil.getManifestLocations(aType))) {
            InputStream is = null;
            try {
                is = new URL(mfUrl).openStream();
                List lines = IOUtils.readLines((InputStream)is);
                patterns.addAll(lines);
            }
            catch (IOException e) {
                try {
                    throw new ResourceInitializationException((Throwable)e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(is);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((InputStream)is);
        }
        return patterns.toArray(new String[patterns.size()]);
    }

    public static String[] resolve(String ... patterns) throws ResourceInitializationException {
        HashSet<String> locations = new HashSet<String>();
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        try {
            for (String pattern : new TreeSet<String>(Arrays.asList(patterns))) {
                String p = pattern.trim();
                if (p.length() == 0) continue;
                for (Resource r : resolver.getResources(pattern)) {
                    locations.add(r.getURL().toString());
                }
            }
            return locations.toArray(new String[locations.size()]);
        }
        catch (IOException e) {
            throw new ResourceInitializationException((Throwable)e);
        }
    }

    public static String[] getManifestLocations(MetaDataType aType) {
        ArrayList<String> locations = new ArrayList<String>();
        switch (aType) {
            case FS_INDEX: {
                locations.add("classpath*:META-INF/org.apache.uima.fit/fsindexes.txt");
                break;
            }
            case TYPE_SYSTEM: {
                locations.add("classpath*:META-INF/org.apache.uima.fit/types.txt");
                break;
            }
            case TYPE_PRIORITIES: {
                locations.add("classpath*:META-INF/org.apache.uima.fit/typepriorities.txt");
            }
        }
        return locations.toArray(new String[locations.size()]);
    }

    public static String[] getImportProperties(MetaDataType aType) {
        ArrayList<String> locations = new ArrayList<String>();
        switch (aType) {
            case FS_INDEX: {
                locations.add("org.apache.uima.fit.fsindex.import_pattern");
                break;
            }
            case TYPE_SYSTEM: {
                locations.add("org.apache.uima.fit.type.import_pattern");
                break;
            }
            case TYPE_PRIORITIES: {
                locations.add("org.apache.uima.fit.typepriorities.import_pattern");
            }
        }
        return locations.toArray(new String[locations.size()]);
    }

    public static String[] scanDescriptors(MetaDataType aType) throws ResourceInitializationException {
        Object[] locations1 = MetaDataUtil.resolve(MetaDataUtil.scanImportsAndManifests(aType));
        Object[] locations2 = LegacySupport.getInstance().scanTypeDescriptors(aType);
        return (String[])ArrayUtils.addAll((Object[])locations1, (Object[])locations2);
    }
}

