/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.internal.util;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.apache.uima.UIMAFramework;
import org.apache.uima.cas.impl.FSClassRegistry;
import org.apache.uima.cas.impl.TypeSystemImpl;
import org.apache.uima.internal.util.Misc;
import org.apache.uima.spi.FsIndexCollectionProvider;
import org.apache.uima.spi.JCasClassProvider;
import org.apache.uima.spi.TypePrioritiesProvider;
import org.apache.uima.spi.TypeSystemDescriptionProvider;
import org.apache.uima.spi.TypeSystemProvider;

public class UIMAClassLoader
extends URLClassLoader {
    private static final URL[] NO_URLS = new URL[0];
    public static final String MHLC = "org.apache.uima.cas.impl.MethodHandlesLookup";
    static byte[] methodHandlesLookupClass;
    private static final int nbrLocks;
    private final Object[] syncLocks = new Object[nbrLocks];
    private boolean isClosed = false;

    public static URL[] transformClasspath(String classpath) throws MalformedURLException {
        StringTokenizer tok = new StringTokenizer(classpath, File.pathSeparator);
        ArrayList<String> pathList = new ArrayList<String>();
        while (tok.hasMoreTokens()) {
            pathList.add(tok.nextToken());
        }
        int max = pathList.size();
        URL[] urlArray = new URL[max];
        for (int i = 0; i < max; ++i) {
            urlArray[i] = new File((String)pathList.get(i)).toURI().toURL();
        }
        return urlArray;
    }

    public UIMAClassLoader(String classpath) throws MalformedURLException {
        super(Misc.classpath2urls(classpath));
        this.commonInit();
    }

    public UIMAClassLoader(URL[] classpath) {
        super(classpath);
        this.commonInit();
    }

    public UIMAClassLoader(ClassLoader parent) {
        super(NO_URLS, parent);
        this.commonInit();
    }

    public UIMAClassLoader(URL[] classpath, ClassLoader parent) {
        super(classpath, parent);
        this.commonInit();
    }

    public UIMAClassLoader(String classpath, ClassLoader parent) throws MalformedURLException {
        super(Misc.classpath2urls(classpath), parent);
        this.commonInit();
    }

    private void commonInit() {
        for (int i = 0; i < nbrLocks; ++i) {
            this.syncLocks[i] = new Object();
        }
    }

    public static URLClassLoader newInstance(URL[] urls) {
        throw new UnsupportedOperationException();
    }

    public static URLClassLoader newInstance(URL[] urls, ClassLoader parent) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Object object = this.syncLocks[name.hashCode() & nbrLocks - 1];
        synchronized (object) {
            Class<?> c = null;
            if (c == null) {
                c = this.findLoadedClass(name);
            }
            if (c == null) {
                try {
                    c = MHLC.equals(name) ? this.defineClass(MHLC, methodHandlesLookupClass, 0, methodHandlesLookupClass.length) : this.findClass(name);
                }
                catch (ClassNotFoundException e) {
                    c = this.isUimaInternalPackage(name) ? UIMAFramework.class.getClassLoader().loadClass(name) : super.loadClass(name, false);
                }
            }
            if (resolve) {
                this.resolveClass(c);
            }
            if (this.isUimaSpiImplementation(c)) {
                ClassLoader parent = this.getParent();
                c = parent != null ? parent.loadClass(name) : ClassLoader.getSystemClassLoader().loadClass(name);
            }
            return c;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        Object object = this.syncLocks[name.hashCode() & nbrLocks - 1];
        synchronized (object) {
            ClassLoader parent = this.getParent();
            Enumeration<URL> delegateResources = parent != null ? parent.getResources(name) : ClassLoader.getSystemClassLoader().getResources(name);
            Enumeration<Object> localResources = Collections.emptyEnumeration();
            if (!this.isUimaSpiConfigurationFile(name)) {
                localResources = this.findResources(name);
            }
            return new CombinedEnumeration<URL>(localResources, delegateResources);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public URL getResource(String name) {
        Object object = this.syncLocks[name.hashCode() & nbrLocks - 1];
        synchronized (object) {
            if (this.isUimaSpiConfigurationFile(name)) {
                ClassLoader parent = this.getParent();
                if (parent != null) {
                    return parent.getResource(name);
                }
                return ClassLoader.getSystemClassLoader().getResource(name);
            }
            URL url = this.findResource(name);
            if (null == url) {
                url = super.getResource(name);
            }
            return url;
        }
    }

    private boolean isUimaSpiImplementation(Class<?> c) {
        return TypeSystemProvider.class.isAssignableFrom(c) || TypeSystemDescriptionProvider.class.isAssignableFrom(c) || JCasClassProvider.class.isAssignableFrom(c) || FsIndexCollectionProvider.class.isAssignableFrom(c) || TypePrioritiesProvider.class.isAssignableFrom(c);
    }

    private boolean isUimaInternalPackage(String name) {
        return name.startsWith("org.apache.uima.cas.impl.") || name.startsWith("org.apache.uima.jcas.cas.");
    }

    private boolean isUimaSpiConfigurationFile(String name) {
        return name.contains("META-INF/services/org.apache.uima.spi.");
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    @Override
    public void close() throws IOException {
        this.isClosed = true;
        if (TypeSystemImpl.staticTsi != null) {
            FSClassRegistry.unregister_jcci_classloader(this);
        }
        super.close();
    }

    Object getClassLoadingLockForTesting(String aClassName) {
        return super.getClassLoadingLock(aClassName);
    }

    static {
        if (!ClassLoader.registerAsParallelCapable()) {
            System.err.println("WARNING - Failed to register the UIMA Class loader as parallel-capable - should never happen");
        }
        methodHandlesLookupClass = Misc.hex_string_to_bytearray("CAFEBABE00000034001B07000201002C6F72672F6170616368652F75696D612F6361732F696D706C2F4D6574686F6448616E646C65734C6F6F6B75700700040100106A6176612F6C616E672F4F626A6563740100063C696E69743E010003282956010004436F64650A000300090C0005000601000F4C696E654E756D6265725461626C650100124C6F63616C5661726961626C655461626C650100047468697301002E4C6F72672F6170616368652F75696D612F6361732F696D706C2F4D6574686F6448616E646C65734C6F6F6B75703B0100166765744D6574686F6448616E646C65734C6F6F6B757001002928294C6A6176612F6C616E672F696E766F6B652F4D6574686F6448616E646C6573244C6F6F6B75703B0A0011001307001201001E6A6176612F6C616E672F696E766F6B652F4D6574686F6448616E646C65730C0014000F0100066C6F6F6B757001000A536F7572636546696C650100184D6574686F6448616E646C65734C6F6F6B75702E6A61766101000C496E6E6572436C61737365730700190100256A6176612F6C616E672F696E766F6B652F4D6574686F6448616E646C6573244C6F6F6B75700100064C6F6F6B7570002100010003000000000002000200050006000100070000002F00010001000000052AB70008B100000002000A0000000600010000001A000B0000000C000100000005000C000D00000009000E000F00010007000000240001000000000004B80010B000000002000A0000000600010000001D000B0000000200000002001500000002001600170000000A000100180011001A0019");
        nbrLocks = Misc.nextHigherPowerOf2(Runtime.getRuntime().availableProcessors());
    }

    private static class CombinedEnumeration<T>
    implements Enumeration<T> {
        private final Enumeration<T> first;
        private final Enumeration<T> second;

        public CombinedEnumeration(Enumeration<T> first, Enumeration<T> second) {
            this.first = first;
            this.second = second;
        }

        @Override
        public boolean hasMoreElements() {
            return this.first.hasMoreElements() || this.second.hasMoreElements();
        }

        @Override
        public T nextElement() {
            if (this.first.hasMoreElements()) {
                return this.first.nextElement();
            }
            if (this.second.hasMoreElements()) {
                return this.second.nextElement();
            }
            throw new NoSuchElementException("No more elements");
        }
    }
}

