/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.analysis_engine.impl;

import java.util.ArrayList;
import org.apache.uima.analysis_engine.impl.RsLang;

public class RsLangs {
    private ArrayList<String> languages;
    private boolean isShared = false;

    private RsLangs() {
    }

    static RsLangs createSharableEmpty() {
        RsLangs rsl = new RsLangs();
        rsl.setShared();
        return rsl;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName() + " [languages=");
        if (this.languages != null) {
            for (String l : this.languages) {
                builder.append(l).append(',');
            }
        }
        builder.append(", isShared=");
        builder.append(this.isShared);
        builder.append(']');
        return builder.toString();
    }

    static RsLangs createOrNull(String[] languages) {
        return RsLangs.replaceAll(null, languages);
    }

    void setShared() {
        this.isShared = true;
    }

    static RsLangs createOrNull(RsLangs rsl) {
        if (null == rsl || rsl.languages == null) {
            return null;
        }
        rsl.setShared();
        return rsl;
    }

    private RsLangs(RsLangs original) {
        this.languages = null == original.languages ? null : new ArrayList<String>(original.languages);
    }

    static boolean isEmpty(RsLangs rsl) {
        return rsl == null || rsl.languages == null || rsl.languages.size() == 0;
    }

    static boolean subsumes(RsLangs rsl, String lang) {
        return RsLangs.subsumesCanonical(rsl, RsLang.getCanonicalLanguageString(lang));
    }

    static boolean subsumesCanonical(RsLangs rsl, String lang) {
        if (null == rsl || null == rsl.languages) {
            return true;
        }
        if (null == lang || lang == "x-unspecified") {
            return false;
        }
        String baseLang = RsLangs.getBaseLanguage(lang);
        for (String rsLang : rsl.languages) {
            if (!RsLangs.subsumesCanonical(rsLang, lang, baseLang)) continue;
            return true;
        }
        return false;
    }

    private static boolean subsumesCanonical(RsLangs rsl, String lang, String baseLang) {
        for (String rsLang : rsl.languages) {
            if (!RsLangs.subsumesCanonical(rsLang, lang, baseLang)) continue;
            return true;
        }
        return false;
    }

    private static boolean subsumesCanonical(String containingLang, String langToTest, String langToTestBase) {
        return containingLang == langToTest || containingLang == langToTestBase;
    }

    private static String getBaseLanguage(String language) {
        String baseLanguage = language;
        int index = language.indexOf(45);
        if (index > -1) {
            baseLanguage = RsLang.getCanonicalLanguageString(language.substring(0, index));
        }
        return baseLanguage;
    }

    static RsLangs replaceAll(RsLangs rsl, String[] langs) {
        if (rsl == null || rsl.languages == null) {
            if (langs == null || langs.length == 0) {
                return null;
            }
            if (rsl == null || rsl.isShared) {
                rsl = new RsLangs();
            }
            rsl.languages = new ArrayList(0);
        }
        return RsLangs.addAll(rsl, langs);
    }

    static RsLangs addAll(RsLangs rsl, String[] langs) {
        if (null == langs || null == rsl || null == rsl.languages) {
            return rsl;
        }
        for (String lang : langs) {
            rsl = RsLangs.add(rsl, lang);
        }
        return rsl;
    }

    static RsLangs addAll(RsLangs rsl, RsLangs rsLangs) {
        if (null == rsLangs || null == rsLangs.languages || null == rsl || null == rsl.languages) {
            return rsl;
        }
        for (String lang : rsLangs.languages) {
            rsl = RsLangs.add(rsl, lang);
        }
        return rsl;
    }

    static RsLangs add(RsLangs rsl, String lang) {
        if ((lang = RsLang.getCanonicalLanguageString(lang)) == "x-unspecified") {
            return null;
        }
        String baseLang = RsLangs.getBaseLanguage(lang);
        if (!RsLangs.subsumesCanonical(rsl, lang, baseLang)) {
            if (rsl.isShared) {
                rsl = new RsLangs(rsl);
            }
            rsl.removeSubsumedLanguages(lang, baseLang);
            rsl.languages.add(lang);
        }
        return rsl;
    }

    private void removeSubsumedLanguages(String canonicalLang, String baseLang) {
        this.languages.removeIf(s -> RsLangs.subsumesCanonical(s, canonicalLang, baseLang));
    }

    RsLangs intersect(RsLangs other) {
        if (null == other) {
            return null;
        }
        if (null == this.languages) {
            return other;
        }
        if (null == other.languages) {
            return this;
        }
        RsLangs r = new RsLangs();
        r.languages = new ArrayList(0);
        for (String lang : this.languages) {
            if (!RsLangs.subsumesCanonical(other, lang)) continue;
            r = RsLangs.add(r, lang);
        }
        for (String lang : other.languages) {
            if (!RsLangs.subsumesCanonical(this, lang)) continue;
            r = RsLangs.add(r, lang);
        }
        if (r.languages.size() == 0) {
            return null;
        }
        return r;
    }

    static String[] toArray(RsLangs rsl) {
        return RsLangs.isEmpty(rsl) ? null : rsl.languages.toArray(new String[rsl.languages.size()]);
    }

    public int hashCode() {
        int result = 31;
        for (String lang : this.languages) {
            result += lang.hashCode();
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        RsLangs other = (RsLangs)obj;
        if (this.languages == null) {
            if (other.languages != null) {
                return false;
            }
        } else {
            if (this.languages.size() != other.languages.size()) {
                return false;
            }
            for (String lang : this.languages) {
                if (other.languages.contains(lang)) continue;
                return false;
            }
        }
        return true;
    }
}

