/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.analysis_engine.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.uima.analysis_engine.ResultSpecification;
import org.apache.uima.analysis_engine.TypeOrFeature;
import org.apache.uima.analysis_engine.impl.RsFeat;
import org.apache.uima.analysis_engine.impl.RsFullFeatNames;
import org.apache.uima.analysis_engine.impl.RsLangs;
import org.apache.uima.analysis_engine.impl.RsType;
import org.apache.uima.analysis_engine.impl.RsTypesMap;
import org.apache.uima.analysis_engine.impl.TypeOrFeature_impl;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.impl.TypeSystemImpl;
import org.apache.uima.cas.text.Language;
import org.apache.uima.resource.metadata.Capability;
import org.apache.uima.resource.metadata.impl.MetaDataObject_impl;
import org.apache.uima.resource.metadata.impl.PropertyXmlInfo;
import org.apache.uima.resource.metadata.impl.XmlizationInfo;

public final class ResultSpecification_impl
extends MetaDataObject_impl
implements ResultSpecification {
    private static final long serialVersionUID = 8516517600467270594L;
    private static final String[] ARRAY_X_UNSPEC = new String[]{"x-unspecified"};
    private static final RsLangs compiledXunspecified = RsLangs.createSharableEmpty();
    public static final List<Type> EMPTY_TYPE_LIST = new ArrayList<Type>(0);
    private final RsTypesMap rsTypesMap;
    private TypeSystem mTypeSystem = null;
    private boolean needsCompilation = true;
    private final Map<String, RsLangs> rsCompiled;

    public ResultSpecification_impl() {
        this.rsTypesMap = new RsTypesMap();
        this.rsCompiled = new HashMap<String, RsLangs>();
    }

    public ResultSpecification_impl(TypeSystem aTypeSystem) {
        this();
        this.mTypeSystem = aTypeSystem;
    }

    private ResultSpecification_impl(ResultSpecification_impl original) {
        this.mTypeSystem = original.mTypeSystem;
        this.rsTypesMap = new RsTypesMap(original.rsTypesMap);
        this.needsCompilation = original.needsCompilation;
        this.rsCompiled = new HashMap<String, RsLangs>(original.rsCompiled);
        for (Map.Entry<String, RsLangs> e : this.rsCompiled.entrySet()) {
            e.getValue().setShared();
        }
    }

    @Override
    public TypeOrFeature[] getResultTypesAndFeatures() {
        return this.getResultTypesAndFeatures(true, null);
    }

    @Override
    public TypeOrFeature[] getResultTypesAndFeatures(String language) {
        return this.getResultTypesAndFeatures(false, language);
    }

    private TypeOrFeature[] getResultTypesAndFeatures(boolean skipLanguageFilter, String language) {
        ArrayList<TypeOrFeature> r = new ArrayList<TypeOrFeature>();
        if (this.rsTypesMap.nbrOfTypes() == 0 && !this.needsCompilation) {
            this.reconstructRsTypesFromCompiled();
        }
        for (RsType t : this.rsTypesMap) {
            if (t.isAllFeatures && (skipLanguageFilter || RsLangs.subsumes(t.languagesAllFeat, language))) {
                r.add(this.createTypeOrFeature(t.typeName, true, true));
            }
            if (!(!t.isSpecified || !skipLanguageFilter && !RsLangs.subsumes(t.languagesNotAllFeat, language) || t.isAllFeatures && t.languagesAllFeat.equals(t.languagesNotAllFeat))) {
                r.add(this.createTypeOrFeature(t.typeName, true, false));
            }
            if (t.features == null) continue;
            for (RsFeat f : t.features) {
                if (!skipLanguageFilter && !f.subsumes(language)) continue;
                r.add(this.createTypeOrFeature(t.typeName, f.shortFeatName));
            }
        }
        return r.toArray(new TypeOrFeature[r.size()]);
    }

    private void reconstructRsTypesFromCompiled() {
        for (Map.Entry<String, RsLangs> e : this.rsCompiled.entrySet()) {
            String tofName = e.getKey();
            int b = tofName.indexOf(58);
            if (b == -1) {
                this.rsTypesMap.add(tofName, false, e.getValue(), false);
                continue;
            }
            String typeName = tofName.substring(0, b);
            String featName = tofName.substring(b + 1);
            this.rsTypesMap.add(typeName, featName, (Object)e.getValue(), false);
        }
        for (RsType t : this.rsTypesMap) {
            if (t.hasAllFeaturesExplicitly(this.mTypeSystem) && t.allFeaturesHaveSameLangs()) {
                t.isAllFeatures = true;
                RsLangs l = t.features.features.get((int)0).languages;
                if (l != null && RsLangs.isEmpty(l)) {
                    l = null;
                }
                if (l != null) {
                    t.languagesAllFeat = t.languagesAllFeat == null ? RsLangs.createOrNull(l) : RsLangs.addAll(t.languagesAllFeat, l);
                }
                t.features = null;
            }
            if (!t.isSpecified || !t.isAllFeatures || !ResultSpecification_impl.equalsOrBothNull(t.languagesAllFeat, t.languagesNotAllFeat)) continue;
            t.isSpecified = false;
            t.languagesNotAllFeat = null;
        }
    }

    @Override
    public void setResultTypesAndFeatures(TypeOrFeature[] aTypesAndFeatures) {
        this.setResultTypesAndFeatures(aTypesAndFeatures, ARRAY_X_UNSPEC);
    }

    @Override
    public void setResultTypesAndFeatures(TypeOrFeature[] aTypesAndFeatures, String[] aLanguageIDs) {
        for (TypeOrFeature tof : aTypesAndFeatures) {
            this.addResultTof(tof, aLanguageIDs, true);
        }
    }

    private void addResultTof(TypeOrFeature tof, String[] langs, boolean replace) {
        String name = tof.getName();
        String typeName = null;
        String shortFeatName = null;
        int i = name.indexOf(58);
        if (i < 0) {
            typeName = name;
            this.rsTypesMap.add(typeName, tof.isAllAnnotatorFeatures(), langs, replace);
        } else {
            typeName = name.substring(0, i);
            shortFeatName = name.substring(i + 1);
            this.rsTypesMap.add(typeName, shortFeatName, (Object)langs, replace);
        }
        this.setCompileNeeded();
    }

    @Override
    public void addResultTypeOrFeature(TypeOrFeature aTypeOrFeature) {
        this.addResultTypeOrFeature(aTypeOrFeature, ARRAY_X_UNSPEC);
    }

    @Override
    public void addResultTypeOrFeature(TypeOrFeature tof, String[] languages) {
        this.addResultTof(tof, languages, true);
    }

    @Override
    public void addResultType(String aTypeName, boolean aAllAnnotatorFeatures) {
        this.addResultType(aTypeName, aAllAnnotatorFeatures, ARRAY_X_UNSPEC);
    }

    @Override
    public void addResultType(String aTypeName, boolean aAllAnnotatorFeatures, String[] aLanguageIDs) {
        this.rsTypesMap.add(aTypeName, aAllAnnotatorFeatures, aLanguageIDs, false);
        this.setCompileNeeded();
    }

    @Override
    public void addResultFeature(String aFullFeatureName) {
        this.addResultFeature(aFullFeatureName, ARRAY_X_UNSPEC);
    }

    @Override
    public void addResultFeature(String aFullFeatureName, String[] aLanguageIDs) {
        String typeName = null;
        String shortFeatName = null;
        int i = aFullFeatureName.indexOf(58);
        typeName = aFullFeatureName.substring(0, i);
        shortFeatName = aFullFeatureName.substring(i + 1);
        this.rsTypesMap.add(typeName, shortFeatName, (Object)aLanguageIDs, false);
        this.setCompileNeeded();
    }

    @Override
    @Deprecated
    public void compile(TypeSystem aTypeSystem) {
        this.setTypeSystem(aTypeSystem);
        this.compile();
    }

    private TypeOrFeature createTypeOrFeature(String name, boolean isType, boolean aAllAnnotatorFeatures) {
        TypeOrFeature_impl r = new TypeOrFeature_impl();
        r.setType(isType);
        r.setName(name);
        if (isType) {
            r.setAllAnnotatorFeatures(aAllAnnotatorFeatures);
        }
        return r;
    }

    private TypeOrFeature createTypeOrFeature(String typeName, String featureName) {
        return this.createTypeOrFeature(typeName + ":" + featureName, false, false);
    }

    @Override
    public boolean containsType(String aTypeName) {
        return this.containsType(aTypeName, "x-unspecified");
    }

    @Override
    public boolean containsType(String aTypeName, String aLanguage) {
        if (aTypeName.indexOf(58) != -1) {
            return false;
        }
        this.compileIfNeeded();
        return ResultSpecification_impl.hasLanguage(this.rsCompiled.get(aTypeName), aLanguage);
    }

    @Override
    public boolean containsFeature(String aFullFeatureName) {
        return this.containsFeature(aFullFeatureName, "x-unspecified");
    }

    @Override
    public boolean containsFeature(String aFullFeatureName, String aLanguage) {
        int i = aFullFeatureName.indexOf(58);
        if (i == -1) {
            return false;
        }
        this.compileIfNeeded();
        boolean found = ResultSpecification_impl.hasLanguage(this.rsCompiled.get(aFullFeatureName), aLanguage);
        if (found) {
            return true;
        }
        RsType t = this.rsTypesMap.getRsType(aFullFeatureName.substring(0, i));
        return null != t && t.isAllFeatures && RsLangs.subsumes(t.languagesAllFeat, aLanguage);
    }

    private static boolean hasLanguage(RsLangs rsLangs, String language) {
        language = Language.normalize(language);
        return rsLangs == null ? false : RsLangs.subsumes(rsLangs, language);
    }

    @Override
    protected XmlizationInfo getXmlizationInfo() {
        return new XmlizationInfo("resultSpecification", "", new PropertyXmlInfo[]{new PropertyXmlInfo("resultTypesAndFeatures", null)});
    }

    @Override
    public void addCapabilities(Capability[] capabilities) {
        this.addCapabilities(capabilities, true);
    }

    @Override
    public void addCapabilities(Capability[] capabilities, boolean outputs) {
        if (null == capabilities) {
            return;
        }
        for (Capability capability : capabilities) {
            TypeOrFeature[] tofs;
            for (TypeOrFeature tof : tofs = outputs ? capability.getOutputs() : capability.getInputs()) {
                String typeName = tof.getName();
                if (!tof.isType()) {
                    int i = typeName.indexOf(58);
                    String shortFeatName = typeName.substring(i + 1);
                    typeName = typeName.substring(0, i);
                    this.rsTypesMap.add(typeName, shortFeatName, (Object)capability.getLanguagesSupported(), false);
                    continue;
                }
                this.rsTypesMap.add(typeName, tof.isAllAnnotatorFeatures(), capability.getLanguagesSupported(), false);
            }
        }
        this.setCompileNeeded();
    }

    @Override
    public void removeTypeOrFeature(TypeOrFeature tof) {
        String name = tof.getName();
        if (tof.isType()) {
            this.rsTypesMap.remove(name);
        } else {
            int i = name.indexOf(58);
            this.rsTypesMap.remove(name.substring(0, i), name.substring(i + 1));
        }
        this.setCompileNeeded();
    }

    @Override
    public Object clone() {
        return new ResultSpecification_impl(this);
    }

    @Override
    public void setTypeSystem(TypeSystem ts) {
        this.mTypeSystem = ts;
        this.setCompileNeeded();
    }

    @Override
    public TypeSystem getTypeSystem() {
        return this.mTypeSystem;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName() + ":\n");
        sb.append("  needsCompilation = ").append(this.needsCompilation).append('\n');
        sb.append("\nrsTofLangs:\n");
        if (this.needsCompilation) {
            sb.append(this.rsTypesMap);
        } else {
            Object[] sorted = this.rsCompiled.entrySet().toArray();
            Arrays.sort(sorted, new Comparator<Object>(){

                @Override
                public int compare(Object object1, Object object2) {
                    return ((String)((Map.Entry)object1).getKey()).compareTo((String)((Map.Entry)object2).getKey());
                }
            });
            for (Object o : sorted) {
                Map.Entry e = (Map.Entry)o;
                Object k = (String)e.getKey();
                k = (String)k + "        ".substring(((String)k).length() % 8);
                sb.append(" key: ").append((String)k).append("  value: ").append(e.getValue()).append('\n');
            }
        }
        sb.append("\n\nmTypeSystem = ").append(this.mTypeSystem).append('\n');
        return sb.toString();
    }

    private void compileIfNeeded() {
        if (this.needsCompilation) {
            this.needsCompilation = false;
            this.compile();
        }
    }

    private void setCompileNeeded() {
        this.needsCompilation = true;
        this.rsCompiled.clear();
    }

    private void compile() {
        for (RsType rst : this.rsTypesMap) {
            if (rst.isSpecified) {
                this.addCompiledFormForTypeAndItsSubtypes(rst, rst.languagesNotAllFeat);
            }
            if (rst.isAllFeatures) {
                this.addCompiledFormForTypeAndItsSubtypes(rst, rst.languagesAllFeat);
                for (Feature f : rst.getAllAppropriateFeatures(this.mTypeSystem)) {
                    this.addCompiledFormForFeatureAndItsSubtypes(rst, f.getShortName(), rst.languagesAllFeat);
                }
            }
            if (rst.features == null) continue;
            for (RsFeat rsf : rst.features) {
                this.addCompiledFormForFeatureAndItsSubtypes(rst, rsf.shortFeatName, rsf.languages);
            }
        }
    }

    private void addCompiledFormForTypeAndItsSubtypes(RsType rst, RsLangs langs) {
        this.addCompiledFormEntry(rst.typeName, langs);
        for (String subtypeName : this.subtypeNames(rst.typeName)) {
            this.addCompiledFormEntry(subtypeName, langs);
        }
    }

    private void addCompiledFormForFeatureAndItsSubtypes(RsType rst, String shortFeatName, RsLangs langs) {
        this.addCompiledFormEntry(RsFullFeatNames.getFullFeatName(rst.typeName, shortFeatName), langs);
        for (String subtypeName : this.subtypeNames(rst.typeName)) {
            this.addCompiledFormEntry(RsFullFeatNames.getFullFeatName(subtypeName, shortFeatName), langs);
        }
    }

    private void addCompiledFormEntry(String tofName, RsLangs languagesToAdd) {
        RsLangs rsLangs;
        if (languagesToAdd == null) {
            languagesToAdd = compiledXunspecified;
        }
        if (null == (rsLangs = this.rsCompiled.get(tofName))) {
            if (languagesToAdd != compiledXunspecified) {
                languagesToAdd.setShared();
            }
            this.rsCompiled.put(tofName, languagesToAdd);
            return;
        }
        RsLangs.addAll(rsLangs, languagesToAdd);
    }

    private Iterable<String> subtypeNames(final String typeName) {
        final TypeSystemImpl ts = (TypeSystemImpl)this.mTypeSystem;
        return new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                return new Iterator<String>(){
                    Type t;
                    List<Type> subtypes;
                    int i;
                    {
                        Type type = this.t = null == ts ? null : ts.getType(typeName);
                        this.subtypes = null == ts ? EMPTY_TYPE_LIST : (null == this.t ? EMPTY_TYPE_LIST : ts.getProperlySubsumedTypes(this.t));
                        this.i = 0;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i < this.subtypes.size();
                    }

                    @Override
                    public String next() {
                        return this.subtypes.get(this.i++).getName();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    ResultSpecification_impl intersect(ResultSpecification_impl rsOther) {
        ResultSpecification_impl r = new ResultSpecification_impl();
        r.setTypeSystem(rsOther.mTypeSystem);
        r.compileIfNeeded();
        rsOther.compileIfNeeded();
        this.compileIfNeeded();
        for (Map.Entry<String, RsLangs> e : rsOther.rsCompiled.entrySet()) {
            RsLangs intersectRsLangs;
            String tofName = e.getKey();
            RsLangs otherRsLangs = e.getValue();
            RsLangs thisRsLangs = this.rsCompiled.get(tofName);
            if (null == thisRsLangs || (intersectRsLangs = thisRsLangs.intersect(otherRsLangs)) == null) continue;
            r.addCompiledFormEntry(tofName, intersectRsLangs);
        }
        return r;
    }

    private boolean compiledFormEquals(ResultSpecification_impl other) {
        this.compileIfNeeded();
        other.compileIfNeeded();
        return this.rsCompiled.equals(other.rsCompiled);
    }

    @Override
    public boolean equals(Object aObj) {
        if (!(aObj instanceof ResultSpecification_impl)) {
            return false;
        }
        return this.compiledFormEquals((ResultSpecification_impl)aObj);
    }

    static boolean equalsOrBothNull(Object x, Object y) {
        return null == x && null == y || null != x && x.equals(y);
    }

    @Override
    public int hashCode() {
        throw new UnsupportedOperationException("HashCode not implemented for ResultSpecification_impl");
    }
}

