/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima;

import java.util.Locale;
import org.apache.uima.internal.util.I18nUtil;

public interface I18nExceptionI {
    public String getResourceBundleName();

    public String getMessageKey();

    public Object[] getArguments();

    public Throwable getCause();

    public String getMessage();

    public String getLocalizedMessage();

    default public String getLocalizedMessage(Locale aLocale) {
        if (this.getMessageKey() == null) {
            return null;
        }
        return I18nUtil.localizeMessage(this.getResourceBundleName(), aLocale, this.getMessageKey(), this.getArguments());
    }

    default public boolean hasMessageKey(String messageKey) {
        if (messageKey.equals(this.getMessageKey())) {
            return true;
        }
        Throwable cause = this.getCause();
        if (cause instanceof I18nExceptionI) {
            I18nExceptionI i18nExceptionI = (I18nExceptionI)((Object)cause);
            return i18nExceptionI.hasMessageKey(messageKey);
        }
        return false;
    }
}

