/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.ide.ui.documentation;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.uima.ruta.ide.ui.documentation.RutaPageFolder;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.ui.DLTKPluginImages;
import org.eclipse.dltk.ui.dialogs.TimeTriggeredProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class RutaPagesLocationsBlock
implements SelectionListener,
ISelectionChangedListener {
    protected static final String LAST_PATH_SETTING = "LAST_PATH_SETTING";
    protected static final String DIALOG_SETTINGS_PREFIX = "RutaPagesLocationsBlock";
    protected boolean fInCallback = false;
    protected File fHome;
    protected TreeViewer fLocationsViewer;
    private Button fClearButton;
    private Button fRemoveButton;
    private Button fAddButton;
    protected Button fDefaultButton;
    private ManLocationsContentProvider fLocationsContentProvider;
    private PreferencePage fPage;
    private IPreferenceStore fStore;
    private List folders = null;

    public RutaPagesLocationsBlock(IPreferenceStore store, PreferencePage page) {
        this.fPage = page;
        this.fStore = store;
    }

    protected IBaseLabelProvider getLabelProvider() {
        return new LabelProvider(){

            public Image getImage(Object element) {
                if (element instanceof RutaPageFolder) {
                    return DLTKPluginImages.DESC_OBJS_LIBRARY.createImage();
                }
                return DLTKPluginImages.DESC_OBJS_INFO_OBJ.createImage();
            }

            public String getText(Object element) {
                if (element instanceof RutaPageFolder) {
                    RutaPageFolder folder = (RutaPageFolder)element;
                    return folder.getPath();
                }
                return super.getText(element);
            }
        };
    }

    private String getFoldersAsXML() {
        DocumentBuilder docBuilder;
        if (this.folders == null) {
            return null;
        }
        DocumentBuilderFactory dfactory = DocumentBuilderFactory.newInstance();
        try {
            docBuilder = dfactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e1) {
            e1.printStackTrace();
            return null;
        }
        Document doc = docBuilder.newDocument();
        Element topElement = doc.createElement("manPages");
        doc.appendChild(topElement);
        for (RutaPageFolder f : this.folders) {
            Element location = doc.createElement("location");
            topElement.appendChild(location);
            location.setAttribute("path", f.getPath());
            for (String name : f.getPages().keySet()) {
                String file = (String)f.getPages().get(name);
                Element page = doc.createElement("page");
                location.appendChild(page);
                page.setAttribute("keyword", name);
                page.setAttribute("file", file);
            }
        }
        ByteArrayOutputStream s = new ByteArrayOutputStream();
        try {
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("indent", "yes");
            DOMSource source = new DOMSource(doc);
            StreamResult outputTarget = new StreamResult(s);
            transformer.transform(source, outputTarget);
        }
        catch (TransformerConfigurationException e) {
            e.printStackTrace();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
        String result = null;
        try {
            result = s.toString("UTF8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return result;
    }

    public Control createControl(Composite parent) {
        Font font = parent.getFont();
        Composite comp = new Composite(parent, 0);
        GridLayout topLayout = new GridLayout();
        topLayout.numColumns = 2;
        topLayout.marginHeight = 0;
        topLayout.marginWidth = 0;
        comp.setLayout((Layout)topLayout);
        GridData gd = new GridData(1808);
        comp.setLayoutData((Object)gd);
        this.fLocationsViewer = new TreeViewer(comp);
        gd = new GridData(1808);
        gd.heightHint = 6;
        this.fLocationsViewer.getControl().setLayoutData((Object)gd);
        this.fLocationsContentProvider = new ManLocationsContentProvider();
        this.fLocationsViewer.setSorter(new ViewerSorter());
        this.fLocationsViewer.setContentProvider((IContentProvider)this.fLocationsContentProvider);
        this.fLocationsViewer.setLabelProvider(this.getLabelProvider());
        this.fLocationsViewer.setInput((Object)this);
        this.fLocationsViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        Composite pathButtonComp = new Composite(comp, 0);
        GridLayout pathButtonLayout = new GridLayout();
        pathButtonLayout.marginHeight = 0;
        pathButtonLayout.marginWidth = 0;
        pathButtonComp.setLayout((Layout)pathButtonLayout);
        gd = new GridData(258);
        pathButtonComp.setLayoutData((Object)gd);
        pathButtonComp.setFont(font);
        this.fAddButton = this.createPushButton(pathButtonComp, "Add folder...");
        this.fAddButton.addSelectionListener((SelectionListener)this);
        this.fRemoveButton = this.createPushButton(pathButtonComp, "Remove");
        this.fRemoveButton.addSelectionListener((SelectionListener)this);
        this.fClearButton = this.createPushButton(pathButtonComp, "Remove All");
        this.fClearButton.addSelectionListener((SelectionListener)this);
        return comp;
    }

    protected Button createPushButton(Composite parent, String label) {
        Button button = new Button(parent, 8);
        button.setFont(parent.getFont());
        button.setText(label);
        this.setButtonLayoutData(button);
        return button;
    }

    protected void setButtonLayoutData(Button button) {
        GridData data = new GridData(256);
        int widthHint = 80;
        Point minSize = button.computeSize(-1, -1, true);
        data.widthHint = Math.max(widthHint, minSize.x);
        button.setLayoutData((Object)data);
    }

    protected void createVerticalSpacer(Composite comp, int colSpan) {
        Label label = new Label(comp, 0);
        GridData gd = new GridData();
        gd.horizontalSpan = colSpan;
        label.setLayoutData((Object)gd);
    }

    public void update() {
        this.updateButtons();
        if (this.folders != null) {
            Iterator iterator = this.folders.iterator();
            while (iterator.hasNext()) {
                RutaPageFolder v = (RutaPageFolder)iterator.next();
                if (v.verify()) continue;
                iterator.remove();
            }
        }
        this.fLocationsViewer.refresh();
        this.updatePageStatus(Status.OK_STATUS);
    }

    public void setDefaults() {
        String res = this.fStore.getDefaultString("doc_ruta_pages_location");
        this.fStore.setValue("doc_ruta_pages_location", res);
        this.initialize();
    }

    protected void updatePageStatus(IStatus status) {
        if (this.fPage == null) {
            return;
        }
        this.fPage.setValid(status.isOK());
        if (!status.isOK()) {
            this.fPage.setErrorMessage(status.getMessage());
        } else {
            this.fPage.setErrorMessage(null);
        }
    }

    public void initialize() {
        String value = this.fStore.getString("doc_ruta_pages_location");
        try {
            this.folders = RutaPageFolder.readXML(value);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.update();
    }

    public void performApply() {
        String xml = this.getFoldersAsXML();
        if (xml != null) {
            this.fStore.setValue("doc_ruta_pages_location", xml);
        }
    }

    public void widgetSelected(SelectionEvent e) {
        Object source = e.getSource();
        if (source == this.fClearButton) {
            this.folders.clear();
        } else if (source == this.fRemoveButton) {
            IStructuredSelection selection = (IStructuredSelection)this.fLocationsViewer.getSelection();
            Object[] array = selection.toArray();
            block0: for (int i = 0; i < array.length; ++i) {
                if (!(array[i] instanceof RutaPageFolder)) continue;
                Iterator iterator = this.folders.iterator();
                while (iterator.hasNext()) {
                    RutaPageFolder f = (RutaPageFolder)iterator.next();
                    if (f != array[i]) continue;
                    iterator.remove();
                    continue block0;
                }
            }
        } else if (source == this.fAddButton) {
            this.add();
        }
        this.update();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    protected void add() {
        DirectoryDialog dialog = new DirectoryDialog(this.fLocationsViewer.getControl().getShell());
        dialog.setMessage("Select directory to search into");
        String result = dialog.open();
        if (result != null) {
            final File file = new File(result);
            if (this.folders == null) {
                this.folders = new ArrayList();
            }
            if (file != null && file.isDirectory()) {
                TimeTriggeredProgressMonitorDialog dialog2 = new TimeTriggeredProgressMonitorDialog(null, 500);
                try {
                    dialog2.run(true, true, new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) {
                            monitor.beginTask("Searching for man pages", 1);
                            RutaPagesLocationsBlock.this.performSearch(file);
                            monitor.done();
                        }
                    });
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void performSearch(File dir) {
        if (!dir.isDirectory()) {
            return;
        }
        String name = dir.getName();
        if (name.equals("TkLib") || name.equals("RutaLib") || name.equals("Keywords") || name.equals("UserCmd")) {
            return;
        }
        File[] childs = dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                return file.getName().startsWith("contents.htm");
            }
        });
        for (int i = 0; i < childs.length; ++i) {
            if (childs[i].isDirectory()) {
                this.performSearch(childs[i]);
            }
            if (!childs[i].getName().startsWith("contents.htm")) continue;
            RutaPageFolder folder = new RutaPageFolder(dir.getAbsolutePath());
            this.parseContentsFile(childs[i], folder);
            if (folder.getPages().size() <= 0 || this.folders.contains(folder)) continue;
            this.folders.add(folder);
        }
    }

    private void parseContentsFile(File c, RutaPageFolder folder) {
        FileReader reader;
        try {
            reader = new FileReader(c);
        }
        catch (FileNotFoundException e) {
            return;
        }
        StringBuffer buf = new StringBuffer();
        while (true) {
            char[] cbuf = new char[1024];
            try {
                int read = reader.read(cbuf);
                if (read < 0) break;
                buf.append(cbuf, 0, read);
            }
            catch (IOException e) {
                break;
            }
        }
        String result = buf.toString();
        Pattern pattern = Pattern.compile("<a\\s+href=\"([a-zA-Z_0-9]+\\.html?)\"\\s*>(\\w+)</a>", 2);
        Matcher matcher = pattern.matcher(result);
        while (matcher.find()) {
            String file = matcher.group(1);
            if (file.equalsIgnoreCase("Copyright.htm")) continue;
            String word = matcher.group(2);
            folder.addPage(word, file);
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.updateButtons();
    }

    private void updateButtons() {
        this.fClearButton.setEnabled(this.folders != null && this.folders.size() > 0);
        IStructuredSelection selection = (IStructuredSelection)this.fLocationsViewer.getSelection();
        boolean canRemove = true;
        if (this.folders == null) {
            canRemove = false;
        } else {
            Object o;
            List list = selection.toList();
            Iterator iterator = list.iterator();
            if (iterator.hasNext() && !this.folders.contains(o = iterator.next())) {
                canRemove = false;
            }
            if (selection.isEmpty()) {
                canRemove = false;
            }
        }
        this.fRemoveButton.setEnabled(canRemove);
    }

    private class ManLocationsContentProvider
    implements ITreeContentProvider {
        private ManLocationsContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof RutaPageFolder) {
                RutaPageFolder folder = (RutaPageFolder)parentElement;
                Object[] ch = new String[folder.getPages().size()];
                int i = 0;
                for (String kw : folder.getPages().keySet()) {
                    String file = (String)folder.getPages().get(kw);
                    ch[i++] = kw + " (" + file + ")";
                }
                return ch;
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return element instanceof RutaPageFolder;
        }

        public Object[] getElements(Object inputElement) {
            if (RutaPagesLocationsBlock.this.folders == null) {
                return new Object[0];
            }
            return RutaPagesLocationsBlock.this.folders.toArray(new Object[RutaPagesLocationsBlock.this.folders.size()]);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

